#define MAX_DOMAINTIME	255
#define MAX_DOMAINRETRY	255
#define MAX_IOADDR	255
#define MAX_ADDRESS	255
#define	MAX_ARPTIME	255
#define MAX_RETRANS	100
#define	MAX_MTU		1500
#define MAX_MAXSEG	4096
#define MAX_RWIN	4096
#define MAX_CONTIME	255
#define MAX_NAMESERVER	10
#define MAX_GATEWAY	10

#define TICKS		18.2

#define MIP		4
#define MNS		64
#define MDN		256

#define H_BOOTP		001
#define H_RARP		002
#define H_MYIP		004

struct conf {
	unsigned long	myip;		/* My IP address, if no BOOTP */
	unsigned long	snetmask;	/* My netmask, if no BOOTP */
	unsigned long	broadcast;	/* Broadcast address */
	unsigned char	flags;		/* Flags, like BOOTP or RARP */
	unsigned char	address;	/* Base memory address or packet */
				 	/* driver class */
	unsigned char	ioaddr;		/* I/O address of packet int vector */
	unsigned int	domaintime;	/* Domain name lookup timeout */
					/* (first retry) */
	unsigned char	domainretry;	/* Number of domain name retries */
	unsigned char	domaincount;	/* Number of domains in the list */
	unsigned int	arptime;	/* ARP timeout in seconds */
	unsigned int	retrans;	/* Retransmit timer, 1/18ths of sec */
	unsigned int	mtu;		/* Max transmit unit, in octets */
	unsigned int	maxseg;		/* Largest segment we can receive */
	unsigned int	rwin;		/* Most octets received without ACK */
	unsigned int	contime;	/* Timeout in seconds on connection */
					/* try */
	unsigned char	*domain;	/* Domain name, broken into a list */
					/* of parts */
	struct machinfo	*nsip;	/* Nameserver IP address */
	struct machinfo	*gateip;	/* Gateway IP address */
	struct machinfo	*mlist;	/* Linked list of other hosts */
					/* (host table) */
};

struct machinfo {
	unsigned long	hostip;		/* Host IP address */
	unsigned char	nameserver;	/* Nameserver priority */
	unsigned char	gateway;	/* Gateway priority */
	unsigned char	mno;		/* Machine number */
	unsigned char	*host;	/* Host name */
	unsigned char	domainsremaining;	/* Number of domains to try */
	struct machinfo	*next;	/* Pointer to the next entry */
};

#ifdef notdef
struct aconf {
	unsigned long	myip;		/* My IP address, if no BOOTP */
	unsigned long	snetmask;	/* My netmask, if no BOOTP */
	unsigned char	flags;		/* Flags, like BOOTP or RARP */
	unsigned char	address;	/* Base memory address or packet */
				 	/* driver class */
	unsigned char	ioaddr;		/* I/O address of packet int vector */
	unsigned int	domaintime;	/* Domain name lookup timeout */
					/* (first retry) */
	unsigned char	domainretry;	/* Number of domain name retries */
	unsigned char	domaincount;	/* Number of domains in the list */
	unsigned int	arptime;	/* ARP timeout in seconds */
	unsigned int	retrans;	/* Retransmit timer, 1/18ths of sec */
	unsigned int	mtu;		/* Max transmit unit, in octets */
	unsigned int	maxseg;		/* Largest segment we can receive */
	unsigned int	rwin;		/* Most octets received without ACK */
	unsigned int	contime;	/* Timeout in seconds on connection */
					/* try */
	unsigned char	domain[MDN];	/* Domain name, broken into a list */
					/* of parts */
	unsigned char	nsip;		/* Nameserver IP address */
	unsigned char	gateip;		/* Gateway IP address */
	struct amachinfo	*mlist;	/* Linked list of other hosts */
					/* (host table) */
};

struct amachinfo {
	unsigned long	hostip;		/* Host IP address */
	unsigned char	nameserver;	/* Nameserver priority */
	unsigned char	gateway;	/* Gateway priority */
	unsigned char	mno;		/* Machine number */
	char		host[MNS];	/* Host name */
	struct amachinfo	*next;	/* Pointer to the next entry */
};
#endif

extern struct conf Scon;
