/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "defs.h"
#include "rpc.h"
#include "funcs.h"
#include <string.h>
#include <stdio.h>

int
net_read(fd, buf, size)
int fd;
void *buf;
int size;
{
    return rpc_call(net_rpc, FUNC_READ, fd, size, RPC_READ, buf);
}

int
net_write(fd, buf, size)
int fd;
const void *buf;
int size;
{
    int total = 0;
    int i, len;

    for (;;) {
	len = size < MAX_IO ? size : MAX_IO;
	i = rpc_call(net_rpc, FUNC_WRITE, fd, len, RPC_WRITE, (void *)buf);
	if (i < 0)
	    return total ? total : i;
	if (!i)
	    break;
	total += i;
	if (i != len)
	    break;
	size -= i;
	if (!size)
	    break;
	buf = (const char *)buf + i;
    }
    return total;
}

/*
 * Cheap hack:  Let the calling function insert the address and the flags
 * in the beginning of the buffer.  That way we don't have to memcpy stuff
 * here.
 */
int
net_sendto(fd, buf, size)
int fd;
const struct sendto_head *buf;
int size;
{
    return rpc_call(net_rpc, FUNC_SENDTO, fd, size + sizeof *buf, RPC_WRITE, (void *)buf);
}

/*
 * The real-mode code puts the address at the beginning of the data.
 */
int
net_recv(fd, buf, size)
int fd;
struct net_addr *buf;
int size;
{
    return rpc_call(net_rpc, FUNC_RECV, fd, size + sizeof *buf, RPC_READ, buf);
}
