/*****************************************************************
 * i/o functions
 *
 *   WriteToClient, ReadRequestFromClient
 *
 *****************************************************************/

#include <stdio.h>
#include "Xos.h"
#include "Xmd.h"
#include <errno.h>
#include "X.h"
#include "Xproto.h"
#include "os.h"
#include "opaque.h"
#include "dixstruct.h"
#include "osdep.h"
#include "misc.h"

static int timesThisConnection = 0;
int _near OutputBufferSize = BUFSIZ;
static ConnectionInputPtr FreeInputs = (ConnectionInputPtr)NULL;
static ConnectionOutputPtr FreeOutputs = (ConnectionOutputPtr)NULL;
static OsCommPtr AvailableInput = (OsCommPtr)NULL;
static Bool CriticalOutputPending;
Bool _near AnyClientsWriteBlocked;
Bool _near NewOutputPending;

char _near isItTimeToYield = 1;

extern Bool near mouse_moved;

extern OsCommPtr near MyPrivate[NPORTS];

extern int AutoResetServer();

static ConnectionInputPtr _near AllocateInputBuffer(void);
static ConnectionOutputPtr _near AllocateOutputBuffer(void);
static void _fastcall _near osXfer(OsCommPtr oc, ConnectionInputPtr oci);

int near lastRequest;

#define request_length(req, cli) ((cli->swapped ? \
	lswaps((req)->length) : (req)->length) << 2)
#define MAX_TIMES_PER         5

/*****************************************************************
 * ReadRequestFromClient
 *    Returns one request in client->requestBuffer.  Return status is:
 *
 *    > 0  if  successful, specifies length in bytes of the request
 *    = 0  if  entire request is not yet available
 *    < 0  if  client should be terminated
 *
 *    The request returned must be contiguous so that it can be
 *    cast in the dispatcher to the correct request type.  Because requests
 *    are variable length, ReadRequestFromClient() must look at the first 4
 *    bytes of a request to determine the length (the request length is
 *    always the 3rd and 4th bytes of the request).  
 *
 *****************************************************************/

#define YieldControl()				\
        { isItTimeToYield = TRUE;		\
	  mouseBlockHandler();			\
	  timesThisConnection = 0; }
#define YieldControlDeath()			\
        { timesThisConnection = 0; }

/* for debug */
extern int (_fastcall _near * _far InitialVector[3]) (ClientPtr);

int _near max_request_size = MAXBUFSIZE >> 2;

int
ReadRequestFromClient(client)
    ClientPtr client;
{

    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    ConnectionInputPtr oci = oc->input;
    int fd = oc->fd;
    int needed, gotnow, result;
    xReq *request;

    if (AvailableInput)
    {
	if (AvailableInput != oc)
	{
	    AvailableInput->input->next = FreeInputs;
	    FreeInputs = AvailableInput->input;
	    AvailableInput->input = (ConnectionInputPtr)NULL;
	}
	AvailableInput = (OsCommPtr)NULL;
    }
    if (!oci)
    {
	if (oci = FreeInputs)
	{
	    FreeInputs = oci->next;
	}
	else if (!(oci = AllocateInputBuffer()))
	{
	    YieldControlDeath();
	    return -1;
	}
	oc->input = oci;
	oci->bufcnt = 0;
    }
    /* reuse the last request */
    if (oc->flags & OS_REUSE) {
	oc->flags &= ~OS_REUSE;
	request = (xReq *)oci->buffer;
	needed = request_length(request, client);
	goto gotreq;
    }
    if (oc->flags & OS_REQUEST) {
	/* This code puts only one request into the buffer at a time.
	 * If we have a full request in buffer, then we can toss it now.
	 */
	oc->flags &= ~OS_REQUEST;
	oci->bufcnt = 0;
    }

/*
if (client->requestVector == InitialVector)
printf(".");
*/
    gotnow = oci->bufcnt;

    needed = sizeof (xReq) - gotnow;
    if (needed > 0) {
	result = SoRead(fd, oci->buffer + gotnow, needed);
	if (result != needed) {
		if (result > 0) {
			oci->bufcnt += result;
			result = 0;
		} else if (result < 0) {
		    YieldControlDeath();
		    return -1;
		}
		YieldControl();
		return 0;
	}
	oci->bufcnt = sizeof (xReq);
	gotnow = sizeof (xReq);
	request = (xReq *)oci->buffer;
	needed = request_length(request, client);
	if (needed == 0)
	    needed = sizeof (xReq);
	if (needed > MAXBUFSIZE || needed < sizeof (xReq)) {
printf("needed=%u\n", needed);
	    /* Naughty client */
	    YieldControlDeath();
	    return -1;
	}

	/* see if we have enough memory */
	if (needed > oci->size)
	{
		xReq xBuf;

		xBuf = *request;
		xfree(oci->buffer);
		oci->buffer = (char *)xalloc(needed);
		if (oci->buffer == 0) {	/* ran out of memory */
		    /* Try freeing some other memory */
		    FlushAllOutput();
		    ResetOsBuffers();
		    if ((oci->buffer = (char *)xalloc(needed)) == 0) {
			YieldControlDeath();
			return -1;
		    }
		}
		oci->size = needed;
		request = (xReq *)oci->buffer;
		*request = xBuf;
	}
    } else {
	/* We know we have enough memory because we called the above
	 * code last time. */
	request = (xReq *)oci->buffer;
	needed = request_length(request, client);
    }

/*
printf("request=%d, client=%d len=%d, seq=%d\n", request->reqType, client->index, needed, client->sequence);
*/

lastRequest = request->reqType;
    if (needed > gotnow) {
	result = SoRead(fd, oci->buffer + gotnow, needed - gotnow);
	if (result < 0) {
	    YieldControlDeath();
	    return -1;
	}
	oci->bufcnt += result;
	if (oci->bufcnt < needed) {
	    YieldControl();
/* printf("not ready\n"); */
	    return 0;
	}
    }

gotreq:
/*
if (client->requestVector == InitialVector)
printf("=");
*/
    oc->flags |= OS_REQUEST;
/* printf("complete\n"); */

    AvailableInput = oc;

    if (++timesThisConnection >= MAX_TIMES_PER)
	YieldControl()
    else if (mouse_moved)
	mouseBlockHandler();

    netsleep();
    client->requestBuffer = (pointer)oci->buffer;
    return needed;
}

/*****************************************************************
 * InsertFakeRequest
 *    Splice a consed up (possibly partial) request in as the next request.
 * This routine will only be called once per session and it will be called
 * before ReadRequestFromClient is called for this client.  Therefore,
 * we know the buffer will be empty.
 *
 * I am assuming this code will only be called from NextAvalibleClient.
 * If it's called from other places, certain modifications must be made.
 *
 **********************/

Bool
InsertFakeRequest(client, data, count)
    ClientPtr client;
    char *data;
    int count;
{
    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    ConnectionInputPtr oci = oc->input;

    if (AvailableInput)
    {
	if (AvailableInput != oc)
	{
	    AvailableInput->input->next = FreeInputs;
	    FreeInputs = AvailableInput->input;
	    AvailableInput->input = (ConnectionInputPtr)NULL;
	}
	AvailableInput = (OsCommPtr)NULL;
    }
    if (!oci)
    {
	if (oci = FreeInputs)
	    FreeInputs = oci->next;
	else if (!(oci = AllocateInputBuffer()))
	    return FALSE;
	oc->input = oci;
    }
    /* This is cheating, but it doesn't matter. */
    memcpy(oci->buffer, data, count);
    oci->bufcnt = count;
    /* The request inserted is always partial.  Therefore nothing needs
     * to be checked until more data is avaliable.  This bit shouldn't
     * be set anyway, but just in case... */
    oc->flags &= ~OS_REQUEST;
    return(TRUE);
}

/*****************************************************************
 * ResetRequestFromClient
 *    Reset to reexecute the current request, and yield.
 *
 * This code is pretty easy since the current request begins at the
 * start of the buffer.
 *
 **********************/

ResetCurrentRequest(client)
    ClientPtr client;
{
    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    xReq *request = (xReq *)oc->input->buffer;

    if (AvailableInput == oc)
	AvailableInput = (OsCommPtr)NULL;
    /* Check if we need more (probably authorization data).  From the
     * place where this code is called, oc->input is never NULL. */
    if (request_length(request, client) > oc->input->bufcnt)
	oc->flags &= ~OS_REQUEST;
    else
	oc->flags |= OS_REUSE;		/* just re-use this request */
/*
printf("flags = %x\n", oc->flags);
*/
    YieldControl();
}

 /********************
 * FlushClient()
 *    If the client isn't keeping up with us, then we try to continue
 *    buffering the data and set the apropriate bit in ClientsWritable
 *    (which is used by WaitFor in the select).  If the connection yields
 *    a permanent error, or we can't allocate any more space, we then
 *    close the connection.
 *
 **********************/

int near
FlushClient(oc, extraBuf, extraCount)
    OsCommPtr oc;
    char *extraBuf;
    int extraCount;
{
    int connection = oc->fd, n, i, notWritten;
    ConnectionOutputPtr oco = oc->output;

    if (!oco)
	return 0;
    i = extraCount;
    extraCount += -extraCount & 3;
/*
printf("flush client %d: %d %d.\n", connection, oc->count, extraCount);
*/
retry:
    if (oco->count)
    {
	n = SoWrite(connection, oco->buf, oco->count);
	if (n < 0)
		goto bad;
	if (n && (oco->count -= n))
		(void) memcpy(oco->buf, oco->buf + n, oco->count);
	notWritten = oco->count;
        /* Notice that padding isn't needed for oc->outbuf since
           it is alreay padded by WriteToClient */
    } else
	notWritten = 0;
    if (extraCount) {
	if (notWritten)
	    notWritten += extraCount;
	else {
	    n = SoWrite(connection, extraBuf, extraCount);
	    if (n < 0)
		goto bad;
	    extraBuf += n;
	    extraCount -= n;
	    notWritten = extraCount;
	}
    }

    if (notWritten == 0) {
	/* everything was flushed out */
	oc->flags &= ~OS_BLOCKED;
	oco->next = FreeOutputs;
	FreeOutputs = oco;
	oc->output = 0;
	return i; /* return only the amount explicitly requested */
    }

    /* If we've arrived here, then the client is stuffed to the gills
       and not ready to accept more.  Make a note of it and buffer
       the rest. */
    AnyClientsWriteBlocked = TRUE;
    oc->flags |= OS_BLOCKED;

    if (notWritten > oco->size)
    {
	if (notWritten > MAXOUTBUF) {
		netsleep();
		goto retry;
	}
	/* allocate at least enough to contain it plus one
	   OutputBufferSize */
	oco->size = notWritten + OutputBufferSize;
	oco->buf = (unsigned char *)realloc(oco->buf, oco->size);
	if (oco->buf == NULL)
	{
    outOfMem:
printf("Out of memory! notWritten=%d.\n", notWritten);
	    _nfree(oco);
	    oc->output = 0;
	    MarkClientException(clients[oc->client]);
	    return(-1);
	}
    }

    if (extraCount)
	memcpy ( (char *)oco->buf + oco->count, extraBuf, extraCount);

    oco->count = notWritten; /* this will include the pad */

    return i; /* return only the amount explicitly requested */

bad:
    MarkClientException(clients[oc->client]);
    return(-1);
}

 /********************
 * FlushAllOutput()
 *    Flush all clients with output.  However, if some client still
 *    has input in the queue (more requests), then don't flush.  This
 *    will prevent the output queue from being flushed every time around
 *    the round robin queue.  Now, some say that it SHOULD be flushed
 *    every time around, but...
 *
 * This routine is called from dix and WaitForSomething().
 *
 **********************/

void
FlushAllOutput()
{
    int i;
    OsCommPtr oc;

    CriticalOutputPending = FALSE;
    NewOutputPending = FALSE;

    for (i = 0; i < NPORTS; i++) {
	oc = MyPrivate[i];
	if (!oc || !oc->output || !oc->output->count)
		continue;
	FlushClient(oc, (char *)NULL, 0);
    }
}

void
FlushIfCriticalOutputPending()
{
    if (CriticalOutputPending)
	FlushAllOutput();
}

void
SetCriticalOutputPending()
{
    CriticalOutputPending = TRUE;
}

/*****************
 * WriteToClient
 *    Copies buf into ClientPtr.buf if it fits (with padding), else
 *    flushes ClientPtr.buf and buf to client.  As of this writing,
 *    every use of WriteToClient is cast to void, and the result
 *    is ignored.  Potentially, this could be used by requests
 *    that are sending several chunks of data and want to break
 *    out of a loop on error.  Thus, we will leave the type of
 *    this routine as int.
 *****************/

int
WriteToClient (client, count, buf)
    ClientPtr client;
    int count;
    char *buf;
{
    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    ConnectionOutputPtr oco = oc->output;
    int padBytes;

    if (oc->fd < 0) 
    {
	ErrorF( "OH NO, %d translates to %d\n", client->index, oc->fd);
	return(-1);
    }

    if (!oco)
    {
	if (oco = FreeOutputs)
	{
	    FreeOutputs = oco->next;
	}
	else if (!(oco = AllocateOutputBuffer()))
	{
	    MarkClientException(client);
	    return -1;
	}
	oc->output = oco;
    }

    padBytes = -count & 3;
    if (oco->count + count + padBytes > oco->size) {
	return FlushClient(oc, buf, count);
    }

    NewOutputPending = TRUE;
    memcpy((char *)oco->buf + oco->count, buf, count);
    oco->count += count + padBytes;

    return count;
}

static ConnectionInputPtr _near
AllocateInputBuffer()
{
    register ConnectionInputPtr oci;

    oci = (ConnectionInputPtr)_nmalloc(sizeof(ConnectionInput));
    if (!oci)
{
printf("AllocateInput: nmalloc failed\n");
	return (ConnectionInputPtr)NULL;
}
    oci->buffer = (char *)xalloc(BUFSIZE);
    if (!oci->buffer)
    {
printf("AllocateInput: xalloc failed\n");
	_nfree(oci);
	return (ConnectionInputPtr)NULL;
    }
    oci->size = BUFSIZE;
    oci->bufcnt = 0;
    return oci;
}

static ConnectionOutputPtr _near
AllocateOutputBuffer()
{
    register ConnectionOutputPtr oco;

    oco = (ConnectionOutputPtr)_nmalloc(sizeof(ConnectionOutput));
    if (!oco)
{
printf("AllocateOutput: nmalloc fails\n");
	return (ConnectionOutputPtr)NULL;
}
    oco->buf = (unsigned char *) xalloc(OutputBufferSize);
    if (!oco->buf)
    {
printf("AllocateOutput: xalloc fails\n");
	_nfree(oco);
	return (ConnectionOutputPtr)NULL;
    }
    oco->size = OutputBufferSize;
    oco->count = 0;
    return oco;
}

void _fastcall _near
CloseDownFileDescriptor(oc)
    OsCommPtr oc;
{
    ConnectionInputPtr oci;
    ConnectionOutputPtr oco;

    SoClose(oc->fd);
    oc->flags |= OS_CLOSING;
    oc->conn_time = GetTimeInMillis();
    if (AvailableInput == oc)
	AvailableInput = (OsCommPtr)NULL;
    if (oci = oc->input)
    {
	oc->input = 0;
	if (FreeInputs)
	{
	    xfree(oci->buffer);
	    _nfree(oci);
	}
	else
	{
	    FreeInputs = oci;
	    oci->next = (ConnectionInputPtr)NULL;
	    oci->bufcnt = 0;
	}
    }
    if (oco = oc->output)
    {
	oc->output = 0;
	if (FreeOutputs)
	{
	    xfree(oco->buf);
	    _nfree(oco);
	}
	else
	{
	    FreeOutputs = oco;
	    oco->next = (ConnectionOutputPtr)NULL;
	    oco->count = 0;
	}
    }
}

void _near
ResetOsBuffers()
{
    ConnectionInputPtr oci;
    ConnectionOutputPtr oco;
    int i;

    while (oci = FreeInputs)
    {
	FreeInputs = oci->next;
	xfree(oci->buffer);
	_nfree(oci);
    }
    while (oco = FreeOutputs)
    {
	FreeOutputs = oco->next;
	xfree(oco->buf);
	_nfree(oco);
    }
}
