/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: miexpose.c,v 5.11 89/11/12 13:51:46 rws Exp $ */

#include "X.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "Xprotostr.h"

#include "misc.h"
#include "regionstr.h"
#include "scrnintstr.h"
#include "gcstruct.h"
#include "windowstr.h"
#include "pixmap.h"
#include "input.h"

#include "dixstruct.h"
#include "mi.h"
#include "Xmd.h"

/*
    machine-independent graphics exposure code.  any device that uses
the region package can call this.
*/

#ifndef RECTLIMIT
#define RECTLIMIT 25		/* pick a number, any number > 8 */
#endif

/* miHandleExposures 
    generate a region for exposures for areas that were copied from obscured or
non-existent areas to non-obscured areas of the destination.  Paint the
background for the region, if the destination is a window.

NOTE:
     this should generally be called, even if graphicsExposures is false,
because this is where bits get recovered from backing store.

NOTE:
     added argument 'plane' is used to indicate how exposures from backing
store should be accomplished. If plane is 0 (i.e. no bit plane), CopyArea
should be used, else a CopyPlane of the indicated plane will be used. The
exposing is done by the backing store's GraphicsExpose function, of course.

*/

RegionPtr
miHandleExposures(pSrcDrawable, pDstDrawable,
		  pGC, srcx, srcy, width, height, dstx, dsty, plane)
    register DrawablePtr	pSrcDrawable;
    register DrawablePtr	pDstDrawable;
    GCPtr 			pGC;
    int 			srcx, srcy;
    int 			width, height;
    int 			dstx, dsty;
    unsigned long		plane;
{
    register ScreenPtr pscr = pGC->pScreen;
    RegionPtr prgnSrcClip;	/* drawable-relative source clip */
    RegionRec rgnSrcRec;
    RegionPtr prgnDstClip;	/* drawable-relative dest clip */
    RegionRec rgnDstRec;
    BoxRec srcBox;		/* unclipped source */
    RegionRec rgnExposed;	/* exposed region, calculated source-
				   relative, made dst relative to
				   intersect with visible parts of
				   dest and send events to client, 
				   and then screen relative to paint 
				   the window background
				*/
    WindowPtr pSrcWin;
    BoxRec expBox;
    Bool extents;

    /* avoid work if we can */
    if (!pGC->graphicsExposures &&
	(pDstDrawable->type == DRAWABLE_PIXMAP) &&
	((pSrcDrawable->type == DRAWABLE_PIXMAP) ||
	 (((WindowPtr)pSrcDrawable)->backStorage == NULL)))
	return NULL;
	
    srcBox.x1 = srcx;
    srcBox.y1 = srcy;
    srcBox.x2 = srcx+width;
    srcBox.y2 = srcy+height;

    if (pSrcDrawable->type == DRAWABLE_WINDOW)
    {
	BoxRec TsrcBox;

	TsrcBox.x1 = srcx + pSrcDrawable->x;
	TsrcBox.y1 = srcy + pSrcDrawable->y;
	TsrcBox.x2 = TsrcBox.x1 + width;
	TsrcBox.y2 = TsrcBox.y1 + height;
	pSrcWin = (WindowPtr) pSrcDrawable;
	if (pGC->subWindowMode == IncludeInferiors)
 	{
	    prgnSrcClip = NotClippedByChildren (pSrcWin);
	    if (((*pscr->RectIn)(prgnSrcClip, &TsrcBox)) == rgnIN)
	    {
		(*pscr->RegionDestroy) (prgnSrcClip);
		return NULL;
	    }
	}
 	else
 	{
	    if (((*pscr->RectIn)(&pSrcWin->clipList, &TsrcBox)) == rgnIN)
		return NULL;
	    prgnSrcClip = &rgnSrcRec;
	    (*pscr->RegionInit)(prgnSrcClip, NullBox, 0);
	    (*pscr->RegionCopy)(prgnSrcClip, &pSrcWin->clipList);
	}
	(*pscr->TranslateRegion)(prgnSrcClip,
				-pSrcDrawable->x, -pSrcDrawable->y);
    }
    else
    {
	BoxRec	box;

	if ((srcBox.x1 >= 0) && (srcBox.y1 >= 0) &&
	    (srcBox.x2 <= pSrcDrawable->width) &&
 	    (srcBox.y2 <= pSrcDrawable->height))
	    return NULL;

	box.x1 = 0;
	box.y1 = 0;
	box.x2 = pSrcDrawable->width;
	box.y2 = pSrcDrawable->height;
	prgnSrcClip = &rgnSrcRec;
	(*pscr->RegionInit)(prgnSrcClip, &box, 1);
	pSrcWin = (WindowPtr)NULL;
    }

    if (pDstDrawable == pSrcDrawable)
    {
	prgnDstClip = prgnSrcClip;
    }
    else if (pDstDrawable->type == DRAWABLE_WINDOW)
    {
	if (pGC->subWindowMode == IncludeInferiors)
	{
	    prgnDstClip = NotClippedByChildren((WindowPtr)pDstDrawable);
	}
	else
	{
	    prgnDstClip = &rgnDstRec;
	    (*pscr->RegionInit)(prgnDstClip, NullBox, 0);
	    (*pscr->RegionCopy)(prgnDstClip,
				&((WindowPtr)pDstDrawable)->clipList);
	}
	(*pscr->TranslateRegion)(prgnDstClip,
				 -pDstDrawable->x, -pDstDrawable->y);
    }
    else
    {
	BoxRec	box;

	box.x1 = 0;
	box.y1 = 0;
	box.x2 = pDstDrawable->width;
	box.y2 = pDstDrawable->height;
	prgnDstClip = &rgnDstRec;
	(*pscr->RegionInit)(prgnDstClip, &box, 1);
    }

    /* drawable-relative source region */
    (*pscr->RegionInit)(&rgnExposed, &srcBox, 1);

    /* now get the hidden parts of the source box*/
    (*pscr->Subtract)(&rgnExposed, &rgnExposed, prgnSrcClip);

#ifdef BACKING_STORE
    if (pSrcWin && pSrcWin->backStorage)
    {
	/*
	 * Copy any areas from the source backing store. Modifies
	 * rgnExposed.
	 */
	(* pSrcWin->drawable.pScreen->ExposeCopy) (pSrcDrawable,
					      pDstDrawable,
					      pGC,
					      &rgnExposed,
					      srcx, srcy,
					      dstx, dsty,
					      plane);
    }
#endif
    
    /* move them over the destination */
    (*pscr->TranslateRegion)(&rgnExposed, dstx-srcx, dsty-srcy);

    /* intersect with visible areas of dest */
    (*pscr->Intersect)(&rgnExposed, &rgnExposed, prgnDstClip);

    /*
     * If we have LOTS of rectangles, we decide to take the extents
     * and force an exposure on that.  This should require much less
     * work overall, on both client and server.  This is cheating, but
     * isn't prohibited by the protocol ("spontaneous combustion" :-)
     * for windows.
     */
    extents = pGC->graphicsExposures &&
	      (REGION_NUM_RECTS(&rgnExposed) > RECTLIMIT) &&
	      (pDstDrawable->type == DRAWABLE_WINDOW);
#ifdef SHAPE
    if (pSrcWin)
    {
	RegionPtr	region;
    	if (!(region = wClipShape (pSrcWin)))
    	    region = wBoundingShape (pSrcWin);
    	/*
     	 * If you try to CopyArea the extents of a shaped window, compacting the
     	 * exposed region will undo all our work!
     	 */
    	if (extents && pSrcWin && region &&
    	    ((*pscr->RectIn)(region, &srcBox) != rgnIN))
	    	extents = FALSE;
    }
#endif
    if (extents)
    {
	WindowPtr pWin = (WindowPtr)pDstDrawable;

	expBox = *(*pscr->RegionExtents)(&rgnExposed);
	(*pscr->RegionReset)(&rgnExposed, &expBox);
#ifdef BACKING_STORE
	/* need to clear out new areas of backing store */
	if (pWin->backStorage)
	    (void) (* pWin->drawable.pScreen->ClearBackingStore)(
					 pWin,
					 expBox.x1,
					 expBox.y1,
					 expBox.x2 - expBox.x1,
					 expBox.y2 - expBox.y1,
					 FALSE);
#endif
    }
    if ((pDstDrawable->type == DRAWABLE_WINDOW) &&
	(((WindowPtr)pDstDrawable)->backgroundState != None))
    {
	WindowPtr pWin = (WindowPtr)pDstDrawable;

	/* make the exposed area screen-relative */
	(*pscr->TranslateRegion)(&rgnExposed, 
				 pDstDrawable->x, pDstDrawable->y);

	if (extents)
	{
	    /* PaintWindowBackground doesn't clip, so we have to */
	    (*pscr->Intersect)(&rgnExposed, &rgnExposed, &pWin->clipList);
	}
	(*pWin->drawable.pScreen->PaintWindowBackground)((WindowPtr)pDstDrawable,
							 &rgnExposed, 
							 PW_BACKGROUND);

	if (extents)
	    (*pscr->RegionReset)(&rgnExposed, &expBox);
	else
	    (*pscr->TranslateRegion)(&rgnExposed,
				     -pDstDrawable->x, -pDstDrawable->y);
    }
    if (prgnDstClip == &rgnDstRec)
	(*pscr->RegionUninit)(prgnDstClip);
    else if (prgnDstClip != prgnSrcClip)
	(*pscr->RegionDestroy)(prgnDstClip);
    if (prgnSrcClip == &rgnSrcRec)
	(*pscr->RegionUninit)(prgnSrcClip);
    else
	(*pscr->RegionDestroy)(prgnSrcClip);
    if (pGC->graphicsExposures)
    {
	/* don't look */
	RegionPtr exposed = (*pscr->RegionCreate)(NullBox, 0);
	*exposed = rgnExposed;
	return exposed;
    }
    else
    {
	(*pscr->RegionUninit) (&rgnExposed);
	return NULL;
    }
}

/* send GraphicsExpose events, or a NoExpose event, based on the region */

void
miSendGraphicsExpose (client, pRgn, drawable, major, minor)
    ClientPtr	client;
    RegionPtr	pRgn;
    XID		drawable;
    int	major;
    int	minor;
{
    if (pRgn && !REGION_NIL(pRgn))
    {
        xEvent *pEvent;
	register xEvent *pe;
	register BoxPtr pBox;
	register int i;
	int numRects;

	numRects = REGION_NUM_RECTS(pRgn);
	pBox = REGION_RECTS(pRgn);
	if(!(pEvent = (xEvent *)ALLOCATE_LOCAL(numRects * sizeof(xEvent))))
		return;
	pe = pEvent;

	for (i=1; i<=numRects; i++, pe++, pBox++)
	{
	    pe->u.u.type = GraphicsExpose;
	    pe->u.graphicsExposure.drawable = drawable;
	    pe->u.graphicsExposure.x = pBox->x1;
	    pe->u.graphicsExposure.y = pBox->y1;
	    pe->u.graphicsExposure.width = pBox->x2 - pBox->x1;
	    pe->u.graphicsExposure.height = pBox->y2 - pBox->y1;
	    pe->u.graphicsExposure.count = numRects - i;
	    pe->u.graphicsExposure.majorEvent = major;
	    pe->u.graphicsExposure.minorEvent = minor;
	}
	TryClientEvents(client, pEvent, numRects,
			    (Mask)0, NoEventMask, NullGrab);
	DEALLOCATE_LOCAL(pEvent);
    }
    else
    {
        xEvent event;
	event.u.u.type = NoExpose;
	event.u.noExposure.drawable = drawable;
	event.u.noExposure.majorEvent = major;
	event.u.noExposure.minorEvent = minor;
	TryClientEvents(client, &event, 1,
	    (Mask)0, NoEventMask, NullGrab);
    }
}

void 
miWindowExposures(pWin, prgn, other_exposed)
    WindowPtr pWin;
    RegionPtr prgn, other_exposed;
{
    if ((prgn && !REGION_NIL(prgn)) || other_exposed)
    {
	xEvent *pEvent;
	xEvent *pe;
	BoxPtr pBox;
	int i;
	RegionPtr exposures = prgn;
	RegionRec expRec;

#ifdef BACKING_STORE
	/*
	 * Restore from backing-store FIRST.
	 */
 	if (pWin->backStorage && prgn)
	    /*
	     * in some cases, backing store will cause a different
	     * region to be exposed than needs to be repainted
	     * (like when a window is mapped).  RestoreAreas is
	     * allowed to return a region other than prgn,
	     * in which case this routine will free the resultant
	     * region.  If exposures is null, then no events will
	     * be sent to the client; if prgn is empty
	     * no areas will be repainted.
	     */
	    exposures = (*pWin->drawable.pScreen->RestoreAreas)(pWin, prgn);
#endif
	if (other_exposed)
	{
	    if (exposures)
	    {
		(*pWin->drawable.pScreen->Union) (other_exposed,
						  exposures,
					          other_exposed);
		if (exposures != prgn)
		    (*pWin->drawable.pScreen->RegionDestroy) (exposures);
	    }
	    exposures = other_exposed;
	}
	if (exposures && (REGION_NUM_RECTS(exposures) > RECTLIMIT))
	{
	    /*
	     * If we have LOTS of rectangles, we decide to take the extents
	     * and force an exposure on that.  This should require much less
	     * work overall, on both client and server.  This is cheating, but
	     * isn't prohibited by the protocol ("spontaneous combustion" :-).
	     */
	    BoxRec box;

	    box = *(* pWin->drawable.pScreen->RegionExtents)(exposures);
	    if (exposures == prgn) {
		exposures = &expRec;
		(* pWin->drawable.pScreen->RegionInit)(exposures, &box, 1);
		(* pWin->drawable.pScreen->RegionReset)(prgn, &box);
	    } else {
		(* pWin->drawable.pScreen->RegionReset)(exposures, &box);
		(* pWin->drawable.pScreen->Union)(prgn, prgn, exposures);
	    }
	    /* PaintWindowBackground doesn't clip, so we have to */
	    (* pWin->drawable.pScreen->Intersect)(prgn, prgn, &pWin->clipList);
#ifdef BACKING_STORE
	    /* need to clear out new areas of backing store, too */
	    if (pWin->backStorage)
		(void) (* pWin->drawable.pScreen->ClearBackingStore)(
					     pWin,
					     box.x1 - pWin->drawable.x,
					     box.y1 - pWin->drawable.y,
					     box.x2 - box.x1,
					     box.y2 - box.y1,
					     FALSE);
#endif
	}
	if (prgn && !REGION_NIL(prgn))
	    (*pWin->drawable.pScreen->PaintWindowBackground)(pWin, prgn, PW_BACKGROUND);
	if (exposures && !REGION_NIL(exposures))
	{
	    int numRects;

	    (* pWin->drawable.pScreen->TranslateRegion)(exposures,
			-pWin->drawable.x, -pWin->drawable.y);
	    numRects = REGION_NUM_RECTS(exposures);
	    pBox = REGION_RECTS(exposures);

	    pEvent = (xEvent *) ALLOCATE_LOCAL(numRects * sizeof(xEvent));
	    if (pEvent) {
	    	pe = pEvent;
    
	    	for (i=1; i<=numRects; i++, pe++, pBox++)
	    	{
		    pe->u.u.type = Expose;
		    pe->u.expose.window = pWin->drawable.id;
		    pe->u.expose.x = pBox->x1;
		    pe->u.expose.y = pBox->y1;
		    pe->u.expose.width = pBox->x2 - pBox->x1;
		    pe->u.expose.height = pBox->y2 - pBox->y1;
		    pe->u.expose.count = (numRects - i);
	    	}
	    	DeliverEvents(pWin, pEvent, numRects, NullWindow);
	    	DEALLOCATE_LOCAL(pEvent);
	    }
	}
	if (exposures == &expRec)
	    (* pWin->drawable.pScreen->RegionUninit) (exposures);
	else if (exposures && exposures != prgn && exposures != other_exposed)
	    (* pWin->drawable.pScreen->RegionDestroy) (exposures);
	if (prgn)
	    (* pWin->drawable.pScreen->RegionEmpty)(prgn);
    }
}

/* MICLEARDRAWABLE -- sets the entire drawable to the background color of
 * the GC.  Useful when we have a scratch drawable and need to initialize 
 * it. */
miClearDrawable(pDraw, pGC)
    DrawablePtr	pDraw;
    GCPtr	pGC;
{
    unsigned long    fg = pGC->fgPixel;
    unsigned long    bg = pGC->bgPixel;
    xRectangle rect;

    rect.x = 0;
    rect.y = 0;
    rect.width = pDraw->width;
    rect.height = pDraw->height;
    DoChangeGC(pGC, GCForeground, &bg, 0);
    ValidateGC(pDraw, pGC);
    (*pGC->ops->PolyFillRect)(pDraw, pGC, 1, &rect);
    DoChangeGC(pGC, GCForeground, &fg, 0);
    ValidateGC(pDraw, pGC);
}
