	name	wdc1a

	.286p

NUMPAGES	equ	1
HEADLAND	equ	0
VESA		equ	0

setpage	MACRO	page		; page to be set is in ah
	IFDIFI	<page>,<ah>
	mov	ah,page
	ENDIF
	shl	ah,4
	mov	al,9		; register 9
	push	dx
	mov	dx,03ceh
	out	dx,ax		; set the page
	pop	dx
		ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	org	0

include common.asm

do_local	PROC NEAR
				; mode in reg al
	xor	ah,ah		; function 0 = set mode
	push	ax		; save mode
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
	mov	ah,0fh
	int	10h		; get current mode
	pop	bx		; restore desired mode
	cmp	al,bl
	jnz	local_bad
	cli
	mov	dx,3ceh		; i/o address
	mov	ax,050fh	; enable extended register access
	out	dx,ax
	mov	al,0bh		; index 0B, dual page register
	out	dx,al		; point to index 0B
	inc	dx
	in	al,dx		; get current value
	and	al,not 8	; clear bit 3
	out	dx,al		; one page map
	sti
	mov	dl,0
	setpage	dl
	xor	ax,ax		; return OK
	ret
local_bad:
	mov	ax,08002h	; non-supported mode
	ret
do_local	ENDP

old_mode	db	?
mono_modes:
	dw	0011h		; 640x480 mono
	dw	0058h		; 800x600 16 colors
	dw	005dh		; 1024x768 mono
	dw	0		; 1280x1024 mono
color_modes:
	dw	005fh		; 640x480 256 colors
	dw	0		; 800x600 256 colors
	dw	0		; 1024x768 256 colors
	dw	0		; 1280x1024 256 colors

include copy.asm
include stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'WD90C10/Paradise PVGA1A driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
