	name	tseng3

	.286p

NUMPAGES	equ	2
HEADLAND	equ	0
VESA		equ	0

setpage	MACRO	srcpage,dstpage	; set the new page
	IFIDNI	<srcpage>,<al>	; src == al
	IFIDNI	<dstpage>,<al>	; src == al && dst == al
	mov	ah,al
	shl	al,3
	or	al,ah
	ELSE			; src == al && dst != al
	shl	al,3
	or	al,dstpage
	ENDIF
	ELSE			; src != al
	IFIDNI	<dstpage>,<al>	; src != al && dst == al
	IFDIFI	<srcpage>,<ah>	; src != al && dst == al && src != ah
	mov	ah,srcpage
	ENDIF
	shl	ah,3
	or	al,ah
	ELSE			; src != al && dst != al
	mov	al,srcpage
	shl	al,3
	or	al,dstpage
	ENDIF
	ENDIF

	or	al,40h
	push	dx
	mov	dx,03cdh
	out	dx,al		; set the page
	pop	dx
		ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	ORG	0

include common.asm

do_local	PROC NEAR
				; mode in al
	xor	ah,ah		; function 0 = set mode
	push	ax		; save mode
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
	mov	ah,0fh
	int	10h		; get current mode
	pop	bx
	cmp	al,bl
	jnz	local_bad
	mov	dl,0
	setpage	dl,dl
	xor	ax,ax		; return OK
	ret
local_bad:
	mov	ax,08002h	; non-supported mode
	ret
do_local	ENDP

old_mode	db	?
mono_modes:
	dw	0011h		; 640x480
	dw	0029h		; 800x600
	dw	0037h		; 1024x768 not supported
	dw	0		; 1280x1024 not supported
color_modes:
	dw	002eh		; 640x480
	dw	0030h		; 800x600
	dw	0		; 1024x768 not supported
	dw	0		; 1280x1024 not supported

include	copy.asm
include	stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'Tseng Labs ET3000 driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
