	name	trident

	.286p

NUMPAGES	equ	1
HEADLAND	equ	0
VESA		equ	0

setpage	MACRO	page
	IFDIFI	<page>,<ah>	; page != ah
	mov	ah,page
	ENDIF
	xor	ah,2		; invert bit
	mov	al,0eh		; register 0eh
	push	dx
	mov	dx,03c4h
	out	dx,al		; set the page
	inc	dx
	in	al,dx
	and	al,0f0h
	or	al,ah
	out	dx,al
	pop	dx
ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	org	0

include common.asm

do_local	PROC NEAR
				; mode in reg al upon call
	xor	ah,ah		; function 0 = set mode
;	mov	bl,al		; save mode
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
;	mov	ah,0fh
;	int	10h		; get current mode
;	cmp	al,bl
;	jnz	local_bad
	mov	dx,3c4h
	mov	al,0bh
	cli
	out	dx,al
	inc	dx
	in	al,dx		; enable extended registers
	mov	dx,3ceh
	mov	al,6
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f3h
	or	al,4
	out	dx,al
	sti
	mov	dl,0
	setpage	dl
	xor	ax,ax		; return OK
	ret
;local_bad:
;	mov	ax,08002h	; non-supported mode
;	ret
do_local	ENDP

old_mode	db	?
mono_modes:
	dw	0011h		; 640x480 mono
	dw	006ah		; 800x600 16 colors
	dw	005fh		; 1024x768 mono
	dw	0		; 1280x1024 mono
color_modes:
	dw	005dh		; 640x480 256 colors
	dw	005eh		; 800x600 256 colors
	dw	0062h		; 1024x768 256 colors
	dw	0		; 1280x1024 256 colors

include copy.asm
include stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'Trident TVGA 8900 driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
