COPY_STIPPLE	PROC FAR
;	copy stipple, no tiling
;	copy_stipple(short dstx, short dsty, short dstwidth, short dstheight,
;		char far * psrc, short srcwidth, short xoff, short yoff,
;		char fgpixel, char bgpixel);
s_page	=	-6		; current page info
s_next_src_line =	-4	; number of bytes to next src line
s_next_scan_line =	-2	; number of bytes to next scan line
s_dstx =	6
s_dsty =	8
s_dstwidth =	10
s_dstheight =	12
s_psrc =	14
s_srcwidth =	18
s_xoff =	20
s_yoff =	22
s_fgpixel =	24
s_bgpixel =	26

c_stipple640:
	mov	bx,640
	jmp	short c_stipple

c_stipple800:
	mov	bx,800
	jmp	short c_stipple

c_stipple1024:
	mov	bx,1024

	IF	VESA EQ 1
	jmp	short c_stipple
c_stipple1280:
	mov	bx,1280
	ENDIF

c_stipple:
;	bx = number of bytes in one scan line
	push	bp
	mov	bp,sp		; setup frame pointer
	add	sp,s_page	; setup temp variables
	push	ds
	push	es
	push	si		; psrc
	push	di		; pdst

	mov	ax,0a000h
	mov	es,ax		; point to video area

	mov	ax,s_dsty[bp]	; multiply it by screen width
	mul	bx
	add	ax,s_dstx[bp]
	adc	dl,0
	mov	di,ax

	mov	s_page[bp],dl
	IF	NUMPAGES EQ 1
	setpage	dl
	ENDIF

	IF	NUMPAGES EQ 2
	setpage	dl,dl
	ENDIF

	mov	cx,s_dstwidth[bp]	; get number of bytes in one line
	sub	bx,cx		; get number of bytes to next scan line
	mov	s_next_scan_line[bp],bx		; save it
	lds	si,s_psrc[bp]	; get src buffer
	mov	ax,s_srcwidth[bp]
	add	ax,7		; round up to byte value
	and	al,0f8h		; number of "bytes" of src
	mov	dx,ax		; put srcwidth in dx
	sub	dx,cx		; dx has the "bytes" to next src line
	mov	cx,s_xoff[bp]	; xoff
	and	cx,7		; xoff & 7
	sub	dx,cx		; srcwidth - (xoff & 7)
	shr	dx,3		; convert to actual src bytes
	mov	s_next_src_line[bp],dx
	shr	ax,3		; convert srcwidth to bytes
	mul	word ptr s_yoff[bp]	; srcwidth * yoff
	add	si,ax		; psrc += srcwidth * yoff
	mov	ax,s_xoff[bp]	; get xoff
	shr	ax,3		; convert xoff to bytes
	add	si,ax		; psrc += xoff
	mov	bh,s_fgpixel[bp]	; dh = foreground color
	mov	bl,s_bgpixel[bp]	; dl = background color
	and	byte ptr s_xoff[bp],7	; just need low 3 bits of xoff
$CS0:
	mov	cl,s_xoff[bp]	; get xoff
	mov	dl,[si]		; get source byte
	inc	si
	shl	dl,cl		; get rid of any offsets
	mov	dh,8
	sub	dh,cl		; ah has number of bits left
	mov	cx,s_dstwidth[bp]	; get number of bytes in one line
same_src:
	shl	dl,1		; check bit
	jnc	write_bg
	mov	es:[di],bh	; write out foreground color
	jmp	short $CS1
write_bg:
	mov	es:[di],bl	; write out background color
$CS1:
	inc	di
	jz	page_it
cont_after_page:
	dec	cx
	jcxz	next_line
	dec	dh
	jnz	same_src
	mov	dl,[si]
	inc	si
	mov	dh,8
	jmp	short same_src
page_it:
	mov	al,s_page[bp]
	inc	al
	mov	s_page[bp],al

	IF	NUMPAGES EQ 1
	setpage	al
	ENDIF

	IF	NUMPAGES EQ 2
	setpage	al,al
	ENDIF

	jmp	short cont_after_page
next_line:
	dec	word ptr s_dstheight[bp]	; any more
	jz	no_more
	add	si,s_next_src_line[bp]
	add	di,s_next_scan_line[bp]
	jnc	$CS0
	mov	ah,s_page[bp]
	inc	ah
	mov	s_page[bp],ah

	IF	NUMPAGES EQ 1
	setpage	ah
	ENDIF

	IF	NUMPAGES EQ 2
	setpage	ah,ah
	ENDIF

	IF	HEADLAND EQ 1
	jmp	$CS0
	ELSE
	jmp	short $CS0
	ENDIF
no_more:
	pop	di
	pop	si
	pop	es
	pop	ds
	leave
	ret
COPY_STIPPLE	ENDP
