#include "Xmd.h"
#include "pixmapstr.h"
#include "os.h"		/* for malloc.h */

#include "vga.h"
#include "../../mi/mi.h"

#include "servermd.h"

#include "site.h"

PixmapPtr
vgaCreatePixmap(pScreen, width, height, depth)
ScreenPtr pScreen;
int width, height, depth;
{
	int size;
	PixmapPtr pPixmap;

	pPixmap = (PixmapPtr)_nmalloc(sizeof(PixmapRec));
	if (!pPixmap)
		return (PixmapPtr)NULL;
	pPixmap->drawable.type = DRAWABLE_PIXMAP;
	pPixmap->drawable.pScreen = pScreen;
	pPixmap->drawable.depth = (u_char)depth;
	pPixmap->drawable.bitsPerPixel = (u_char)depth;
	pPixmap->drawable.width = width;
	pPixmap->drawable.height = height;
	pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
	pPixmap->drawable.x = 0;
	pPixmap->drawable.y = 0;
	pPixmap->refcnt = 1;
	pPixmap->devKind = PixmapBytePad(width, depth);
	size = height * pPixmap->devKind;
	if (!(pPixmap->devPrivate.ptr = (char *)xalloc(size))) {
		_nfree(pPixmap);
		return (PixmapPtr)NULL;
	} else {
		bzero((char *)pPixmap->devPrivate.ptr, size);
	}
	return pPixmap;
}

Bool
vgaDestroyPixmap(pPixmap)
PixmapPtr pPixmap;
{
	if (--pPixmap->refcnt)
		return TRUE;
	Xfree(pPixmap->devPrivate.ptr);
	_nfree(pPixmap);
	return TRUE;
}
