	name	tseng

	.286p

setpage	MACRO	read, write
	mov	al,read
	shl	al,3
	or	al,write	; port = (src << 3) | dest
	or	al,40h
	mov	dx,03cdh
	out	dx,al		; set the page
ENDM

write_page	MACRO		; page to be set is in ah
	mov	dx,03cdh
	out	dx,al		; set the page
		ENDM

load_page	MACRO
	mov	al,c_page[bp]
		ENDM

save_page	MACRO
	mov	c_page[bp],al
		ENDM

page_setup	MACRO	src, dst	; setup page info into reg ah
	mov	al,src
	shl	al,3
	or	al,dst
	or	al,40h
		ENDM

inc_src_page	MACRO		; increment the src page number
	add	al,8		; cannot overflow to the dst page
		ENDM

dec_src_page	MACRO		; decrement the src page number
	sub	al,8		; cannot overflow to the dst page
		ENDM

inc_dst_page	MACRO		; increment the dst page number
	inc	al
		ENDM

dec_dst_page	MACRO		; decrement the dst page number
	dec	al
		ENDM

inc_dst_page_in_mem	MACRO	; increment the dst page number in memory
	inc	byte ptr c_page[bp]
		ENDM
dec_dst_page_in_mem	MACRO	; decrement the dst page number in memory
	dec	byte ptr c_page[bp]
		ENDM

inc_both_pages	MACRO
	add	al,9
		ENDM


include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	ORG	0

include common.asm

old_mode	db	?
mono_modes:
	db	11h		; 640x480
	db	29h		; 800x600
	db	37h		; 1024x768 not supported
color_modes:
	db	2eh		; 640x480
	db	30h		; 800x600
	db	0		; 1024x768 not supported

include	acopy.asm
include	stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'Tseng VGA driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation, Inc. All rights reserved.',10,13,'$'

_text	ENDS
	END
