/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: mfbhrzvert.c,v 1.9 88/09/06 14:53:43 jim Exp $ */
#include "X.h"

#include "gc.h"
#include "window.h"
#include "pixmap.h"
#include "region.h"

#include "ega.h"
#include "maskbits.h"

/* horizontal solid line
   abs(len) > 1
*/
void near
mfbHorzS(rop, addr, base, nlwidth, x1, y1, len)
int rop;		/* a reduced rasterop */
_segment base;
char _based(void) *addr;
int nlwidth;	/* width in longwords of bitmap */
int x1;			/* initial point */ 
int y1;
int len;		/* length of line */
{
    unsigned char startmask;
    unsigned char endmask;
    unsigned char nlmiddle;
    char _based(base) *addrl = addr;

    /* force the line to go left to right
       but don't draw the last point
    */
    if (len < 0)
    {
	x1 += len;
	x1 += 1;
	len = -len;
    }

    addrl = addrl + (y1 * nlwidth) + (x1 >> 3);
#ifdef EGA_HIRES
    if (egapriv.hires && base == egapriv.fb) {
	if (y1 < HIRES_LPP) {
	    if (egapriv.curpage)
		(*vga_conf.page)(egapriv.curpage = 0);
	} else if (!egapriv.curpage)
	    (*vga_conf.page)(egapriv.curpage = 1);
    }
#endif

    /* all bits inside same byte */
    if ( ((x1 & 7) + len) < 8)
    {
	startmask = 0xff >> (x1 & 7);
	startmask &= ~(0xff >> ((x1 + len) & 7));
        if (rop == RROP_BLACK)
        {
	    *addrl &= ~startmask;
        }
        else if (rop == RROP_WHITE)
        {
	    *addrl |= startmask;
        }
        else if (rop == RROP_INVERT)
        {
	    *addrl ^= startmask;
        }
    }
    else
    {
	startmask = 0xff >> (x1 & 7);
	if (startmask)
		nlmiddle = (len - (8 - (x1 & 7))) >> 3;
	else
		nlmiddle = len >> 3;
	endmask = ~(0xff >> ((x1 + len) & 7));
        if (rop == RROP_BLACK)
        {
	    if (startmask)
		*addrl++ &= ~startmask;
	    while (nlmiddle--)
		*addrl++ = 0x0;
	    if (endmask)
		*addrl &= ~endmask;
        }
        else if (rop == RROP_WHITE)
        {
	    if (startmask)
		*addrl++ |= startmask;
	    while (nlmiddle--)
		*addrl++ = 0xff;
	    if (endmask)
		*addrl |= endmask;
        }
        else if (rop == RROP_INVERT)
        {
	    if (startmask)
		*addrl++ ^= startmask;
	    while (nlmiddle--)
		*addrl++ ^= 0xff;
	    if (endmask)
		*addrl ^= endmask;
        }
    }
}

/* vertical solid line
   this uses do loops because pcc (Ultrix 1.2, bsd 4.2) generates
   better code.  sigh.  we know that len will never be 0 or 1, so
   it's OK to use it.
*/

void near
mfbVertS(rop, addr, base, nlwidth, x1, y1, len)
int rop;		/* a reduced rasterop */
_segment base;
char _based(void) *addr;
int nlwidth;	/* width in bytes of bitmap */
int x1, y1;		/* initial point */
int len;	/* length of line */
{
    unsigned char bitmask;
    char _based(base) *addrl = addr;
#ifdef EGA_HIRES
    int extra = 0;
#endif

    addrl += (y1 * nlwidth) + (x1 >> 3);
#ifdef EGA_HIRES
    if (egapriv.hires && base == egapriv.fb) {
	if (y1 < HIRES_LPP) {
	    if (egapriv.curpage)
		(*vga_conf.page)(egapriv.curpage = 0);
	    if (y1+len > HIRES_LPP) {
		extra = y1+len - HIRES_LPP;
		len = HIRES_LPP - y1;
	    }
	} else if (!egapriv.curpage)
	    (*vga_conf.page)(egapriv.curpage = 1);
    }
#endif

#ifdef notdef
    /* This function is never called with len < 0 */
    if (len < 0)
    {
printf("mfbVert: len=%d\n", len);
	nlwidth = -nlwidth;
	len = -len;
    }
#endif
 
more:
    if (rop == RROP_BLACK)
   {
	bitmask = ~(0x80>>(x1 & 7));
	do
	{
	    *addrl &= bitmask;
	    addrl += nlwidth;
	}
	while (--len);
    }
    else if (rop == RROP_WHITE)
    {
	bitmask = 0x80 >> (x1 & 7);
	do
	{
	    *addrl |= bitmask;
	    addrl += nlwidth;
	}
	while (--len);
    }
    else if (rop == RROP_INVERT)
    {
	bitmask = 0x80 >> (x1 & 7);
	do
	{
	    *addrl ^= bitmask;
	    addrl += nlwidth;
	}
	while (--len);
    }
#ifdef EGA_HIRES
    if (extra) {
	len = extra;
	extra = 0;
	(*vga_conf.page)(egapriv.curpage = 1);
	goto more;
    }
#endif
}
