#include "Xmd.h"
#include "pixmapstr.h"
#include "maskbits.h"
#include "os.h"		/* for malloc.h */

#include "ega.h"
#include "../../mi/mi.h"

#include "servermd.h"

#include "site.h"

PixmapPtr
egaCreatePixmap(pScreen, width, height, depth)
ScreenPtr pScreen;
int width, height, depth;
{
	long lsize;
	PixmapPtr pPixmap;

	if (depth != 1)		/* color! */
		return (PixmapPtr)NULL;
	lsize = (long)height * PixmapBytePad(width, 1);
	if (lsize & 0xffff0000)
		return (PixmapPtr)NULL;
	pPixmap = (PixmapPtr)_nmalloc(sizeof(PixmapRec));
	if (!pPixmap)
		return (PixmapPtr)NULL;
	pPixmap->drawable.type = DRAWABLE_PIXMAP;
	pPixmap->drawable.pScreen = pScreen;
	pPixmap->drawable.depth = depth;
	pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
	pPixmap->drawable.width = width;
	pPixmap->drawable.height = height;
	pPixmap->drawable.x = 0;
	pPixmap->drawable.y = 0;
	pPixmap->devKind = PixmapBytePad(width, 1);
	pPixmap->refcnt = 1;
	if (!(pPixmap->devPrivate.ptr = (char *)xalloc((int)lsize))) {
		_nfree(pPixmap);
		return (PixmapPtr)NULL;
	} else {
		bzero((char *)pPixmap->devPrivate.ptr, (int)lsize);
	}
	return pPixmap;
}

Bool
egaDestroyPixmap(pPixmap)
PixmapPtr pPixmap;
{
	if (--pPixmap->refcnt)
		return TRUE;
	Xfree(pPixmap->devPrivate.ptr);
	_nfree(pPixmap);
	return TRUE;
}

#ifdef notdef
/* Rotates pixmap pPix by w pixels to the right on the screen. Assumes that
 * words are 8 bits wide, and that the least significant bit appears on the
 * left.
 */
egaXRotatePixmap(pPix, rw)
    PixmapPtr	pPix;
    int rw;
{
    unsigned char	*pw, *pwFinal;
    unsigned char i, t;

    if (pPix == NullPixmap)
        return;

    pw = (long *)pPix->devPrivate;
    rw %= pPix->width;
    if (rw < 0)
	rw += pPix->width;
    pwFinal = pw + pPix->height * (unsigned int)(pPix->devKind);
    while(pw < pwFinal)
    {
	i = 0;
	while (i < (int)pPix->devKind) {
	    t = *pw;
	*pw++ = SCRRIGHT(t, rw) | 
		(SCRLEFT(t, (32-rw)) & endtab[rw]);
	}
    }
}
#endif
