/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: miglblt.c,v 1.18 88/09/06 14:49:13 jim Exp $ */

#include	"X.h"
#include	"Xmd.h"
#include	"Xproto.h"
#include	"fontstruct.h"
#include	"dixfontstr.h"
#include	"gcstruct.h"
#include	"windowstr.h"
#include	"scrnintstr.h"
#include	"pixmap.h"
#include	"servermd.h"

#include	"egafuncs.h"

/*
    machine-independent glyph blt.
    assumes that glyph bits in snf are written in bytes,
have same bit order as the server's bitmap format,
and are byte padded.  this corresponds to the snf distributed
with the sample server.

    get a scratch GC.
    in the scratch GC set alu = GXcopy, fg = 1, bg = 0
    allocate a bitmap big enough to hold the largest glyph in the font
    validate the scratch gc with the bitmap
    for each glyph
	carefully put the bits of the glyph in a buffer,
	    padded to the server pixmap scanline padding rules
	fake a call to PutImage from the buffer into the bitmap
	use the bitmap in a call to PushPixels
*/

static void mxBox(DrawablePtr, GCPtr, int, int, int, int);

void
egaPolyGlyphBlt(pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    int height;
    FontRec *pfont;
    int j;
    CharInfoPtr pci;			/* currect char info */
    unsigned char *pglyph;		/* pointer bits in glyph */
    int gWidth, gHeight;		/* width and height of glyph */
    register int nbyGlyphWidth;		/* bytes per scanline of glyph */
    int totwidth;
    unsigned char *line;
    int xshift;
    int maxAscent;
    PixmapPtr pPixmap;
    int nbyPixmap;
    unsigned char *pdst;
    ExtentInfoRec info;		/* used by QueryGlyphExtents() */

    if (pDrawable->type == DRAWABLE_WINDOW && pGC->miTranslate) {
	x += pDrawable->x;
	y += pDrawable->y;
    }
    pfont = pGC->font;
    pci = *ppci;

    /* Make enough space to hold all characters */
    if (nglyph == 1) {
	totwidth = GLYPHWIDTHPIXELS(pci);
	maxAscent = pci->metrics.ascent;
	height = maxAscent + pci->metrics.descent;
    } else {
	QueryGlyphExtents(pfont, ppci, nglyph, &info);
	totwidth = info.overallRight - info.overallLeft;
	maxAscent = info.overallAscent;
	height = maxAscent + info.overallDescent;
    }

    pPixmap = (*pDrawable->pScreen->CreatePixmap)
	(pDrawable->pScreen, totwidth, height, 1);
    if (!pPixmap) {
printf("PolyGlyphBlt: can't allocate Pixmap\n");
	return;
    }
    nbyPixmap = pPixmap->devKind;
    pdst = pPixmap->devPrivate.ptr;
    bzero(pdst, nbyPixmap * height);

    x += pci->metrics.leftSideBearing;	/* first char */
    y -= maxAscent;
    xshift = 0;			/* First character starts at 0. */

    for (;;) {
	char rshift, lshift;

	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	nbyGlyphWidth = GLYPHWIDTHBYTESPADDED(pci);

	rshift = xshift & 7;
	lshift = 8 - rshift;

	line = pdst + xshift / 8 +
	    nbyPixmap * (maxAscent - pci->metrics.ascent);
	pglyph = pglyphBase + pci->byteOffset;

	gWidth = gWidth - 1 >> 3;
	while (--gHeight >= 0) {
	    unsigned char *lp = line;

	    if (!gWidth) {
		    *lp++ |= *pglyph >> rshift;
		    *lp   |= *pglyph << lshift;
	    } else
		for (j = 0; j <= gWidth; j++) {
		    *lp++ |= pglyph[j] >> rshift;
		    *lp   |= pglyph[j] << lshift;
	    }
	    line += nbyPixmap;
	    pglyph += nbyGlyphWidth;
	}

	/* Are there more characters? */
	if (!--nglyph)
	    break;

	/* Point xshift to "center" of character. */
	xshift -= pci->metrics.leftSideBearing;

	/* Bump xshift to "center" of next character. */
	xshift += pci->metrics.characterWidth;

	pci = *++ppci;	/* next character */

	/* Back xshift to left of next character. */
	xshift += pci->metrics.leftSideBearing;
    }

    (*pGC->ops->PushPixels)(pGC, pPixmap, pDrawable, totwidth, height, x, y);
    (*pDrawable->pScreen->DestroyPixmap)(pPixmap);
}

egaImageGlyphBlt(pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    FontRec *pfont;
    int i, j;
    CharInfoPtr pci;			/* currect char info */
    unsigned char *pglyph;		/* pointer bits in glyph */
    int gWidth, gHeight;		/* width and height of glyph */
    int nbyGlyphWidth;		/* bytes per scanline of glyph */
    int totwidth, height;		/* width and height of area */
    unsigned char *pdst, *line;
    int xshift;
    int nbytes;
    ExtentInfoRec info;		/* used by QueryGlyphExtents() */
    char fgSave;
    unsigned char aluSave;

    pfont = pGC->font;
    pci = *ppci;

    if (nglyph == 1) {
	totwidth = GLYPHWIDTHPIXELS(pci);
	info.overallAscent = pci->metrics.ascent;
	info.overallWidth = pci->metrics.characterWidth;
	height = info.overallAscent + pci->metrics.descent;
	info.fontAscent = pfont->pFI->fontAscent;
	info.fontDescent = pfont->pFI->fontDescent;
    } else {
	QueryGlyphExtents(pfont, ppci, nglyph, &info);
	totwidth = info.overallRight - info.overallLeft;
	height = info.overallAscent + info.overallDescent;
    }
    /* According to the protocol, we first fill the rectangle with the
     * background pixel.
     */
    i = pGC->fillStyle;
    j = pGC->fgPixel;
    if (i != FillSolid || j != pGC->bgPixel) {
	pGC->fillStyle = FillSolid;
	pGC->fgPixel = pGC->bgPixel;
	mxValidateGC(pGC, GCFillStyle|GCForeground, pDrawable);
    }
    mxBox(pDrawable, pGC, x, y - info.fontAscent, info.overallWidth,
	info.fontAscent + info.fontDescent);

    pGC->fillStyle = i;
    pGC->fgPixel = j;

    /* Make enough space to hold all possible characters */
    nbytes = PixmapWidthInPadUnits(totwidth, 1);
    pdst = ALLOCATE_LOCAL(nbytes * height);
    if (!pdst)
	return BadAlloc;
    bzero(pdst, nbytes * height);

    x += pci->metrics.leftSideBearing;	/* first char */
    y -= info.overallAscent;
    xshift = 0;			/* First character starts at 0. */

    for (;;) {
	char rshift, lshift;

	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	nbyGlyphWidth = GLYPHWIDTHBYTESPADDED(pci);

	rshift = xshift & 7;
	lshift = 8 - rshift;

	line = pdst + xshift / 8 +
	    nbytes * (info.overallAscent - pci->metrics.ascent);
	pglyph = pglyphBase + pci->byteOffset;

	gWidth = gWidth - 1 >> 3;
	if (!gWidth) {
	    j = nbytes - 1;
	    for (i = 0; i < gHeight; i++) {
		*line++ |= *pglyph >> rshift;
		*line   |= *pglyph << lshift;
		line += j;
		pglyph += nbyGlyphWidth;
	    }
	} else {
	    gWidth++;
	    for (i = 0; i < gHeight; i++) {
		for (j = 0; j < gWidth; j++) {
		    *line++ |= pglyph[j] >> rshift;
		    *line   |= pglyph[j] << lshift;
		}
		line += nbytes - gWidth;
		pglyph += nbyGlyphWidth;
	    }
	}

	/* Are there more characters? */
	if (!--nglyph)
	    break;

	/* Point xshift to "center" of character. */
	xshift -= pci->metrics.leftSideBearing;

	/* Bump xshift to "center" of next character. */
	xshift += pci->metrics.characterWidth;

	pci = *++ppci;	/* next character */

	/* Back xshift to left of next character. */
	xshift += pci->metrics.leftSideBearing;
    }
    aluSave = pGC->alu;
    pGC->alu = pGC->fgPixel ? GXor : GXandInverted;
    mxValidateGC(pGC, GCFunction|GCFillStyle|GCForeground, pDrawable);
    (*pGC->ops->PutImage)(pDrawable, pGC, 1, x, y,
	totwidth, height, 0, XYPixmap, pdst);
    pGC->alu = aluSave;
    pGC->serialNumber |= GC_CHANGE_SERIAL_BIT;
    pGC->stateChanges = GCFunction;
    DEALLOCATE_LOCAL(pdst);
    return 0;
}

static void
mxBox(pDrawable, pGC, x, y, w, h)
DrawablePtr pDrawable;
GCPtr pGC;
int x, y, w, h;
{
    BoxRec box;
    DDXPointPtr		ppt, pptFirst;
    int	*pw, *pwFirst;

    x += pDrawable->x;
    y += pDrawable->y;

    box.x1 = x;
    box.x2 = x + w;
    box.y1 = y;
    box.y2 = y + h;
    pptFirst = (DDXPointPtr) ALLOCATE_LOCAL(h * sizeof(DDXPointRec));
    ppt = pptFirst;
    pwFirst = (int *) ALLOCATE_LOCAL(h * sizeof(int));
    pw = pwFirst;
    while (y < box.y2) {
	ppt->x = x;
	ppt->y = y++;
	ppt++;
	*pw++ = w;
    }

    mxFillSpans(pDrawable, pGC, h, pptFirst, pwFirst,
	SPANS_SORTED|SPANS_RECT, &box);

    DEALLOCATE_LOCAL(pwFirst);
    DEALLOCATE_LOCAL(pptFirst);
}
