#include "X.h"
#include "Xmd.h"
#include "Xproto.h"
#include "fontstruct.h"
#include "dixfontstr.h"
#include "scrnintstr.h"

#include "ega.h"

Bool
egaRealizeFont( pscr, pFont)
    ScreenPtr	pscr;
    FontPtr	pFont;
{
    /*
     * pGC->font is now known to be valid
     */
    FontInfoPtr		pfi = pFont->pFI;
    CharInfoPtr		pci;
    int numCols = pfi->lastCol - pfi->firstCol + 1;
    int numRows = pfi->lastRow - pfi->firstRow + 1;
    char *pglyphBase = pFont->pGlyphs;
    char *pglyph;
    int gWidth, gHeight;
    char mask;

    numCols *= numRows;
    for (pci = pFont->pCI; numCols--; pci++) {
	if (!pci->exists)
	    continue;
	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	if ((gWidth & 7) == 0)
	    continue;
	mask = 0xff00 >> (gWidth & 7);
	pglyph = pglyphBase + pci->byteOffset;
	gWidth >>= 3;
	while (gHeight--) {
		pglyph[gWidth] &= mask;
		pglyph += gWidth+1;
	}
    }
    return (TRUE);
}

Bool
egaUnrealizeFont(pscr, pFont)
ScreenPtr	pscr;
FontPtr		pFont;
{
	return TRUE;
}
