	TITLE	movebits

	.286p

X	EQU	4

IBM_TEXT	SEGMENT  WORD PUBLIC 'CODE'
IBM_TEXT	ENDS
IBM_TEXT	SEGMENT
	ASSUME	CS: IBM_TEXT

; copybits(psrc, pdst, soff, doff, n, rop)
; u_char *psrc, *pdst;	/* byte pointers to src and dst memory */
; int soff, doff;	/* offset into src and dst 0 <= soff,doff <= 7 */
; int n;		/* number of bits to copy */
; int rop;		/* operation to perform */
psrc	EQU	0
pdst	EQU	4
soff	EQU	8
doff	EQU	10
n	EQU	12
rop	EQU	14

GXclear		EQU	00		; 0
GXand		EQU	01		; src AND dst
GXandReverse	EQU	02		; src AND NOT dst
GXcopy		EQU	03		; src
GXandInverted	EQU	04		; NOT src AND dst
GXnoop		EQU	05		; dst
GXxor		EQU	06		; src XOR dst
GXor		EQU	07		; src OR dst
GXnor		EQU	08		; NOT src AND NOT dst
GXequiv		EQU	09		; NOT src XOR dst
GXinvert	EQU	0ah		; NOT dst
GXorReverse	EQU	0bh		; src OR NOT dst
GXcopyInverted	EQU	0ch		; NOT src
GXorInverted	EQU	0dh		; NOT src OR dst
GXnand		EQU	0eh		; NOT src OR NOT dst
GXset		EQU	0fh		; 1

; DS:SI:	psrc
; ES:DI:	pdst
; CX:		n
; BH:		bitstoshift
; AX,DX		temporary registers
	extrn	_copybits:near
	extrn	_orbits:near

	PUBLIC	_movebits
_movebits	PROC NEAR
	push	bp
	mov	bp,sp
	mov	ax,[bp+X+rop]
	cmp	ax,GXcopy
	jnz	$L1:
	pop	bp
	jmp	_copybits
$L1:
	cmp	ax,GXor
	jnz	$L2:
	pop	bp
	jmp	_orbits
$L2:
	push	si
	push	di
	push	ds
	lds	si,[bp+X+psrc]
	les	di,[bp+X+pdst]
