/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: scrinit.c,v 1.57 88/10/02 15:08:27 rws Exp $ */

#include <fcntl.h>
#include "X.h"
#include "Xproto.h"	/* for xColorItem */
#include "Xmd.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "resource.h"
#include "colormap.h"
#include "i8.h"
#include "afidata.h"
#include "cursor.h"
#include "..\common\ibmmouse.h"
#include "../../mi/mistruct.h"
#include "dix.h"
#include "../../mi/mipointer.h"
#include <dos.h>

#include "servermd.h"
#include <string.h>

static VisualRec far visuals[] = {
/* vid  class       bpRGB cmpE nplan rMask gMask bMask oRed oGreen oBlue */
   0,   PseudoColor, 6,   256,   8,    0,    0,    0,    0,   0,     0
};

static VisualID VID;

static DepthRec depth[] = {
/* depth	numVid		vids */
    8,		1,		&VID,
#ifdef notdef
    1,		0,		0
#endif
};

i8PrivScr _near i8priv;

Bool
i8init(iScreen, pScreen, argc, argv)
int iScreen;
ScreenPtr pScreen;
int argc;
char **argv;
{
    ColormapPtr pColormap;
    int		mode = 1;
    int		i;
    CARD16	zero = 0, ones = ~0;
    struct	aifpb aifpb;
    struct	hqmode_data hqmode_data;
    struct	hqdps_data hqdps_data;
    struct	hinit_data hinit_data;
    struct	hsbp_data hsbp_data;

    while (argc > 0) {
	if (strcmp(*argv, "-mode") == 0) {
		argv++; argc--;
		if (!argc) {
			printf("bad -mode argument\n");
			break;
		}
		mode = atoi(*argv);
	}
	argv++; argc--;
    }

    if (i8Generation != serverGeneration)
    {
	i8GCPrivateIndex = AllocateGCPrivateIndex();
/*	i8ScrPrivateIndex = AllocateScreenPrivateIndex(); */
	visuals[0].vid = FakeClientID(0);
	VID = visuals[0].vid;
	i8Generation = serverGeneration;
    }
    if (!AllocateGCPrivate(pScreen, i8GCPrivateIndex, sizeof(i8PrivGC)))
	return FALSE;

    i8priv.ai_funcs = getafi();
    if (!i8priv.ai_funcs) {
	fprintf(stderr, "8514 AI not loaded.\n");
	return FALSE;
    }
    hqmode_data.length = 18;
    HQMODE(&hqmode_data);
printf("height: %d width: %d\n", hqmode_data.height, hqmode_data.width);

    hqdps_data.length = 6;
    HQDPS(&hqdps_data);
printf("stack: %u buffer: %u palette: %u\n", hqdps_data.stack_size, hqdps_data.buffer_size, hqdps_data.palette_size);

    i8priv.task_buffer = xalloc(hqdps_data.buffer_size + 16);
    if (!i8priv.task_buffer)
	return FALSE;
    hinit_data.task_seg = ((u_long)FP_SEG(i8priv.task_buffer) * 16 +
	FP_OFF(i8priv.task_buffer) + 15) / 16;
    hinit_data.length = 2;
    HINIT(&hinit_data);

    i8priv.saved_palette = xalloc(hqdps_data.palette_size + 2);
    if (!i8priv.saved_palette) {
	xfree(i8priv.task_buffer);
	i8priv.task_buffer = 0;
	return FALSE;
    }
    *(u_short *)i8priv.saved_palette = hqdps_data.palette_size;
    HSPAL(i8priv.saved_palette);

    aifpb.length = 3;
    aifpb.params[0] = 0x40;	/* set to 0x40 to not load default palette */
    aifpb.params[1] = mode;
    aifpb.params[2] = 0;
    HOPEN(&aifpb);
    if (aifpb.params[2]) {
	fprintf(stderr, "8514: error status %d\n", aifpb.params[2]);
	return FALSE;
    }
printf("call hqmode:\n");
    hqmode_data.length = 18;
    HQMODE(&hqmode_data);
    pScreen->width = hqmode_data.width;
    pScreen->height = hqmode_data.height;
    pScreen->mmWidth = pScreen->width * 25 / hqmode_data.horiz_res;
    pScreen->mmHeight = pScreen->height * 25 / hqmode_data.vert_res;
    depth[0].depth = hqmode_data.planes;
    visuals[0].nplanes = hqmode_data.planes;
    switch (hqmode_data.planes) {
	case 1:
	    visuals[0].ColormapEntries = 1;
	    break;
	case 4:
	    visuals[0].ColormapEntries = 16;
	    break;
	case 8:
	    visuals[0].ColormapEntries = 256;
	    break;
	default:
	    printf("HELP: nplanes = %d\n", hqmode_data.planes);
	    break;
    }

printf("call HSHS\n");
    aifpb.length = 0;
    HSHS(&aifpb);

printf("call HSBP\n");
    hsbp_data.length = 12;
    hsbp_data.graph_plane = -1;
    hsbp_data.alpha_plane = -1;
    hsbp_data.disp_plane = -1;
    HSBP(&hsbp_data);

printf("call HEGS\n");
    aifpb.length = 0;
    HEGS(&aifpb);

    pScreen->devPrivate = (pointer)&i8priv;

printf("i8: mode=%d, width=%d, height=%d, planes=%d\n",
hqmode_data.mode, pScreen->width, pScreen->height, hqmode_data.planes);

    pScreen->numDepths = 1;
    pScreen->allowedDepths = depth;

    pScreen->rootDepth = depth[0].depth;
    pScreen->rootVisual = VID;
    pScreen->backingStoreSupport = NotUseful;
    pScreen->saveUnderSupport = NotUseful;

    pScreen->numVisuals = 1;
    pScreen->visuals = visuals;

    pScreen->CreateWindow = i8CreateWindow;
    pScreen->DestroyWindow = i8DestroyWindow;
    pScreen->PositionWindow = i8PositionWindow;
    pScreen->RealizeWindow = i8MapWindow;
    pScreen->UnrealizeWindow = i8UnmapWindow;
    pScreen->ChangeWindowAttributes = i8ChangeWindowAttributes;
    pScreen->ValidateTree = miValidateTree;
    pScreen->WindowExposures = miWindowExposures;

    pScreen->ClearToBackground = miClearToBackground;
    pScreen->PaintWindowBackground = i8PaintWindow;
    pScreen->PaintWindowBorder = i8PaintWindow;
    pScreen->CopyWindow = i8CopyWindow;

    pScreen->RealizeFont = i8RealizeFont;
    pScreen->UnrealizeFont = i8UnrealizeFont;
    pScreen->GetImage = i8GetImage;
    pScreen->GetSpans = i8GetSpans;
    pScreen->CreatePixmap = i8CreatePixmap;
    pScreen->DestroyPixmap = i8DestroyPixmap;

    pScreen->CreateColormap = i8CreateColormap;
    pScreen->DestroyColormap = i8DestroyColormap;
    pScreen->InstallColormap = i8InstallColormap;
    pScreen->UninstallColormap = i8UninstallColormap;
    pScreen->ListInstalledColormaps = i8ListInstalledColormaps;
    pScreen->StoreColors = i8StoreColors;
    pScreen->ResolveColor = i8ResolveColor;

    pScreen->CreateGC = i8CreateGC;

    pScreen->RegionCreate = miRegionCreate;
    pScreen->RegionInit = miRegionInit;
    pScreen->RegionCopy = miRegionCopy;
    pScreen->RegionDestroy = miRegionDestroy;
    pScreen->RegionUninit = miRegionUninit;
    pScreen->Intersect = miIntersect;
    pScreen->Inverse = miInverse;
    pScreen->Union = miUnion;
    pScreen->Subtract = miSubtract;
    pScreen->RegionReset = miRegionReset;
    pScreen->TranslateRegion = miTranslateRegion;
    pScreen->RectIn = miRectIn;
    pScreen->PointInRegion = miPointInRegion;
    pScreen->RegionNotEmpty = miRegionNotEmpty;
    pScreen->RegionEmpty = miRegionEmpty;
    pScreen->RegionExtents = miRegionExtents;
    pScreen->RegionAppend = miRegionAppend;
    pScreen->RegionValidate = miRegionValidate;
#ifdef SHAPE
    pScreen->BitmapToRegion = mfbPixmapToRegion;
    pScreen->RectsToRegion = miRectsToRegion;
#endif
    pScreen->SendGraphicsExpose = miSendGraphicsExpose;

    pScreen->CloseScreen = i8Close;
    pScreen->SaveScreen = i8SaveScreen;

    /*
     * Cursor functions
     */
    pScreen->PointerNonInterestBox = mousePointerNonInterestBox;
    pScreen->RealizeCursor = mouseRealizeCursor;
    pScreen->UnrealizeCursor = mouseUnrealizeCursor;
    pScreen->DisplayCursor = mouseDisplayCursor;
    pScreen->SetCursorPosition = mouseSetCursorPosition;
    pScreen->CursorLimits = mouseCursorLimits;
    pScreen->ConstrainCursor = mouseConstrainCursor;
    pScreen->RecolorCursor = i8RecolorCursor;

    pScreen->QueryBestSize = i8QueryBestSize;

    /* os layer stuff */
#ifdef notused
    pScreen->BlockHandler = i8BlockHandler;
    pScreen->WakeupHandler = i8WakeupHandler;
    pScreen->wakeupData = (pointer)0;
    pScreen->blockData = (pointer)0;
#endif

    pScreen->defColormap = (Colormap) FakeClientID(0);
    pScreen->minInstalledCmaps = 1;
    pScreen->maxInstalledCmaps = 1;
    pScreen->whitePixel = 0xff;
    pScreen->blackPixel = 0;
printf("call CreateColormap\n");
    if ((i = CreateColormap(pScreen->defColormap, pScreen, visuals,
	&pColormap, AllocNone, 0)) != Success || pColormap == NULL) {
		ErrorF("i8init: CreateColormap returned %d\n", i);
		ErrorF("memavl=%u\n", _memavl());
		return FALSE;
    }
printf("call AllocColor\n");
    if (AllocColor(pColormap, &zero, &zero, &zero, (&pScreen->blackPixel), 0) ||
	AllocColor(pColormap, &ones, &ones, &ones, (&pScreen->whitePixel), 0))
		FatalError("i8Init: Can't alloc black & white pixels\n");
printf("call i8InstallColormap\n");
    i8InstallColormap(pColormap);

    /* Initialize the mouse to black on white */
    i8Cursor.fore_color = pScreen->blackPixel;
    i8Cursor.back_color = pScreen->whitePixel;
    i8Cursor.depth = depth[0].depth;

printf("i8init returns\n");
    return TRUE;
}

/* Should this be a 8-bit array? */
int near endtab[16] = 
	{
	0x0000,
	0x8000,
	0xC000,
	0xE000,
	0xF000,
	0xF800,
	0xFC00,
	0xFE00,
	0xFF00,
	0xFF80,
	0xFFC0,
	0xFFE0,
	0xFFF0,
	0xFFF8,
	0xFFFC,
	0xFFFE
	};

u_char near masktab[8] = {
	0x80,
	0x40,
	0x20,
	0x10,
	0x08,
	0x04,
	0x02,
	0x01
};

void _near
screen_abort()
{
	if (i8priv.ai_funcs)
		i8Close(0, (ScreenPtr)0);
}
