/*   
 *	rarp.c
*/
#include "pcdefs.h"
#include "protocol.h"
#include "mbuf.h"
#include "data.h"
#include "config.h"
#include "funcdef.h"

/***************************************************************************
*   getrarp
*   Look for a RARP response to arrive
*   wait for nndto seconds before returning failure.
*   If response arrives, return success.
*/
int near
getrarp()
{
	u_long t,tr;

	t = n_clicks() + TICKSPERSEC*10;  /* some seconds time out */
	tr = 0L;									/* one second retry */

	do {
		if (tr <= n_clicks()) {		/* need retry? */
			if (sendarp(myether, 0, htons(RARPQ)) < 0)
				return -1;
			tr = n_clicks() + TICKSPERSEC;
		}

		if (t <= n_clicks()) {		/* timed out */
			return -1;
		}

		netsleep();			/* can't have deadlock */
	} while (!Scon.myip);	/* until RARP is served */
	return 0;
}
