#include <pctcp/types.h>
#include "funcdef.h"

/* We use the intrinsic version of this function. */
int memcmp(void const _far *, void const _far *, unsigned);

#define	FIRST_VEC	0x20
#define	LAST_VEC	0xE0

int
locate_sys_vector()             /* search for the packet driver */
{
	char _far *vptr;
	unsigned short vector;

	for (vector = FIRST_VEC; vector < LAST_VEC; vector++) {
		vptr = *(char _far * _far *)(unsigned long)(vector << 2) + 3;
		if (!memcmp(vptr, "TCPTSR", 6)) {
			patch_vec(vector);
			return(0);	/* Success */
		}
	}
	dfputs("PCTCP resident module is not loaded.\r\n");
	return -5;
}
