#include "pcdefs.h"
#include "protocol.h"
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"
#include "config.h"
#include "tcp.h"

extern struct tcpport _far *ports[NPORTS];
extern char _near shared_buf[4096];
extern int neterrno;

int _fastcall
tcp_read(buf)
short _far *buf;
{
    unsigned fd = buf[1];
    unsigned len = buf[2];
    unsigned count;
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    if (p->state < SEST) {
	neterrno = NETERR_NOTESTAB;
	return -1;
    }
    count = p->infree - p->inbase;
    if (!count) {
	if (p->flag & O_GOTALL)
	    neterrno = NETERR_NOTESTAB;
	else
	    neterrno = NETERR_WOULD_BLOCK;
	return -1;
    }
    if (count <= len) {
	memcpy(shared_buf, &p->datain[p->inbase], count);
	p->inbase = 0;
	p->infree = 0;
	/* If the window was < 1/2, then send fast to wake other
	 * side up.
	 */
	if (p->credit < 2048)
		p->wait_tx = 4;
	else {
		if (!p->wait_tx || p->wait_tx > 50)
			p->wait_tx = 50;
		else if (p->wait_tx > 4)
			p->wait_tx -= 4;
	}
	p->credit = WINDOWSIZE;
	buf[0] = count;
	return 2;
    }
    memcpy(shared_buf, &p->datain[p->inbase], len);
    count -= len;
    p->inbase += len;
    /* If there is more to read, we will probably read it in the
     * near future, so don't send a window update yet unless
     * the window size has increased from zero.
     */
    if (p->inbase > WINDOWSIZE / 4) {
	    memcpy(p->datain, &p->datain[p->inbase], count);
	    p->infree = count;
	    if (p->credit < 1024 && count < WINDOWSIZE - 1024)
		    p->wait_tx = 4;
	    else {
		    /* count will be < 3072.  The lower count, the
		     * bigger the window size.  If the window size
		     * is big, send faster.  count >> 6 will be between
		     * 0 and 48. */
		    if (!p->wait_tx || p->wait_tx > 25)
			    p->wait_tx = (count >> 6) + 4;
		    else if (p->wait_tx > 3)
			    p->wait_tx -= 3;
	    }
	    p->credit = WINDOWSIZE - count;
	    p->inbase = 0;
    }
    buf[0] = len;
    return 2;
}

int _fastcall
tcp_write(buf)
short _far *buf;
{
    unsigned fd = buf[1];
    unsigned len = buf[2];
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    if (p->state < SEST || p->flag & (O_CLOSING|O_CLOSED)) {
	neterrno = NETERR_NOTESTAB;
	return -1;
    }

    len = min(len, (unsigned)WINDOWSIZE - p->outfree);
    if (!len) {
	neterrno = NETERR_WOULD_BLOCK;
	return -1;
    }
    memcpy(&p->dataout[p->outfree], shared_buf, len);
    p->outfree += len;
    if (p->outfree == len || p->rto < (u_short)(n_clicks() - p->lasttime))
	    transq(p);
    buf[0] = len;
    return 2;
}

int _fastcall
tcp_eof(buf)
short _far *buf;
{
    if (SoClose(buf[1]) < 0)
	return -1;
    buf[0] = 0;
    return 2;
}

int _fastcall
SoClose(fd)
unsigned fd;
{
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    switch (p->state) {
	case SLISTEN:		/* we don't care anymore */
	case SSYNS:
	    p->state = SCLOSED;
	case SCLOSED:
	    p->flag |= O_CLOSED;
	    break;
	case SEST:		/* must initiate close */
	case SCWAIT:		/* other side already closed */
				    /* send FIN */
	    if (!p->outfree) {
		    p->flag |= O_CLOSED;
		    p->outpkt.t.flags = TFIN | TACK;
		    tcpsend(p, 0);
		    if (p->state == SEST)
			    p->state = SFW1; /* wait for ACK of FIN */
		    else
			    p->state = SLAST;
	    } else {
		    p->flag |= O_CLOSING;
	    }
	    break;
	default:
	    neterrno = NETERR_NOTESTAB;
	    return -1;
    }
    return 0;
}

int _fastcall
tcp_drain(buf)
short _far *buf;
{
    unsigned fd = buf[1];
    unsigned count;
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    if (p->state < SEST) {
	neterrno = NETERR_NOTESTAB;
	return -1;
    }
    count = p->infree - p->inbase;
    if (!count) {
	if (p->flag & O_GOTALL)
	    neterrno = NETERR_NOTESTAB;
	else
	    neterrno = NETERR_WOULD_BLOCK;
	return -1;
    }
    p->inbase = 0;
    p->infree = 0;
    /* If the window was < 1/2, then send fast to wake other
     * side up.
     */
    if (p->credit < 2048)
	    p->wait_tx = 4;
    else {
	    if (!p->wait_tx || p->wait_tx > 50)
		    p->wait_tx = 50;
	    else if (p->wait_tx > 4)
		    p->wait_tx -= 4;
    }
    p->credit = WINDOWSIZE;
    buf[0] = count;
    return 2;
}
