program gconfig;
uses
   INIFilag, dos;
var
   i : TINIFile;
   s : PSection;

const
   LineErrorPre = 'gconfig: Warning: Your GEMSYS.CFG "';
   LineErrorMid = '" line ';
   FormatErrorMid = 'has an unexpected format (';
   RangeErrorMid = 'is out of range (';
   LineErrorPost = ').';
   LineErrorNotANumber = 'not a number';
   VideoErrorPre = 'gconfig: Video driver ID ';
   MousePortErrorPre = 'gconfig: Mouse Port ';
   MouseTypeErrorPre = 'gconfig: Mouse type ';
   InvalidErrorMid = 'is invalid (';
   FileErrorPre = 'gconfig: Error: Your GEMSYS.CFG file ';
   FileMissingErrorPost = 'is missing.';

function UpperCase(stuff : string) : string;
   var
      i : integer;
      b : string;
   begin
      b := '';
      for i := 1 to length(stuff) do
         b := b + UpCase(stuff[i]);
      UpperCase := b;
   end;

function FileExists(f : string) : boolean;
var
   t : text;
begin
   {$I-}
   Assign(t,f);
   Reset(t);
   Close(t);
   {$I+}
   FileExists := ((IOResult = 0) and (f <> ''));
end;

function GetMyDriveLetter : char;
var
   rt : string;
begin
   rt := FExpand(ParamStr(0));
   if rt <> '' then
      GetMyDriveLetter := rt[1]
   else
      GetMyDriveLetter := chr(0);
end;

function spc(count : integer) : string;
var l : integer; b : string;
begin
   b := '';
   for l := 1 to count do
      b := b + ' ';
   spc := b;
end;

procedure ListVideoDrivers;
var
   maxl : string;
   maxDriver, code : integer;
   i : integer;
   drv : string;
   driverDesc : string;
   driverName : string;
   currentDrv : integer;
begin
   maxl := GetValue(s,'MaxDrv');
   Val(maxl,maxDriver,code);
   if code <> 0 then
      writeln(LineErrorPre + 'MaxDrv' + LineErrorMid + FormatErrorMid + LineErrorNotANumber  + LineErrorPost);
   maxl := GetValue(s,'CurrentDrv');
   Val(maxl,currentDrv,code);
   if code <> 0 then
      writeln(LineErrorPre + 'CurrentDrv' + LineErrorMid + FormatErrorMid + LineErrorNotANumber + LineErrorPost);
   writeln('  ID : Driver        : Description');
   for i := 0 to maxDriver do
   begin
      Str(i,drv);
      DriverDesc := GetValue(s,'Driver'+drv);
      if DriverDesc <> '' then
      begin
         DriverDesc := copy(DriverDesc,2,length(DriverDesc));
         code := pos('"',DriverDesc);
         driverName := copy(DriverDesc,code+2,length(DriverDesc));
         driverDesc := Copy(DriverDesc,1,code-1);
         if currentDrv = i then
            write('* ')
         else
            write('  '); 
         write(drv + spc(3-length(drv))+': ');
         write(driverName + spc(11 - length(driverName)) + ': ');
         writeln(driverDesc);
      end;
   end;
end;

procedure SetVideoDriver(id : string);
var
   realID, code : integer;
   maxDriver : integer;
   maxl : string;
   realDriver : string;
begin
   maxl := GetValue(s,'MaxDrv');
   Val(maxl, maxDriver, code);
   if code <> 0 then
   begin
      writeln(LineErrorPre + 'MaxDrv' + LineErrorMid + FormatErrorMid + LineErrorNotANumber + LineErrorPost);
      exit;
   end;
   Val(id, realID, code);
   if code <> 0 then
   begin
      writeln(VideoErrorPre + FormatErrorMid + LineErrorNotANumber + LineErrorPost);
   end;
   if realID > maxDriver then
   begin
      writeln(VideoErrorPre + RangeErrorMid + 'cannot be more than '+maxl+LineErrorPost);
      exit;
   end;
   realDriver := GetValue(s, 'Driver'+id);
   if realDriver = '' then
   begin
      writeln(VideoErrorPre + InvalidErrorMid + 'there is no driver with this number'+LineErrorPost);
      exit;
   end;
   SetValue(s, 'CurrentDrv',id);
end;

procedure SetMouse(id : string);
var
   u : string;
begin
   u := UPPERCASE(id);
   if (u = 'NONE') or (u = 'NONE') then
      SetValue(s,'MouseType','0')
   else if (u='MOUSE-SYSTEMS') or (u='MOUSESYSTEMS') then
      SetValue(s,'MouseType','1')
   else if (u='MOUSE.COM') or (U = 'OTHER') then
      SetValue(s,'MouseType','2')
   else if (u='MICROSOFT') then
      SetValue(s,'MouseType','3')
   else if (u='PS2') or (u='PS/2') then
   begin
      SetValue(s,'MouseType','10');
      SetValue(s,'MousePort','255');
   end
   else
      writeln(MouseTypeErrorPre + InvalidErrorMid + 'see the help screen' + LineErrorPost);
end;

{ ... work in progress be here ... }
{procedure InstallVideoDriver(driverpath : string; activate : boolean);
begin

end;}

procedure SetMousePort(id : string);
var
   realID : string;
   currMouse : string;
   rCurrMouse, code : integer;
begin
   currMouse := GetValue(s,'MouseType');
   Val(currMouse, rCurrMouse, code);
   if code <> 0 then
   begin
      writeln(LineErrorPre + 'MouseType' + LineErrorMid + FormatErrorMid + LineErrorNotANumber + LineErrorPost);
      exit;
   end;
   realID := UPPERCASE(copy(id,1,4));
   if realID = 'COM1' then
      SetValue(s,'MousePort','1')
   else if realID = 'COM2' then
      SetValue(s,'MousePort','2')
   else
      writeln(MousePortErrorPre + InvalidErrorMid + 'must be COM1 or COM2' + LineErrorPost);
end;

procedure ShowUsage;
begin
   writeln('gconfig [-listvideodrivers ] [ -videodriver <number> ] [ -mouse none |');
   writeln('        mouse-systems | mousesystems | mouse.com | other | microsoft | ps2 |');
   writeln('        ps/2 ] [ -mouseport COM1[:] | COM2[:] ] [ -help |  -? ]');
end;

procedure ShowHelp;
begin
   writeln('gconfig 0.10');
   writeln('Copyright (c) 2002 Rob Mitchelmore / Triplet Software');
   writeln;
   ShowUsage;
   writeln;
   writeln('All options can be used either with a "-" or with a "/".');
   writeln;
   writeln('-listvideodrivers   Lists the video drivers installed in GEMSYS.CFG, giving the');
   writeln('                    driver number, driver file name, and brief description.');
   writeln('-videodriver        Sets the current video driver - the number can be got from');
   writeln('                    the -listvideodrivers option.');
   writeln('-mouse              Sets the mouse type:');
   writeln('                      none                        - No mouse, use keyboard only');
   writeln('                      mouse-systems, mousesystems - Mouse Systems Mouse');
   writeln('                      mouse.com, other            - Use existing DOS MOUSE.COM');
   writeln('                      microsoft                   - Microsoft bus mouse');
   writeln('                      ps2 | ps/2                  - Standard PS/2 mouse');
   writeln('-mouseport          Sets the current mouse port.  Only has any effect on serial');
   writeln('                    mice.');
   writeln;
end;

var
   newMouse : string;
   newMousePort : string;
   newVideoDrv : string;
   j : integer;
   doneValidParameter : boolean;

begin
   j := 0;
   doneValidParameter := false;
   if (fileExists(GetMyDriveLetter+':\GEMAPPS\GEMSYS\GEMSYS.CFG') and (ParamCount > 0)) then
   begin
     LoadINIFile(i,GetMyDriveLetter+':\GEMAPPS\GEMSYS\GEMSYS.CFG');
     s := GetSection(i,SectionIndex(i,'drivers'));
     while j < ParamCount do
     begin
        inc(j);
        if (UPPERCASE(paramstr(j))='-LISTVIDEODRIVERS') or (UPPERCASE(paramstr(j))='/LISTVIDEODRIVERS') then
           ListVideoDrivers
        else if (UPPERCASE(paramstr(j))='-VIDEODRIVER') or (UPPERCASE(paramstr(j))='/VIDEODRIVER') then
        begin
           inc(j);
           SetVideoDriver(paramstr(j));
        end
        else if (UPPERCASE(paramstr(j))='-MOUSE') or (UPPERCASE(paramstr(j))='/MOUSE') then
        begin
           inc(j);
           SetMouse(paramstr(j));
        end
        else if (UPPERCASE(paramstr(j))='-MOUSEPORT') or (UPPERCASE(paramstr(j))='/MOUSEPORT') then
        begin
           inc(j);
           SetMousePort(ParamStr(j));
        end
        else if (UPPERCASE(paramstr(j))='-HELP') or (UPPERCASE(paramstr(j))='/HELP')
        or (UPPERCASE(paramstr(j))='-?') or (UPPERCASE(paramstr(j))='/?') then
           ShowHelp;
     end;
     SaveINIFile(i,GetMyDriveLetter+':\GEMAPPS\GEMSYS\GEMSYS.CFG'); 
     FreeINIFile(i);
   end
   else
   begin
      if ParamCount=0 then
         ShowUsage
      else
         writeln(FileErrorPre + FileMissingErrorPost);
   end;
end.
