

/************************************************************************/
/*                                                                      */
/*                   ****   *****  ****   ****  ****                    */
/*                   *   *    *    *   *  *     *                       */
/*                   ****     *    ****   ***   ***                     */
/*                   *   *    *    *  *   *     *                       */
/*                   ****     *    *   *  ****  ****                    */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*                   Object Tree processing functions                   */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#include "bench.h"       /* GEM and workbench bindings */



/**********************************************************************/
/*                                                                    */
/*                           Wb_switch                                */
/*                                                                    */
/*   This functions returns the value of the specified state in the   */
/* state field of an object. It takes the following parameters:       */
/*                                                                    */
/*        LONG tree             the address of the tree               */
/*        WORD start_object     The object being analysed             */
/*        WORD state            The state being considered            */
/*                                                                    */
/*   The function returns TRUE or FALSE suitably                      */
/*                                                                    */
/**********************************************************************/

BOOLEAN wb_switch (tree, item, state)
LONG tree;
WORD item, state;

{

  return (LWGET (OB_STATE (item)) & state);

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_find                                  */
/*                                                                    */
/*   This functions returns the identity of the next selected item    */
/* in a tree. It takes the following parameters:                      */
/*                                                                    */
/*        LONG tree             the address of the tree               */
/*        WORD start_object     Either the parent of the start box,   */
/*                              or -1 if the next is wanted.          */
/*        WORD state            The state being searched for          */
/*        WORD maxdepth         The maximum depth to which the search */
/*                              for selected objects may go           */
/*                                                                    */
/*   The function returns minus one if no item has been selected.     */
/*                                                                    */
/**********************************************************************/

WORD wb_find (tree, start_object, state, maxdepth)
LONG tree;
WORD start_object, state, maxdepth;

{ static WORD last,               /* last box selected */
              parent [MAX_DEPTH], /* parent stack */
              depth,              /* pointer to parent stack */
              strt;               /* start box in initial search */
         WORD c;                  /* temporary variable */
         BOOLEAN flag = TRUE;     /* avoid returning start item */

  /* if starting, set up depth stack */

  if (start_object >= 0) {

    last = start_object;
    depth = 0;
    strt = last;

  }

  /* consider next item */

  FOREVER {

    /* see if item selected */

    if (! flag)
      if (LWGET (OB_STATE (last)) & state)
        return (last);

    flag = FALSE;

    /* if object has a child, go down the generations */

    while (((c = LWGET (OB_HEAD (last))) >= 0) &&
           (depth < maxdepth)) {

      parent [depth++] = last;
      last = c;
      flag = TRUE;

    }

    /* otherwise look at the siblings */

    if (! flag) /* else on a while? */ {

      last = LWGET (OB_NEXT (last));

      /* if the 'sibling' is actually the parent ... */

      if ((depth > 0) && (last == parent [depth-1]))
        if (! (--depth))
          return (-1);

      /* make sure we're not back at the beginning */

      if (last == strt)
        return (-1);

    }

    /* bin round once already */

    flag = FALSE;

  }

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_state                                 */
/*                                                                    */
/*   This functions modifies the specified state of an item in a      */
/* tree. It probably has it's origins in DOODLE's do_obj and          */
/* undo_obj. It takes the following parameters:                       */
/*                                                                    */
/*        LONG tree             the tree with the object in it        */
/*        WORD item             The object in question                */
/*        WORD state            The state being changed               */
/*        WORD new_state        One of the following constants        */
/*                                WB_SET     set the state            */
/*                                WB_RESET   reset the state          */
/*                                WB_TOGGLE  toggle the state         */
/*                                                                    */
/*   The function returns minus one if no item has been selected.     */
/*                                                                    */
/**********************************************************************/

wb_state (tree, item, state, new_state)
LONG tree;
WORD item, state, new_state;

{ WORD old_state; /* the Campaign for Real Comments has censored this */
  LONG addr;      /* Postman Pat's dreams */

  /* get the object's address and current state */

  addr = OB_STATE (item);
  old_state = LWGET (addr);

  /* and (exciting, this) adjust it */

  if (new_state == WB_TOGGLE)
    new_state = ! (old_state & state);

  if (new_state == WB_SET)
    LWSET (addr, old_state | state);

  else
    LWSET (addr, old_state & ~state);

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_reply                                 */
/*                                                                    */
/*   This functions returns the current value of the text field of    */
/* a TEDINFO structure. It takes the following parameters:            */
/*                                                                    */
/*        LONG tree             the address of the tree               */
/*        WORD start_object     The editable text field               */
/*        WORD reply            The string to receive the reply       */
/*                                                                    */
/*   The function returns the length of the reply                     */
/*                                                                    */
/**********************************************************************/

WORD wb_reply (tree, item, reply)
LONG tree;
WORD item;
BYTE *reply;

{ LONG saddr;  /* address of string in object tree structure */
  WORD length, /* max length of string */
       i;      /* TRUE if it's raining, FALSE otherwise */
  BYTE *oaddr; /* current part of target string being written */
  BYTE ch;     /* current character */

  /* get lots of nice numbers */

  saddr = LLGET (OB_SPEC (item));
  length = LWGET (/* te_txtlen */ saddr + 24);
  saddr = LLGET (/* te_ptext */ saddr);
  oaddr = reply;

  /* copy string (there's probably a faster, machine code, way to do this:
     perhaps I should look at the new toolkit) */

  i = 0;

  do {

    ch = *oaddr++ = LBGET (saddr++);
    i++;

  } while ((ch != 0) && (i <= length));

  return (i - 2);

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_default                               */
/*                                                                    */
/*   This functions resets the default answer of the text field of    */
/* a TEDINFO structure. It takes the following parameters:            */
/*                                                                    */
/*        LONG tree             the address of the tree               */
/*        WORD start_object     The editable text field               */
/*        WORD default          The string to receive the reply       */
/*                                                                    */
/**********************************************************************/

wb_default (tree, item, def)
LONG tree;
WORD item;
BYTE *def;

{ LONG oaddr,  /* address of default answer */
       kaddr;  /* address of TEDINFO structure */
  WORD length, /* max length of string */
       count;  /* actual length of string */
  BYTE ch,     /* temporary character */
       *saddr; /* bit of source string being copied */

  /* get lots of nasty numbers */

  kaddr = LLGET (OB_SPEC (item));
  oaddr = LLGET (/* te_ptext */ kaddr);
  length = LWGET (/* te_txtlen */ kaddr + 24);
  saddr = def;
  count = 0;

  /* extremely complex and devious copy */
  
  do {

    ch = *(saddr++);
    LBSET (oaddr++, ch);
    count++;

  } while ((ch != 0) && (count <= length));

}


