

/************************************************************************/
/*                                                                      */
/*                    ****   ****   ***   ***   *                       */
/*                    *   *  *   *   *   *   *  *                       */
/*                    ****   *   *   *   *****  *                       */
/*                    *   *  *   *   *   *   *  *                       */
/*                    ****   ****   ***  *   *  *****                   */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*                         Dialogue processing                          */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#include "bench.h"       /* GEM and workbench bindings */



/**********************************************************************/
/*                                                                    */
/*                           Wb_dialogue                              */
/*                                                                    */
/*   This function has it's origins in the corresponding function in  */
/* DOODLE, DR's example program. It displays a dialogue, and monitors */
/* the user's interaction with it. It takes the following parameters: */
/*                                                                    */
/*        WORD control          one of                                */
/*                                  WB_START    start the dialogue    */
/*                                  WB_CONTINUE continue it!          */
/*                                  WB_REDRAW   continue + draw dial  */
/*                                  WB_END      finish it off         */
/*                                  WB_ALL      Start and finish      */
/*        LONG dialogue         the address of the dialogue's tree    */
/*        WORD start_object     the object in the dialogue tree which */
/*                              will have the text cursor             */
/*                                                                    */
/*   The function returns the exit box chosen by the user (if any)    */
/*                                                                    */
/**********************************************************************/

WORD wb_dialogue (control, dialogue, start_object)
WORD start_object, control;
LONG dialogue; /* (get using rsrc_gaddr) */

{ static WORD x, y, width, height; /* position of dialogue on screen */
         WORD exit_box;            /* exit box (useful comment no. 56428) */
         LONG tree;                /* various trees! */

  /* if starting dialogue, prepare it for the centre of the screen */

  if (control & WB_START) {

    form_centre (dialogue, &x, &y, &width, &height);
    form_dial (FMD_START, 0, 0, 0, 0, x, y, width, height); 

  }

  /* if not finishing, draw dialogue and allow user to fill it */

  if (control & (WB_START | WB_REDRAW))
    objc_draw (dialogue, ROOT, MAX_DEPTH, x, y, width, height);

  if (control & (WB_START | WB_REDRAW | WB_CONTINUE))
    exit_box = form_do (dialogue, start_object);

  else
    exit_box = -1;

  /* if finishing, remove dialogue */

  if (control & WB_FINISH)
    form_dial (FMD_FINISH, 0, 0, 0, 0, x, y, width, height);

  return (exit_box);

}

