/************************************************************************/
/*	File:	palette.c							*/
/************************************************************************/
/*									*/
/*		     GGGGG        EEEEEEEE     MM      MM		*/
/*		   GG             EE           MMMM  MMMM		*/
/*		   GG   GGG       EEEEE        MM  MM  MM		*/
/*		   GG   GG        EE           MM      MM		*/
/*		     GGGGG        EEEEEEEE     MM      MM		*/
/*									*/
/************************************************************************/
/*									*/
/*			  +--------------------------+			*/
/*			  | Digital Research, Inc.   |			*/
/*			  | 60 Garden Court	     |			*/
/*			  | Monterey, CA.    93940   |			*/
/*			  +--------------------------+			*/
/*									*/
/*   The  source code  contained in  this listing is a non-copyrighted	*/
/*   work which  can be  freely used.  In applications of  this source	*/
/*   code you  are requested to  acknowledge Digital Research, Inc. as	*/
/*   the originator of this code.					*/
/*									*/
/*   Author:	Tom Rolander						*/
/*   PRODUCT:	GEM Sample Desk Top Accessory				*/
/*   Module:	HELLO							*/
/*   Version:	February 15, 1985					*/
/*									*/
/************************************************************************/


/*

Page*/
/*------------------------------*/
/*	includes		*/
/*------------------------------*/
/* #include "deskacc.h"				 #define DESKACC x	*/

//#include "portab.h"				/* portable coding conv	*/
//#include "machine.h"				/* machine depndnt conv	*/
//#include "obdefs.h"				/* object definitions	*/
//#include "gembind.h"				/* gem binding structs	*/

#include "ppdgem.h"
#include "palette.h"
#include <dos.h>				// for FP_OFF and FP_SEG macros
#include <stdio.h>				// for FP_OFF and FP_SEG macros
#include <string.h>

/*------------------------------*/
/*	defines			*/
/*------------------------------*/

#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1

#define WDW_STYLE	0x0B	/* 0x0B = NAME | CLOSER | MOVER	*/


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Data Structures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	Global			*/
/*------------------------------*/
/*
GLOBAL WORD	contrl[11];		// control inputs		  
GLOBAL WORD	intin[80];		// max string length		  
GLOBAL WORD	ptsin[256];		// polygon fill points		  
GLOBAL WORD	intout[45];		// open workstation output	  
GLOBAL WORD	ptsout[12];
*/

/*------------------------------*/
/*	Local			*/
/*------------------------------*/

WORD	gl_wchar;			/* character width		*/
WORD	gl_hchar;			/* character height		*/
WORD	gl_wbox;			/* box (cell) width		*/
WORD	gl_hbox;			/* box (cell) height		*/
WORD	gem_handle;			/* GEM vdi handle		*/
WORD	vdi_handle;			/* palette vdi handle		*/
WORD	work_out[57];			/* open virt workstation values	*/
GRECT	work_area;			/* current window work area	*/
WORD	gl_apid;			/* application ID		*/
WORD	gl_rmsg[8];			/* message buffer		*/
LPBYTE	ad_rmsg;			/* LONG pointer to message bfr	*/
WORD	gl_itempalette = 0;		/* palette menu item		*/
WORD	gl_xfull;			/* full window 'x'		*/
WORD	gl_yfull;			/* full window 'y'		*/
WORD	gl_wfull;			/* full window 'w' width	*/
WORD	gl_hfull;			/* full window 'h' height	*/
WORD	ev_which;			/* event message returned value	*/
WORD	palette_whndl = 0;		/* palette window handle		*/
WORD	type_size;			/* system font cell size	*/
BYTE	*wdw_title =	" Palette ";	/* blank window title		*/
LPTREE	gl_obtree;
WORD	gl_rgbask[3];
WORD	gl_rgbgot[3];
WORD	gl_index = 0;
UWORD   mousex, mousey;                 /* mouse x,y position           */
UWORD   bstate, bclicks;                /* button state, & # of clicks  */
UWORD   kstate, kreturn;                /* key state and keyboard char  */

/* Set at startup. Attempts to load from PALETTE.CFG if present; if not,
 * uses whatever is in GEM. 
 * 
 * Updated when the UI is used to change the palette.  
 *
 * TO DO: 
 * 	Save/load palette to/from file.
 *	"Refresh" button in case palette goes funny.	
 * */

WORD	gl_palette[48];

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Local Procedures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	min			*/
/*------------------------------*/
WORD
min(a, b)			/* return min of two values	*/
WORD		a, b;
{
	return( (a < b) ? a : b );
}


/*------------------------------*/
/*	max			*/
/*------------------------------*/
WORD
max(a, b)			/* return max of two values	*/
WORD		a, b;
{
	return( (a > b) ? a : b );
}

/*
WORD myvdi(LPGSXPAR pb)
{
	WORD idx;

	// Entering graphics mode. Refresh palette.  
	if (pb->contrl[0] == 5 && pb->contrl[5] == 2)
	{
		v_exit_cur(pb->contrl[6]);
		for (idx = 0; idx < 16; idx++)
			vs_color(vdi_handle, idx, &gl_palette[idx*3]);
		
		return 0;
	}
	return 1;
}
*/

VOID send_redraw(WORD wh, WORD obj)
        {
        WORD    msg[8];
	WORD	x,y;
	
	objc_offset(gl_obtree, obj, &x, &y);

        msg[0] = WM_REDRAW;             /* Defined in GEMBIND.H     */
        msg[1] = gl_apid;               /* As returned by appl_init */
        msg[2] = 0;
        msg[3] = wh;                    /* Handle of window to redraw */
        msg[4] = x;
        msg[5] = y;
        msg[6] = gl_obtree[obj].ob_width;
        msg[7] = gl_obtree[obj].ob_height;
        appl_write(gl_apid, 16, ADDR(msg));     /* Use ADDR(msg) for portability */
        }


/*------------------------------*/
/*	grect_to_array		*/
/*------------------------------*/
VOID grect_to_array(LPGRECT area, WORD *array)	/* convert x,y,w,h to upr lt x,y and	*/
{
	*array++ = area->g_x;
	*array++ = area->g_y;
	*array++ = area->g_x + area->g_w - 1;
	*array = area->g_y + area->g_h - 1;
}

/*------------------------------*/
/*	do_open			*/
/*------------------------------*/
WORD
do_open(wh, org_x, org_y, x, y, w, h)	/* grow and open specified wdw	*/
WORD	wh;
WORD	org_x, org_y;
WORD	x, y, w, h;
{
	WORD	ret_code;

	graf_mouse(2,0x0L);
	graf_growbox(org_x, org_y, 21, 21, x, y, w, h);
	ret_code = wind_open(wh, x, y, w, h);
	graf_mouse(ARROW,0x0L);
	return(ret_code);
}


/*------------------------------*/
/*	do_close		*/
/*------------------------------*/
VOID
do_close(wh, org_x, org_y)	/* close and shrink specified window	*/
WORD	wh;
WORD	org_x, org_y;
{
	WORD	x, y, w, h;

	graf_mouse(2,0x0L);
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
	wind_close(wh);
	graf_shrinkbox(org_x, org_y, 21, 21, x, y, w, h);
	graf_mouse(ARROW,0x0L);
}

/*------------------------------*/
/*	set_clip		*/
/*------------------------------*/
VOID
set_clip(clip_flag, s_area)	/* set clip to specified area		*/
WORD	clip_flag;
GRECT	*s_area;
{
	WORD	pxy[4];

	grect_to_array(s_area, pxy);
	vs_clip(vdi_handle, clip_flag, pxy);
}

/*------------------------------*/
/*	align_x			*/
/*------------------------------*/
WORD
align_x(x)		/* forces word alignment for column positon,	*/
WORD	x;		/*   rounding to nearest word			*/
{
	return((x & 0xfff0) + ((x & 0x000c) ? 0x0010 : 0));
}	

/*------------------------------*/
/*	wdw_size		*/
/*------------------------------*/
VOID wdw_size(GRECT *box)	/* compute window size for given w * h chars	*/
{
	WORD	pw, ph;

	pw = gl_obtree->ob_width;
	ph = gl_obtree->ob_height;
	wind_calc(WC_BORDER, WDW_STYLE, gl_wfull/2-pw/2, gl_hfull/2-ph/2, pw, ph, &box->g_x, &box->g_y, &box->g_w, &box->g_h);
	box->g_x = align_x(box->g_x) - 1;
}


/*------------------------------*/
/*	disp_message		*/
/*------------------------------*/
VOID
disp_mesag(strptr, clip_area)	/* display message applying input clip	*/
BYTE	**strptr;
GRECT	*clip_area;
{
	WORD	pxy[4];
	WORD	ycurr;

	set_clip(TRUE, clip_area);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, WHITE);
	grect_to_array(&work_area, pxy);
	graf_mouse(M_OFF, 0x0L);
	vr_recfl(vdi_handle, pxy);	/* clear entire message area	*/

	vsl_color(vdi_handle,BLACK);
	vswr_mode(vdi_handle,MD_REPLACE);
	vsl_type (vdi_handle,FIS_SOLID);
	vswr_mode(vdi_handle, 1);
	ycurr = work_area.g_y - 1;
	while (*strptr)			/* loop through text strings	*/
	{
		ycurr += gl_hbox;
		v_gtext(vdi_handle, work_area.g_x, ycurr, *strptr++);
	}
	graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, clip_area);
}

VOID draw_wnd(GRECT *box)
{
	WORD	pxy[4];
	GRECT	rc;
	graf_mouse(M_OFF, 0x0L);

	gl_obtree[ROOT].ob_x = work_area.g_x;
	gl_obtree[ROOT].ob_y = work_area.g_y;
	objc_draw(gl_obtree, ROOT, MAX_DEPTH, box->g_x, box->g_y, box->g_w, box->g_h);

	/* XXX Draw sliders etc. */
	set_clip(TRUE, box);
	vsf_interior(vdi_handle, 1);

	vsf_color(vdi_handle, RED);
	rc.g_h = gl_obtree[RSLIDER].ob_height;
	rc.g_w = x_mul_div(gl_obtree[RSLIDER].ob_width, gl_rgbask[0], 1000);
	objc_offset(gl_obtree, RSLIDER, &rc.g_x, &rc.g_y);
	grect_to_array(&rc, pxy);
	vr_recfl(vdi_handle, pxy);
	vsf_color(vdi_handle, GREEN);
	rc.g_w = x_mul_div(gl_obtree[GSLIDER].ob_width, gl_rgbask[1], 1000);
	objc_offset(gl_obtree, GSLIDER, &rc.g_x, &rc.g_y);
	grect_to_array(&rc, pxy);
	vr_recfl(vdi_handle, pxy);
	vsf_color(vdi_handle, BLUE);
	rc.g_w = x_mul_div(gl_obtree[BSLIDER].ob_width, gl_rgbask[2], 1000);
	objc_offset(gl_obtree, BSLIDER, &rc.g_x, &rc.g_y);
	grect_to_array(&rc, pxy);
	vr_recfl(vdi_handle, pxy);
/* This code shows actual values. But the "actual" values returned don't seem
 * to be scaled in any way, making it rather difficult to do anything with
 * them.
	vsf_color(vdi_handle, RED);
	rc.g_h = gl_obtree[RSLIDER].ob_height;
	rc.g_w = x_mul_div(gl_obtree[RSLIDER].ob_width, gl_rgbgot[0], 1000);
	objc_offset(gl_obtree, RSLIDER, &rc.g_x, &rc.g_y);
	grect_to_array(&rc, pxy);
	vr_recfl(vdi_handle, pxy);
	vsf_color(vdi_handle, GREEN);
	rc.g_w = x_mul_div(gl_obtree[GSLIDER].ob_width, gl_rgbgot[1], 1000);
	objc_offset(gl_obtree, GSLIDER, &rc.g_x, &rc.g_y);
	grect_to_array(&rc, pxy);
	vr_recfl(vdi_handle, pxy);
	vsf_color(vdi_handle, BLUE);
	rc.g_w = x_mul_div(gl_obtree[BSLIDER].ob_width, gl_rgbgot[2], 1000);
	objc_offset(gl_obtree, BSLIDER, &rc.g_x, &rc.g_y);
	grect_to_array(&rc, pxy);
	vr_recfl(vdi_handle, pxy);
*/
	graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, box);
}

/*------------------------------*/
/*	do_redraw		*/
/*------------------------------*/
VOID do_redraw(WORD wh, GRECT *area)		/* redraw message applying area clip	*/
{
	GRECT	box;

	graf_mouse(M_OFF, 0x0L);
	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )
	{
		if (rc_intersect(area, &box))
		{
			if (wh == palette_whndl)
			{
				draw_wnd(&box);
			}
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(M_ON, 0x0L);
}


VOID query_palette(VOID)
{
	vq_color(vdi_handle, gl_index, 0, gl_rgbask);
	vq_color(vdi_handle, gl_index, 1, gl_rgbgot);
}


VOID add_file_name(BYTE *dname, BYTE *fname)
{
        BYTE    c;
        WORD    ii;

        ii = strlen(dname);
        while (ii && (((c = dname[ii-1])  != '\\') && (c != ':')))
                ii--;
        dname[ii] = '\0';
        strcat(dname, fname);
}


VOID get_path(BYTE *tmp_path, BYTE *spec)       /* get directory path name */
{
        WORD    cur_drv;

        cur_drv     = dos_gdrv();
        tmp_path[0] = cur_drv + 'A';
        tmp_path[1] = ':';
        tmp_path[2] = '\\';
        dos_gdir(cur_drv+1, ADDR(&tmp_path[3]));
        if (strlen(tmp_path) > 3) strcat(tmp_path, "\\");
        else                      tmp_path[2] = '\0';

        strcat(tmp_path, spec);
}


FILE *get_file(BOOLEAN loop, BYTE *file_name, BYTE *mask, char *mode)
{
        WORD    fs_iexbutton;
        BYTE    fs_iinsel[13];
        FILE    *fp;

        while (TRUE)
        {
                get_path(file_name, mask);
                fs_iinsel[0] = '\0';

                fsel_input(ADDR(file_name), ADDR(fs_iinsel), &fs_iexbutton);
                if (fs_iexbutton)
                {
                        add_file_name(file_name, fs_iinsel);
                        fp = fopen(file_name, mode);
                        if (!loop || (loop && fp != NULL))
                                return(fp);
                }
                else
                {
                        return((FILE *)NULL);
                }
	}
        return ((FILE *)NULL);
} /* get_file */


VOID save_palette(char *filename)
{
	FILE *fp;
	BYTE namebuf[160];
	int n;

	if (filename) 
	{
		fp = fopen(filename, "w");
		if (!fp) { 
			form_alert(1, "[3][Can't open file to save][ Cancel ]");
			return;
			}
	}
	else
	{
		fp = get_file(FALSE, namebuf, "*.PAL", "w");
		if (!fp) return;
	}
	for (n = 0; n < 16; n++)
	{
		fprintf(fp, "%02x: %d,%d,%d\n", n,
				gl_palette[n*3], gl_palette[n*3+1], 
			        gl_palette[n*3+2]);
	}
	fclose(fp);
}

VOID load_palette(char *filename)
{
	FILE *fp;
	BYTE namebuf[160];
	BYTE linebuf[160];
	int idx, r, g, b;

	if (filename) 
	{
		fp = fopen(filename, "r");
		if (!fp) return;
	}
	else
	{
		fp = get_file(FALSE, namebuf, "*.PAL", "r");
		if (!fp) return;
	}
	while (fgets(linebuf, sizeof linebuf, fp))
	{
		if (sscanf(linebuf, "%02x: %d,%d,%d", &idx, &r, &g, &b) == 4
	        && idx >= 0 && idx < 16)
		{
			gl_palette[idx*3  ] = r;
			gl_palette[idx*3+1] = g;
			gl_palette[idx*3+2] = b;
			vs_color(vdi_handle, idx, &gl_palette[idx*3]);
		}
	}
	fclose(fp);
	query_palette();
	if (palette_whndl) send_redraw(palette_whndl, ROOT);
}


BOOLEAN hndl_button()
{
	WORD obj, oldind, obx, oby, obw, obh;
	WORD col;
	WORD pxy[4];
	GRECT rc;

	gl_obtree[ROOT].ob_x = work_area.g_x;
	gl_obtree[ROOT].ob_y = work_area.g_y;

	obj = objc_find(gl_obtree, ROOT, MAX_DEPTH, mousex, mousey);
	if (obj == PALSAVE)
	{
		save_palette(NULL);
	}
	if (obj == PALLOAD)
	{
		load_palette(NULL);
	}
	if (obj >= COL0 && obj < COL0 + 16)
	{
		oldind = gl_index;
		gl_obtree[COL0 + oldind].ob_state &= ~CHECKED;
		gl_obtree[obj]            .ob_state |= CHECKED;
		gl_index = obj - COL0;

		query_palette();
		send_redraw(palette_whndl, COL0 + oldind);
		send_redraw(palette_whndl, COL0 + gl_index);
		send_redraw(palette_whndl, RSLIDER); 
		send_redraw(palette_whndl, GSLIDER); 
		send_redraw(palette_whndl, BSLIDER); 
	}
	if (obj >= RSLIDER && obj <= BSLIDER) 
	{
		/* Check if we're dragging or clicking */
                UWORD bbutton, breturn;
		WORD newv;

		switch(obj)
		{
			case RSLIDER: col = RED;   break;
			case GSLIDER: col = GREEN; break;
			case BSLIDER: col = BLUE;  break;
		}

		objc_offset(gl_obtree, obj, &obx, &oby);
		obw = gl_obtree[obj].ob_width;
		obh = gl_obtree[obj].ob_height;

                /* See which happens first - mouse up or mouse move */

		FOREVER	
		{
                	ev_which = evnt_multi(MU_BUTTON | MU_M1,
                                        0x01, 0x01, 0x00, /* 1 click, 1 button,  button up */
                                        1, mousex, mousey, 1, 1,
                                        0, 0, 0, 0, 0,
                                        ad_rmsg, 125, 0,
                                        &mousex, &mousey, &bbutton, &kstate,
                                        &kreturn, &breturn);

			if      (mousex < obx) newv = 0;
			else if (mousex >= obx + obw) newv = 1000;
			else newv = x_mul_div(mousex - obx, 1000, obw);

			gl_rgbask[obj - RSLIDER] = newv;
			gl_palette[3 * gl_index + (obj - RSLIDER)] = newv;
			vs_color(vdi_handle, gl_index, gl_rgbask);
                /* Button up. Finalise selection. */
			if (ev_which & MU_BUTTON)
               		{
				query_palette();
				send_redraw(palette_whndl, obj);
				break;
			}
		/* Dragging. Update bar position. */
			rc.g_x = obx;
			rc.g_y = oby;
			rc.g_w = x_mul_div(obw, newv, 1000);
			rc.g_h = obh;
			graf_mouse(M_OFF, 0x0L);
			vsf_interior(vdi_handle, 1);
			vsf_color(vdi_handle, col);
			grect_to_array(&rc, pxy);
			vr_recfl(vdi_handle, pxy);
			vsf_color(vdi_handle, WHITE);
			rc.g_x += rc.g_w;
			rc.g_w = obx + obw - rc.g_x; 
			grect_to_array(&rc, pxy);
			vr_recfl(vdi_handle, pxy);
			graf_mouse(M_ON, 0x0L);
			

		}
	}
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Message Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	hndl_mesag		*/
/*------------------------------*/
BOOLEAN	hndl_mesag()
{
	GRECT	box;
	BOOLEAN	done; 
	WORD	wdw_hndl, idx;

	done = FALSE;
	wdw_hndl = gl_rmsg[3];			/* wdw handle of mesag	*/
	switch( gl_rmsg[0] )			/* switch on type of msg*/
	{
	case AC_OPEN:				/* do accessory open	*/
		if ( (gl_rmsg[4] == gl_itempalette) && 
		    (!palette_whndl) )		/* unless already open	*/
		{
			graf_mouse(HOUR_GLASS, 0x0L);
			for (idx = 0; idx < 16; idx++)
				vs_color(vdi_handle, idx, &gl_palette[idx*3]);

			/* 0x0B = NAME | CLOSER | MOVER	*/
			palette_whndl = wind_create(WDW_STYLE, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
			if (palette_whndl == -1)
			{ 
				graf_mouse(ARROW, 0x0L);
				form_alert(1,
				ADDR("[3][Fatal Error !|Window not available|for palette.][ Abort ]"));
				palette_whndl = 0;
				return(TRUE); 
			}
			gl_obtree[COL0 + gl_index].ob_state |= CHECKED;
			query_palette();

			wind_set(palette_whndl, WF_NAME, FP_OFF(wdw_title), FP_SEG(wdw_title), 0, 0);
			wdw_size(&box);
			/* open from menu area	*/
			do_open(palette_whndl, gl_wbox*4, gl_hbox/2, box.g_x, box.g_y, box.g_w, box.g_h);
			wind_get(palette_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
			draw_wnd(&work_area);
			graf_mouse(ARROW,0x0L);
		}
		else   
		{
			graf_mouse(ARROW, 0x0L);
			wind_set(palette_whndl, WF_TOP, 0, 0, 0, 0); 
		}
		break;

	case AC_CLOSE:				/* do accessory close	*/
		if ( (gl_rmsg[3] == gl_itempalette) &&
		    (palette_whndl) )
		{
			palette_whndl = 0;	/* reset window handle	*/
		}
		break;

	case WM_REDRAW:				/* do redraw wdw contnts*/
		do_redraw(wdw_hndl, (GRECT *) &gl_rmsg[4]);
		break;

	case WM_TOPPED:				/* do window topped	*/
		wind_set(wdw_hndl, WF_TOP, 0, 0, 0, 0);
		break;

	case WM_CLOSED:				/* do window closed	*/
		do_close(palette_whndl, gl_wbox*4, gl_hbox/2);
		wind_delete(palette_whndl);
		palette_whndl = 0;
		done = TRUE;
		break;

	case WM_MOVED:				/* do window move	*/
		wind_set(wdw_hndl, WF_CXYWH, align_x(gl_rmsg[4])-1, gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
		wind_get(palette_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		break;

	default:
		break;
	} /* switch */
	return(done);
} /* hndl_mesag */



/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Hello Event Handler			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	palette			*/
/*------------------------------*/
palette()
{
	BOOLEAN	done;

	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		ev_which = evnt_multi(MU_BUTTON | MU_MESAG,
					0x01, 0x01, 0x01,
				0,0,0,0,0, 0,0,0,0,0,
				ad_rmsg, 0, 0, &mousex, &mousey, 
				&bstate, &kstate, &kreturn, &bclicks);

		wind_update(BEG_UPDATE);	/* begin window update	*/
		if (ev_which & MU_MESAG)  done |= hndl_mesag();
		if (ev_which & MU_BUTTON) done |= hndl_button();
		wind_update(END_UPDATE);	/* end window update	*/
		done = FALSE;	/* never exit loop for desk accessory	*/
	}
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Termination				     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	palette_term		*/
/*------------------------------*/  
palette_term() 
{
	return(FALSE);			/* Desk Accessory never ends	*/
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Initialization			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	palette_init		*/
/*------------------------------*/
WORD
palette_init()
{
	WORD	i, n;
	WORD	work_in[11];
	WORD	okay = 1;

	gl_apid = appl_init(NULL);			/* initialize libraries	*/
	wind_update(BEG_UPDATE);
	for (i=0; i<10; i++)
	{
		work_in[i]=1;
	}
	work_in[10]=2;
	gem_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	vdi_handle = gem_handle;
	v_opnvwk(work_in,&vdi_handle,work_out);	/* open virtual work stn*/

	if (!rsrc_load(ADDR("PALETTE.RSC")))
	{
		form_alert(1, "[3][Fatal Error|PALETTE.RSC not found][ Abort ]");
		okay = 0;	
	}	
	rsrc_gaddr(R_TREE, PALFORM, (LPVOID *)&gl_obtree);

        for (n = 0; n < 16; n++)
        {
                gl_obtree[COL0  + n].ob_spec = (LPVOID)(n | (7 << 4) | (1 << 12) | 0x20FF0000L);
                gl_obtree[COL0  + n].ob_state &= ~CHECKED;
		gl_obtree[COL0  + n].ob_x = gl_obtree[COL0].ob_x + n * gl_obtree[COL0].ob_width;
		gl_obtree[COL0  + n].ob_y = gl_obtree[COL0].ob_y;

		vq_color(vdi_handle, n, 0, &gl_palette[3 * n]);
	}
	load_palette("DEFAULT.PAL");

	if (okay)
	{
		gl_itempalette = menu_register(gl_apid, ADDR("  Palette") );
						/* init. message address*/
//		ppd_hookon(NULL, NULL, myvdi);
	}
	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]);
	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);
	return(TRUE);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Main Program			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
WORD GEMAIN(WORD argc, BYTE *ARGV[])
{
	if (palette_init())			/* initialization	*/
	{
		wind_update(END_UPDATE);
		palette();
	}
	return 0;
}

