/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef __UNDO_H_
#define __UNDO_H_

#ifndef __COMMON_H_
   #include "common.h"
#endif

#ifndef __FDISK_H_
   #include "fdisk.h"
#endif


/*========================= UNDO   M   c ============================*/
typedef struct date_time
{
   word  year:12,
         month:4,
         day:5,
         hour:5,
         min:6;
} DATE_TIME;

typedef struct undo_header
{
   sbyte      mark[17];
   dword      magicNum;
   word       mainVer;
   byte       subVer;
   DATE_TIME  dateTime;
   byte       Hold[24],
              checkSum;
} UNDO;

typedef struct undo_addr
{
   byte   disk;
   dword  sector;
   word   nSects;
} UNDO_ADDR;

typedef sword (*UndoWork)(void *parg);


/*===============================    i ===============================*/
sword IsOpenUndo (void);
sword CreateUndoFile (sbyte *fname);
sword CloseUNDO (void);
sword SaveUNDO (DiskDT *dk, dword cyl, dword head, dword sect, dword nSects);
sword TryToRestoreUNDO (sbyte *fname);
sword RestoreUNDO (sbyte *fname);
sword CreateBackup (void);
sword PromptCreateUndoFile (UndoWork workfunc, void *parg, sword pmtFlag);
void  backup_restore (PARTN *partnArr);
void  UNDO_Recovery (PARTN *partnArr);


#define MAIN_VER       0x2000
#define SUB_VER        0x01
#define MAGIC_CODE     0xaa552345L

#endif

