/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "fdisk.h"
#include "selemenu.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

#define CYL_INPUT_BUFSIZE        11

static sdword Input_Cyl_Size (sword x, sword y, sbyte *title, sbyte *buff,
                              double partnSect, dword defVal, dword begin, dword end);

/*========================= ˬdO_sbæ޿ ========================*/
sword ChkValidLogicPartn (PARTN *ptr)
{
    #if ( DISPLAY == CHINESE )
        #define RELOAD_LOGIC_PARTN  "o {  s      A\nO _    JH"
    #else
        #define RELOAD_LOGIC_PARTN  "Found a valid logic partition,\ndo you want to try to load it?"
    #endif

    byte  buff[512];

    if ( linear_ReadWDK(GetStart(ptr), 1, buff) == 0 )
        if ( IsLikeExtPartn(buff) )
            return( YN_box(TALK_BOX, RELOAD_LOGIC_PARTN) );

    return( FALSE );
} /* end ChkValidLogicPartn */


/*================================     ==============================*/
sword CreateNewPartn (PARTN *partnArr, sword ndx)
{  
    #if ( DISPLAY == CHINESE )
        #define IS_USE_ALL_SPACE       "O _ t m     H"
        #define INPUT_START_CYL_MSG    " J  l  W"
        #define INPUT_END_CYL_MSG      " J    W"
        #define OTHER_INPUT_FORM_MSG   "z i   +SIZE     J j p (G Mbyte)"
        #define NEED_CREAT_LOGIC_MSG   "O _ ~        H"
        #define SIZE_PER_CYL_MSG       "C  W j pG "
        #define POSSIBLE_CANT_BOOT_MSG "    l  W W L 1023 A\n  @ ~ t  i  L k  "
     
        #define CREATE_PRI_PARTN_MSG   "1.       D        "
        #define CREATE_EXT_PARTN_MSG   "2.       X  R    "
     
        static sbyte SizePerBlockMsg[] = "    e q  ";
    #else                               
        #define IS_USE_ALL_SPACE       "Do you want to use all ?"
        #define INPUT_START_CYL_MSG    "Input start cylinder"
        #define INPUT_END_CYL_MSG      "Input end cylinder of the partition"
        #define OTHER_INPUT_FORM_MSG   "You can also use form of +SIZE to input size (Unit: Mbyte)"
        #define NEED_CREAT_LOGIC_MSG   "Do you want to create a logic parti-\ntion ?"
        #define SIZE_PER_CYL_MSG       "Every cylinder size: "
        #define POSSIBLE_CANT_BOOT_MSG "It's maybe not bootable some O.S,\nbecause start cylinder exceed 1023 !"
     
        #define CREATE_PRI_PARTN_MSG   "1. Create primary partition"
        #define CREATE_EXT_PARTN_MSG   "2. Create Extended partition"
        
        static sbyte SizePerBlockMsg[] = "The unused area size is ";
    #endif

    PARTN  tmp, *ptr;
    double partnSect;
    sdword sectPerCyl, val;
    sbyte  buff[CYL_INPUT_BUFSIZE + 1];
    sword  kind;
    dword  begin, end;
    extern SeleMenu g_Menu;                                /** ο檫 **/
 
    sectPerCyl = CUR_DK->lgeo.sectPerCyl;
    ptr        = partnArr + ndx;
    tmp        = *ptr;
    
    if ( ptr->no == 0 )
    {
        MenuBox(31, 5, 62, 8, NULL);                     /** øsΤ **/
        g_Menu.menuColor( PAR_MENU_COLOR, LIGHT_BAR_COLOR );
  
        g_Menu.prompt(33, 6, CREATE_PRI_PARTN_MSG, TRUE);
        g_Menu.prompt(33, 7, CREATE_EXT_PARTN_MSG, g_Info.fd.ext_head == -1);
  
        kind = g_Menu.select(1);
        if ( kind < 1 )
            return(0);                                    /** U [Esc]  **/
    }
    else
        kind = 3;
       
    if ( ptr->stCyl == ptr->endCyl ||                  /** Ŷu@ӺϬW **/
         g_Info.fd.used >= MAX_PARTN_ELEM ||       /** }CwBLkA **/
         YN_box(TALK_BOX, IS_USE_ALL_SPACE) )
    {
        begin = ptr->stCyl;
        end   = ptr->endCyl;
    }
    else
    {
        ShowMSG(NULL);
        Redraw_Fdisk_Picture(TRUE);
  
        partnSect = (double)Get_nSector(ptr);
        c_textattr(MESSAGE_COLOR);
        c_printXY(4, 5, OTHER_INPUT_FORM_MSG);
        c_textattr(DEFAULT_COLOR);
        c_gotoxy(4, 7);
        Show_Capacity(SIZE_PER_CYL_MSG, sectPerCyl, 1);  /** ܨCϬWeq **/
        c_gotoxy(4, 8);
        Show_Capacity(SizePerBlockMsg, partnSect, 1);    /** ܦ϶eq **/
  
        /*
         * JҩlϬW
         */
        val = Input_Cyl_Size(4, 9, INPUT_START_CYL_MSG, buff,
                             partnSect, ptr->stCyl, ptr->stCyl, ptr->endCyl);
  
        if ( val == -1 )                                  /** U [Esc]  **/
        {
            return(0);
        }
        else if ( buff[0] == '+' )       /* pGϥΪ̦bҩlϬWweq */
        {
            begin = ptr->stCyl;
            end   = val;
        }
        else
        {
            begin = val;
   
            if ( ((ptr->stCyl == 0) && (begin == 1)) ||  /** pGOD   **/
                 ((ptr->stCyl == g_Info.fd.ext_head) &&  /** pGO޿ **/
                  (begin - 1  == ptr->stCyl)) )
                begin--;
   
            tmp.stCyl = begin;
            partnSect = (double)Get_nSector(&tmp);
      
            c_gotoxy(4, 12);
            Show_Capacity(SizePerBlockMsg, partnSect, 1);/** ܦ϶eq **/
      
            /*
             * JϬW
             */
            val = Input_Cyl_Size(4, 13, INPUT_END_CYL_MSG, buff, partnSect,
                                 ptr->endCyl, ((begin == 0) ? 1 : begin), ptr->endCyl);
                                       
            if ( val < 0 )                                /** U [Esc]  **/
                return(0);
               
            end = val;
        } /* end if */         
    } /* end if */
 
    if ( (kind == 1) && (begin > 1023) )
        Warning_Msg_Box(POSSIBLE_CANT_BOOT_MSG, NULL); /** ܥiLk} **/
 
    Create_Partn(partnArr, ndx, begin, end, kind, 1);          /** إߤ **/
 
    /*
     * إXRΫ߰ݬO_Aإ޿
     */
    if ( kind == 2 )
    {
        if ( !Is_Extended(ptr->id) )
            ptr++;
        if ( ChkValidLogicPartn(ptr) )
            ReloadLogicPartn(partnArr);
        else if ( YN_box(TALK_BOX, NEED_CREAT_LOGIC_MSG) )
            CreateNewPartn(partnArr, g_Info.fd.pri_use);
    } /* end if */

    g_Info.fd.modified = 1;
    return(0);
} /* end CreateNewPart */


/*============================ i      ============================*/
void Create_Partn (PARTN *partnArr, sword ndx, dword begin, dword end,
                   sword kind, sword find_sw)
{
    double  partnSize;
    sword   i, no;
    PARTN   *ptr;
 
    ptr = partnArr + ndx;
 
    ptr->stCyl  = begin;
    ptr->endCyl = end;
    ptr->adjust = ptr->remake = TRUE;                  /** ]wέغX **/
 
    if ( ptr->no == -1 )
    {
        g_Info.fd.maxParNO++;
        no = g_Info.fd.maxParNO;
        g_Info.fd.logic_exist = TRUE;
    }
    else
    {
        no = ( find_sw == 1 ) ? 1 : 4;
        for ( i = 0 ; i < g_Info.fd.pri_use ; i++ ) /** X̥ϥΪνs **/
            if ( partnArr[i].no == no )
            {
                no += find_sw;
                i = -1;
            } /* end if */
  
        g_Info.fd.primary++;
    } /* end if */
 
    ptr->no = no;
 
    /*
     * إXR
     */
    if ( kind == EXTENDED_PARTN )
    {
        ptr->old_id = ptr->id = ( ptr->endCyl > 1023 ) ? 0xf : 5;
  
        ptr->side = 0;                                       /** վҩl **/
        if ( ptr->stCyl == 0 )
            ptr->stCyl = 1;                                /** վҩlϬW **/
        g_Info.fd.ext_head = ptr->stCyl;
        g_Info.fd.ext_end  = ptr->endCyl;
        g_Info.fd.maxParNO = 4;
  
        /*
         * ͲĤ@ӪŪ޿
         */
        ptr     = partnArr + g_Info.fd.used;
        *ptr    = partnArr[ndx];                     /** ݩʥXRΨo **/
        ptr->no = -1;
        ptr->id = ptr->old_id = 0;
        ptr->adjust = ptr->remake = FALSE;
        g_Info.fd.used++;
  
        ptr = partnArr + ndx;
    }
    else
    {      
        if ( kind == LOGIC_PARTN )
        {
            /** إ޿ **/
            ptr->side = 1;
            if ( (g_Info.fd.ext_head == ptr->stCyl) && (no != 5) )
            {
                if ( ptr->stCyl == ptr->endCyl )
                    ptr->endCyl++;
                ptr->stCyl++;                      /** OdXRβĤ@ϬW **/
            } /* end if */
        }
        else
        {
            /** إߥD **/
            ptr->side = ( ptr->stCyl == 0 ) ? 1 : 0;
        } /* end if */
  
        partnSize = (double)Get_nSector(ptr) / 2048.0;
        ptr->id   = ( partnSize < 16.0   ) ? 0x01 :
                    ( partnSize < 32.0   ) ? 0x04 :
                    ( partnSize > 2000.0 ) ? 0x0b :
                    ( g_Info.fd.use_fat32 && (partnSize > 511.0) ) ? 0x0b : 6;
  
        /*
         * Dνd򦳳bWL 1023 Cyl HWϰ
         */
        if ( /*(kind == PRIMARY_PARTN) &&*/ (ptr->stCyl > 1023) ||  (ptr->endCyl > 1023) )
            ptr->id = ( ptr->id == 0x0b ) ? 0x0c : 0x0e;
  
        ptr->old_id = ptr->id;
    } /* end if */
 
    Remove_unused_partn(partnArr);
    Find_space(partnArr);                               /** Mtm϶ **/
} /* end Create_Partn */


/*------------------------------- JϬWήeq ----------------------------*/
static sdword Input_Cyl_Size (sword x, sword y, sbyte *title, sbyte *buff,
                              double partnSect, dword defVal, dword begin, dword end)
{
    #if ( DISPLAY == CHINESE )
        #define DIRECTLY_PRESS_ENTER_FMT   "   [ENTER]    %lu  I"
    #else
        #define DIRECTLY_PRESS_ENTER_FMT   "Direct press [ENTER] fill  %lu  !"
    #endif

    double  nSect;
    sdword  val;
 
    ShowMSG(DIRECTLY_PRESS_ENTER_FMT, defVal);
 
    do
    {
        c_printXY(x, y, title);                    /** ܿJϬWT **/
        c_printf("(%lu - %lu): ", begin, end);
  
        /* Input */
        do
        { 
            if ( GetStr(buff, CYL_INPUT_BUFSIZE, /*DISABLE_DIRKEY |*/ LIMIT_NUM_SYMB | ALLOW_ESC) == ESC_KEY )
                return(-1);
            if ( *buff == '-' )                             /* ڦ '-' Ÿ */
                Beep();
        } while ( *buff == '-' );
        
        if ( strlen(buff) == 0 )                  /** If direct press ENTER **/
        {
            val = defVal;
            c_printf("%ld", val);
            break;
        } /* end if */
  
        val = -1;
        if ( *buff == '+' )                           /** pGJO size **/
        {
            nSect = (double)strtoul(buff + 1, NULL, 10) * 2048.0;
            if ( nSect > partnSect )                         /** jpϬW **/
                nSect = partnSect;
  
            val = (nSect / CUR_DK->lgeo.sectPerCyl) + begin;
            if ( val > end )
                val = end;
            else if ( val < begin )
                val = -1;
        }
        else
        {
            val = strtoul(buff, NULL, 10);
            if ( (val < (sdword)begin) || (val > (sdword)end) )
                val = -1;
        } /* end if */
  
        if ( val < 0 )
            Beep();
          
    } while ( val < 0 );
    
    return( val );
} /* end Input_Cyl_Size */
