/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include "fdisk.h"
#include "common.h"
#include "global.h"

/*============================= R    =================================*/
void Del_Partn (PARTN *partnArr, sword ndx)
{      
   sword  no, i;
   PARTN  *ptr;

   ptr = partnArr + ndx;
   no = ( ptr->no < 5 ) ? 0 : -1;
   
   /*==========================================================*/
   /*               e      l  W           */
   /*==========================================================*/
   if ( (ptr->stCyl == 1) && (ndx < g_Info.fd.pri_use) ||
        (ptr->stCyl == (g_Info.fd.ext_head + 1)) && (ndx >= g_Info.fd.pri_use) )
   {
      ptr->stCyl--;
   } /* end if */

   if ( ptr->id != 0 )
   {
      if ( no == 0 )
      {
         g_Info.fd.primary--;
         if ( Is_Extended(ptr->old_id) )               /** pGRXR **/
         {
            g_Info.fd.maxParNO = 4;
            g_Info.fd.used     = g_Info.fd.pri_use;
            g_Info.fd.ext_head = g_Info.fd.ext_end = -1;
         }
      }
      else
      {
          /*---------------- ᭱s ---------------*/
         for ( i = g_Info.fd.pri_use ; i < g_Info.fd.used ; i++ )
            if ( partnArr[i].no > ptr->no )
               partnArr[i].no--;
         g_Info.fd.maxParNO--;
      }
   } /* end if */

   if ( g_Info.fd.maxParNO < 5 )
      g_Info.fd.logic_exist = FALSE;                 /** L޿Φsb **/

   Init_Partn_Elem(ptr);                            /** QRΤem **/

   /*---------------------------------------------------------+
   |  if partition error and exist second extended partition  |
   +---------------------------------------------------------*/
   if ( g_Info.fd.ext_head == -1 && (i = Find_EXT(partnArr)) > -1 )
   {
      g_Info.fd.ext_head = partnArr[i].stCyl;
      g_Info.fd.ext_end  = partnArr[i].endCyl;
   }

   if ( g_Info.fd.modified <= 0 )
      g_Info.fd.modified = -1;

   Remove_unused_partn(partnArr);

   Find_Problem(partnArr);
   Find_space(partnArr);                               /** Mtm϶ **/
} /* end Del_Partn */


/*=================== Ѥΰ}CXtmΰϰ ======================*/
void Remove_unused_partn (PARTN *partnArr)
{
   PARTN  *ptr, *now;
   sword  i;

   ptr = now = partnArr;
   for ( i = 0 ; i < g_Info.fd.pri_use ; i++, ptr++ )
      if ( ptr->id )
         *now++ = *ptr;
   g_Info.fd.pri_use = now - partnArr;

   for ( ; i < g_Info.fd.used ; i++, ptr++ )
      if ( ptr->id )
         *now++ = *ptr;
   g_Info.fd.used = now - partnArr;
} /* end Remove_unused_partn */


/*=============================  m   =================================*/
void Reset_Partn (PARTN *partnArr)
{
   sword  i;

   Init_Fdisk();
   for ( i = 0 ; i < MAX_PARTN_ELEM ; i++ )
      Init_Partn_Elem(partnArr + i);
   Find_space(partnArr);                   /** إߤ@Ө\㳡wЪŤ **/
} /* end Reset_Partn */
