;-----------------------------------------------------------------------------;
;   Copyright (C) 2003  Hsu-Ping Feng                                         ;
;                                                                             ;
;   This program is free software; you can redistribute it and/or modify      ;
;   it under the terms of the GNU General Public License as published by      ;
;   the Free Software Foundation; either version 2 of the License, or         ;
;   (at your option) any later version.                                       ;
;                                                                             ;
;   This program is distributed in the hope that it will be useful,           ;
;   but WITHOUT ANY WARRANTY; without even the implied warranty of            ;
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             ;
;   GNU General Public License for more details.                              ;
;                                                                             ;
;   You should have received a copy of the GNU General Public License         ;
;   along with this program; if not, write to the Free Software               ;
;                                                                             ;
;   Foundation, Inc., 59 Temple Place, Suite 330,                             ;
;   Boston, MA  02111-1307 USA                                                ;
;                                                                             ;
;                                                                             ;
;   Author e-mail: spferng@ksts.seed.net.tw                                   ;
;-----------------------------------------------------------------------------;
;                                                                             ;
;                      SPF Boot Manager     J                        ;
;                                                                             ;
;-----------------------------------------------------------------------------;

INCLUDE KERNEL.h

;         .MODEL small, c
;         .MODEL medium, c
          .MODEL COMPILE_MODE, c
          .386
          public LOADER, LDR_END
          extrn  g_Magic_Str:near ptr byte, bm_BootTime: word

          .CODE  BOOTMGR_TEXT

LOADER    PROC near
          jmp  near ptr LDR_BEGIN                                  ;  3 Bytes
          ;
Mark      db     'SPF_Boot'
          ;
Magic_Num dw        0AA55h                                             ; ѧOr
K_Ver     dw        VER_NO                                           ; s
          ;     
nCodeSect db            0                                ; ֤ߵ{qκϰϼ
nDataSect db            0                                ; ֤߸Ƭqκϰϼ
          ;
K_Disk    db            0                                            ; ҦbϺ
K_Cyl     dw            0                                                ; ϬW
K_Head    db            0                                                ; Y
K_Sect    db            0                                                ; ϰ
K_Begin   dd            0                                  ; ƬqҦbϰ
          ;
MaxSect   db            0
MaxHead   db            0
DrvPK     DRV_PK       { 16, 0, 0, 0, 0, 0, 0, 0 } ; INT 13h extension ϥεc

LDR_BEGIN:
          mov  ax, 07C0h
          mov  ds, ax
          cli
          mov  ss, ax
          mov  sp, 0
          sti

          mov  dl, ds:[K_Disk - LOADER]                              ; ֤ߺϺ
          push dx
          push dx
          xor  ax, ax
          int  13h

          pop  dx
          mov  ah, 8
          int  13h
          mov  ds:[MaxHead - LOADER], dh

          pop  dx
          jc   KERL_ERR                                        ; ƬqJ

          and  cl, 3Fh
          mov  ds:[MaxSect - LOADER], cl

          mov  ax, DATA_SEG
          mov  es, ax                                ; CHK_DATA possible use ES
          lea  bx, g_Magic_Str

          .IF ( word ptr ds:[K_Cyl - LOADER] > 1023 )  ; ϥ INT 13h extension
              ;----------------------
              ;  Load Data Segment
              ;----------------------
              mov  si, DrvPK - LOADER
              mov  word ptr ds:[si + DRV_PK.Buff_SEG], ax            ; Data_SEG
              mov  word ptr ds:[si + DRV_PK.Buff_OFF], bx            ; Data_OFF
              mov  eax, dword ptr ds:[K_Begin - LOADER]
              mov  dword ptr ds:[si + DRV_PK.StartLow], eax          ; StartLow
              xor  eax, eax
              mov  al, ds:[nDataSect - LOADER]                 ; Ƭqϰϼ
              mov  byte ptr ds:[si + DRV_PK.Transfer], al
              push eax                             ; backup number of data size
              mov  ah, 42h
              int  13h
              jc   KERL_ERR                                             ; Error
              ;
              call CHK_DATA
              ; 
              ;----------------------
              ;  Load Code Segment
              ;----------------------
              pop  eax                                          ; get data size
              add  dword ptr ds:[si + DRV_PK.StartLow], eax  ; DX{qҩlϰ
              mov  al, byte ptr ds:[nCodeSect - LOADER]        ; {qϰϼ
              mov  byte ptr ds:[si + DRV_PK.Transfer], al  
              mov  word ptr ds:[si + DRV_PK.Buff_OFF], 0         ; Code Offset
              mov  word ptr ds:[si + DRV_PK.Buff_SEG], CODE_SEG  ; Code Segment
              mov  ah, 42h
              int  13h
              jc   KERL_ERR                                             ; Error

          .ELSE                                        ; ϥζǲΪ INT 13h CHS
              ;----------------------
              ;  Load Data Segment
              ;----------------------
              mov  cx, word ptr ds:[K_Cyl - LOADER]                  ; Cylinder
              xchg ch, cl
              shl  cl, 6
              or   cl, byte ptr ds:[K_Sect - LOADER]                   ; Sector
              mov  dh, byte ptr ds:[K_Head - LOADER]                     ; Head

              xor  ah, ah
              mov  al, byte ptr ds:[nDataSect - LOADER]
              mov  si, ax
              xor  di, di
              .WHILE ( si > 0 )
                  mov  ax, 0201h
                  int  13h
                  jc   KERL_ERR                                         ; Error
                  ;
                  mov  ax, cx
                  xchg ah, al
                  shr  ah, 6                                          ; Get Cyl
                  and  cx, 3Fh
                  .IF ( cl >= ds:[MaxSect - LOADER] )
                      .IF ( dh >= ds:[MaxHead - LOADER] )
                         xor  dh, dh
                         inc  ax
                      .ELSE
                         inc  dh
                      .ENDIF
                      and  cl, 0C0h                            ; set sector = 0
                  .ENDIF
                  inc  cl    
                  shl  ah, 6
                  xchg ah, al
                  or   cx, ax                            ; combine Cyl & Sector
                  ;
                  add  bx, 200h
                  dec  si
                  .IF ( si == 0 && di == 0 )
                      call CHK_DATA
                      mov  di, 1
                      ;
                      ;----------------------
                      ;  Load Code Segment
                      ;----------------------
                      mov  ax, CODE_SEG                          ; ֤߸JϬq
                      mov  es, ax
                      ;
                      xor  bx, bx
                      xor  ah, ah
                      mov  al, byte ptr ds:[nCodeSect - LOADER]
                      mov  si, ax
                  .ENDIF
              .ENDW
          .ENDIF

LOAD_OK:
          mov  ax, DATA_SEG
          mov  ds, ax
          mov  es, ax
          mov  bm_BootTime, 1
          cli
          mov  ss, ax
          mov  sp, 0
          sti
          ;
          db   0EAh
          dw   0000h, CODE_SEG                     ; Far Jump to CODE_SEG:0000h

KERL_ERR:
          ;---------------------------------------
          ;        ~ T   B  
          ;---------------------------------------
          mov  si, MSG4 - LOADER                               ; ֤߸JѡI
          mov  ah, 0Eh
          xor  bx, bx
          .REPEAT
              lodsb
              int  10h
          .UNTIL ( al == 0 )

DEAD_LOOP:
          jmp  short DEAD_LOOP                                          ; Halt

CHK_DATA:
          lea  bx, g_Magic_Str
          cmp  dword ptr es:[bx], 'DFPS'               ;ˬd֤߶}YO_ SPFd
          jnz  short KERL_ERR
          cmp  dword ptr es:[bx+4], '.ksi'             ;ˬd֤߶}YO_ isk.
          jnz  short KERL_ERR
          ret


MSG4      db   'SPFDisk Boot Manager kernel load failure........'
          db    07h, 0Ah, 0Dh, 0
          db   'Made in SPFDisk'
LOADER    ENDP

LDR_END:                                              ; Use in get program size
          END

