@ECHO OFF
ECHO Tree v3.6 for FreeDOS compile using all tested compilers.
ECHO Expects to be in the directory with tree.c
ECHO Any compilers you lack should be commented (REM) out.
ECHO .
ECHO To compile tree, setup your compiler environment properly, then
ECHO compile specifying tree.c as the source file.
ECHO .
ECHO Type ctrl-C if you do not wish to continue or you have not edited this file.
pause

ECHO Saving PATH environement variable to be restored later.
ECHO @ECHO OFF > svpath.bat
ECHO SET PATH=%PATH% >> svpath.bat

ECHO .

ECHO Borland:

ECHO Turbo C 2.01
set PATH=C:\TC201;
REM tcc -mt -lt tree.c
tcc -mt -lt -w-par -DUSE_CATGETS tree.c catgets.c db.c get_line.c
ren tree.com treetc2.com
del tree.obj
del catgets.obj
del db.obj
del get_line.obj
pause

ECHO Turbo C/C++ 1.01
set PATH=C:\TC101\BIN;
REM tcc -mt -lt tree.c
tcc -mt -lt -w-par -DUSE_CATGETS tree.c catgets.c db.c get_line.c
ren tree.com treetcc1.com
del tree.obj
del catgets.obj
del db.obj
del get_line.obj
pause

ECHO Turbo C/C++ 3.0
set PATH=C:\TC30\BIN;
REM tcc -mt -tDc tree.c
tcc -mt -tDc -w-par -DUSE_CATGETS tree.c catgets.c db.c get_line.c
ren tree.com treetcc3.com
del tree.obj
del catgets.obj
del db.obj
del get_line.obj

REM ECHO Borland C/C++ 3.1
REM set PATH=C:\BC\BIN;
REM bcc -mt -tDc tree.c
REM bcc -mt -tDc -w-par -DUSE_CATGETS tree.c catgets.c db.c get_line.c
REM ren tree.com treebcc3.com
REM del tree.obj
REM del catgets.obj
REM del db.obj
REM del get_line.obj

ECHO .
pause

ECHO Borland C/C++ 5.5
set PATH=d:\Borland\bcc55\bin;
REM bcc32 -Id:\Borland\bcc55\Include -Ld:\Borland\bcc55\Lib;d:\Borland\bcc55\Lib\PSDK -tWC -etree.exe tree.c user32.lib
bcc32 -Id:\Borland\bcc55\Include -Ld:\Borland\bcc55\Lib;d:\Borland\bcc55\Lib\PSDK -tWC -w-par -w-aus -etree.exe -DUSE_CATGETS tree.c catgets.c db.c get_line.c user32.lib
ren tree.exe treebcc55.exe
del tree.obj
del tree.tds
del catgets.obj
del db.obj
del get_line.obj

ECHO .
pause


ECHO Microsoft:

ECHO Visual C/C++ 5.0
REM Ensure VCVARS32.BAT has been ran to setup paths and environment
CALL c:\Progra~1\Devstu~1\vc\bin\VCVARS32.BAT
REM cl /Fe"tree.exe" /nologo /ML /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" tree.c /link user32.lib
cl /Fe"tree.exe" /nologo /ML /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "USE_CATGETS" tree.c catgets.c db.c get_line.c /link user32.lib
ren tree.exe treevc5.exe
del tree.obj
del catgets.obj
del db.obj
del get_line.obj

ECHO .
pause


ECHO Dave Dunfield:
ECHO Assumes MCSETUP has already been run to generate CC
ECHO and TASM 1,2,3 [4,5*] and TLINK specified.
ECHO *Tasm 5 includes Tasm 4, which is actually used.


REM cats does NOT compile with Micro-C/PC.
REM cc tree.c -M -P MICROC=321 USE_CATGETS=1
REM cc catgets.c -M -P
REM cc db.c -M -P
REM cc get_line.c -M -P
REM LC tree catgets db get_line

ECHO Micro-C/PC 3.14
set MCDIR=C:\MC314
set PATH=C:\MC314;C:\TASM\BIN
REM set TEMP=C:\TEMP
cc tree.c -P MICROC=314
ren tree.com treem314.com

ECHO Micro-C/PC 3.15
set MCDIR=C:\MC315
set PATH=C:\MC315;C:\TASM\BIN
REM set TEMP=C:\TEMP
cc tree.c -P MICROC=315
ren tree.com treem315.com

ECHO Micro-C/PC 3.21
set MCDIR=C:\MC321
set PATH=C:\MC321;C:\TASM\BIN
REM set TEMP=C:\TEMP
cc tree.c -P MICROC=321
ren tree.com treem321.com

ECHO .
pause

ECHO DJGPP:
ECHO TODO

ECHO Compilers with POSIX support:
ECHO TODO

ECHO Compilers with generic Win32 (C api) support:
ECHO TODO

ECHO .

ECHO Now cleaning Up
CALL svpath.bat
del svpath.bat
ECHO Done.
