/*
 * TREE command for MS-DOS
 *
 * This command is virtually identical to the MS-DOS TREE command,
 * except that it expands the current directory path instead of
 * showing '.' in the display.
 *
 * Copyright 1995 Dave Dunfield
 * Copyright 2000 Kenneth J. Davis and Dosius Software Co.
 * Modified by Joe Cosentino on 7/27/00.
 * Freely distributable.
 */

#include <direct.h>
#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <errno.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define get_drive() (getdisk())
#define getdir(x) getcurdir(0, (x))

#define DIRS  500                   /* Depth of directory stacking */
#define DEPTH 50                    /* Depth of scanner recursion */

// G L O B A L S ////////////////////////////////////////////////////////////

char
    *parg = 0,                      /* Path argument */
    path[66],                       /* Final path specification */
    full = 0,                       /* Full listing specified */
    dirstack[DIRS][13],             /* Stack of directory names */
    *actstack[DEPTH],               /* Stack of active levels */
    *Vline = "\xB3\x20\x20",        /* Vertical line */
    *Vtee  = "\xC3\xC4\xC4",        /* Vertical/Horizonal tee */
    *Corn  = "\xC0\xC4\xC4",        /* Vertical/Horizontal corner */
    *Hline = "\xC4\xC4\xC4";        /* Horisontal line */

unsigned
    dirptr = 0,                     /* Directory stacking level */
    level = 0;                      /* Function recursion level */

static char help_text[] = {"Help me!"};

// P R O T O T Y P E S //////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[]);
void tree_path(void);

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

/*
 * Handle a single directory, recurse to do others
 */
void tree_path(void)
{
    unsigned plen, dirbase, i, j, k;
    struct ffblk ffb;
    char *ptr, *name=ffb.ff_name;

    /* Get all sibdirectory names in this dir */
    dirbase = dirptr;
    plen = strlen(path);
    strcpy(path+plen, "*.*");
    if (!findfirst(path, &ffb, -1))
        do
            {
            if ((ffb.ff_attrib & FA_DIREC) && (*name != '.'))
                {
                strcpy(dirstack[dirptr++], name);
                continue;
                } // end if.

            } // end do.
        while (!findnext(&ffb));

    /* Display files in this dir if required */
    actstack[level++] = (dirbase == dirptr) ? "   " : Vline;
    if (full)
        {
        i = 0;
        if (!findfirst(path, &ffb, -1))
            do
                {
                if (ffb.ff_attrib & (FA_DIREC | FA_LABEL))
                    continue;

                for (j=0;j<level;++j)
                    fputs(actstack[j], stdout);

                i = -1;
                printf("%s\n", name);
                } // end do.
            while (!findnext(&ffb));

        if (i)
            {
            for (j=0; j < level; ++j)
                fputs(actstack[j], stdout);

            putc('\n', stdout);
            } // end if.

        } // end if.

    /* Report of no subdirectories exist */
    if ((dirbase == dirptr) && (level == 1))
        printf("No sub-directories exist\n");

    /* Recurse into subdirectories */
    for (i=dirbase;i<dirptr;++i)
        {
        actstack[level-1] = ((i+1) != dirptr) ? Vtee : Corn;
        for (j=0;j<level;++j)
            fputs(actstack[j], stdout);

        actstack[level-1] = ((i+1) != dirptr) ? Vline : "   ";
        printf("%s\n", ptr = dirstack[i]);
        strcpy(path+plen, ptr);
        strcat(path, "\\");
        tree_path();
        } // end for.

    /* Restore entry conditions and exit */
    path[plen] = 0;
    dirptr = dirbase;
    --level;

} // end tree_path.

/////////////////////////////////////////////////////////////////////////////

/*
 * Main program - parse arguments & start recursive procedure
 */
int main(int argc, char *argv[])
{
    struct SREGS s;
    union REGS r;
    int drive, curdrive, index, help_flag=0, n_options, n_files;
    char *output, *fileargs[64], *optargs[64], xdrive[_MAX_DRIVE], dir[_MAX_DIR], file[_MAX_FNAME], ext[_MAX_EXT];
    struct ffblk ffb;

    n_options = classify_args(argc, argv, fileargs, optargs);
    n_files = argc - n_options; n_files=n_files;
    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else if (optargs[index][0] == 'A' || optargs[index][0] == 'a')
            {
            Vline = "|  ";
            Vtee = "+--";
            Corn = "\\--";
            Hline = "---";
            continue;
            } // end else.
        else if (optargs[index][0] == 'F' || optargs[index][0] == 'f') full = -1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            exit(1);
            } // end else.

        } // end for.

    parg = fileargs[1];
    if (help_flag)
        {
        printf("Graphically displays the directory structure of a drive or path.\n\n"
               "Syntax: TREE [drive:][path] [/A] [/F] [/?]\n"
               "  /A  Uses ASCII instead of extended characters\n"
               "  /F  Displays the names of the files in each directory\n"
               "  /?  Displays this help message\n");
        exit(1);
        } // end if.

    /* If no path specified, default to current */
    if (!parg)
        {
        *(parg = help_text) = '\\';
        getdir(help_text+1);
        } // end if.

    /* If no drive name specified, obtain current drive */
    if (parg[1] == ':')
        strcpy(path, parg);
    else
        {
        *path = get_drive() + 'A';
        path[1] = ':';
        strcpy(path+2, parg);
        } // end else.

    if (argc >= 2)
        {
        _splitpath(argv[1],xdrive,dir,file,ext);
        strcpy(output, "vol ");
        strcat(output, xdrive);
        system(output);
        } // end if.
    else
        {
        chdir(path);
        system("vol");
        } // end if.

    /* Display volume label of disk */
    parg[0] = drive;

    /* Display path and append backslash if not given */
    printf("\n%s\n", path);
    switch (path[strlen(path)-1])
        {
        default:
            strcat(path, "\\");
        case ':':;
        case '\\':;
        } // end switch.

    /* Perform recursive function */
    tree_path();
    return 0;

} // end main.
