/*
    ULTEST.C
    
    module to test ULARITH.ASM package
*/

#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#define ULONG  unsigned long
#define USHORT unsigned short

/* 
    UNSIGNED LONG (div,mod) UNSIGNED SHORT arithmetics
    
    returns ulong % ushort 
*/

USHORT pascal ULU_MOD(ULONG ul, USHORT u)
{
    USHORT retval;
    asm {
        mov bx, u
        mov dx, word ptr ul+2
        
                        /* if upper word < divider,
                           no predivide necessary */
        cmp dx, bx
        jb  upper_ok

        mov ax,dx       /* divide high word first */
        xor dx,dx
        div bx
        }

upper_ok:;
    asm {    
        mov ax,word ptr ul
        div bx
        
        mov ax,dx
               
        mov retval,ax        
        }        
        
    return retval;        
}        

/* 
   *ulongp = ul / u; 
   return ulong % ushort 
*/

USHORT pascal ULU_DIVMOD(ULONG ul, USHORT u, ULONG *ulp)
{
    USHORT retval;
    asm {
        mov cx, u
        mov bx, ulp
        
        mov dx, word ptr ul+2
        xor ax,ax
        
                        /* if upper word < divider,
                           no predivide necessary */
        cmp dx, cx
        jb  upper_ok

        mov ax,dx       /* divide high word first */
        xor dx,dx
        div cx
        }

upper_ok:;
    asm {    
        mov [bx+2],ax   /* high part of ul / u */
        
        mov ax,word ptr ul
        div cx
        
        mov [bx],ax     /* low part of ul / u */

        mov ax,dx       /* return ul % u      */
               
           
        mov retval,ax        
        }        
        
    return retval;        
}        


ULONG difftick()
{
    ULONG newtick = *(ULONG far *)MK_FP(0x40,0x6c);
    static ULONG lasttick;
    ULONG difftick;
    
    difftick = newtick - lasttick;
    lasttick = newtick;
    
    return difftick;    
}

main()
{
    ULONG  ul;
    USHORT  u;
    
    USHORT umodo, umodn;
    ULONG  udivo, udivn;
    
    ULONG Tdivo = 0, Tdivn = 0, Tmodo = 0, Tmodn = 0;
    
    
    int K = 0;
    
    long i;

    for (;;)
        {
        if (kbhit()) break;
    
        for (i = 0; i < 100000; i++)
            {
                
                /* generate random number u,ul */
            ul = (ul << 1) ^(ULONG)rand();
            u  = ( u << 1) ^(ULONG)rand();
                 
            if (u == 0)     
                {
                                /* to show we also generate 0's */
//                printf("ZERO\n");
                continue;
                }
 

            difftick();
            umodo = ul % u;
            Tmodo += difftick();
            
            difftick();
            umodn = ULU_MOD(ul,u);
            Tmodn += difftick();
            
            if (umodo != umodn)
                {
                printf("UL_MOD ul = %lx u = %x, \n",ul,u);
                printf(" umodo = %x, umodn = %x\n", umodo, umodn);
                getchar();
                }
            
            difftick();
            udivo = ul / u;
            Tdivo += difftick();
            
            difftick();
            umodn = ULU_DIVMOD(ul,u,&udivn);
            Tdivn += difftick();
            
            if (umodo != umodn || udivo != udivn)
                {
                printf("UL_DIVMOD ul = %lx u = %x, \n",ul,u);
                printf(" udivo = %lx, udivn= %x\n", udivo, udivn);
                printf(" umodo = %x, umodn = %x\n", umodo, umodn);
                getchar();
                }
            
            
            }
        printf("%u00 K checked ", K++);
        printf("UL_DIVMOD ul = %lx u = %x, TDIV = %lu,%lu TMOD= %lu,%lu\n",
                ul,u, Tdivo,Tdivn,Tmodo,Tmodn);
        }    
 
  return 1;   
}