/*
    copyright by tom ehlert (tom.ehlert@ginko.de)
    driveID.C
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>

/**
***
*** !short: hexd ((char*)array)
***    dump 16 Bytes from array to stdout requieres 67 bytes on line
*** !seealso: hexdn hexsd
*** !short: hexdn ((char*)array,anzahl)
***    dump N * 16 bytes to stdout
*** !seealso: hexd hexsd
***
*** !short: hexsd ((char*)string,(char*)array,anz)
***     dump min(anz,16) bytes from array into string
*** !seealso: hexd hexdn
***
**/



char *hexsd(register char  *dest,unsigned char *src,int anz)
    {
    register int loop;
    register char c;
    static char hexchars[] = "0123456789ABCDEF";
	char *desto = dest;

    anz = min(anz,16);
    *dest++ = '|';

    for (loop = 0;  loop < anz;  loop++)
        {
        c = src[loop];
        *dest++ = hexchars[(c >> 4) & 0xF];
        *dest++ = hexchars[(c) & 0xF];
        *dest++ = ' ';
        }
    for (;loop < 16;  loop++)
        {
        *dest++ = ' ';
        *dest++ = ' ';
        *dest++ = ' ';
        }
    dest[-1] = '|';

    for (loop = anz ;  --loop >= 0;  )
        {
        c = *src++;
        *dest++ = (unsigned char)(c >= 0x20 && c < 0x7f  ? c : '.');
        }
    *dest++ = '|';
    *dest = '\0';
	return desto; 
    }

void hexdn(unsigned char *array,register int anz)
    {
	unsigned char *arrays = array;
    char linebuff[80];

    for (;anz > 0;  anz -= 16,  array += 16)
        {
		printf("%03x",array-arrays);
        hexsd(linebuff, array, anz);
        printf("%s\n",linebuff);
        }
    }

void hexd(unsigned char *array)
    {
    hexdn(array, 16);
    }


typedef unsigned char UCHAR;

UCHAR buffer[512];

#pragma warn -asc
unsigned short inportw(unsigned short IObase)
{
   unsigned retval; 
   asm {
        mov dx,IObase;
        in  ax,dx;
        mov retval,ax;
        }
    return retval;
}    

void iodelay(short IObase)
{
    unsigned short dloop;
    unsigned char in[512];
    unsigned idx = 0;
    unsigned ib;
    for ( dloop = 0; dloop < 0xffff;dloop++)
        {
        ib = inportb(IObase+7);
        if (idx == 0 || ib != in[idx-1])
            in[++idx] = ib;

        if ((ib & 0x80) == 0)
            break;            
        }    
 
    printf("loop %u\n",dloop);
    hexdn(in,idx);
    
/*    
    for ( --dloop; dloop;dloop--)
        ;
*/
}    
main()
{
    unsigned bases[] = { 0x1f0,0x170};
    unsigned IObase;
    int drive,controller;
    unsigned short valw;
    
    int i;
    
    for (controller = 0; controller <= 1; controller++)
        {
        IObase = bases[controller];
        for (drive = 0; drive <= 1; drive++)
            {
            outportb(IObase + 6, 0x01 | (drive << 4));  /* select drive 01, 11 */
            iodelay(IObase);
            outportb(IObase + 7, 0xec);                 /* request configuration */
            iodelay(IObase);
            if (inportb(IObase+7) != 0x58)
                {
                printf("no drive available for port %x, drive %u\n", IObase,drive);
                continue;
                }
            
            for (i = 0; i < 512; i += 2)
                {
                valw = inportw(IObase);
                
                buffer[i]   = (UCHAR)(valw >> 8);
                buffer[i+1] = (UCHAR)valw;     
                }
            
            printf("information for port %x, drive %u\n", IObase,drive);
    
            hexdn(buffer,512);
            
            printf("\n");
            
                
            }
        }    

    
    return 0;
}    