/* type.c */

/* Waits for the user to press a key.  Always exits successfully */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>			/* Borland: exit() */
#include <string.h>			/* for strncmp */
#include <conio.h>			/* Borland: getch() */


/* Functions */

void usage (void);


/* The program starts here */

int
main (int argc, char **argv)
{
  int i;

  /* Check command line */

  for (i = 1; i < argc; i++)
    {
      if (strncmp (argv[i], "/?", 2) == 0)
	{
	  usage ();
	  exit (0);
	} /* if /? */

      else
	{
	  printf ("%s ", argv[i]);
	} /* else */
    } /* for */

  if (argc == 1)
    {
      printf ("Press any key to continue");
    } /* argc==1 */

  /* Grab a key */

  getch();
  printf ("\n");

  exit (0);
}

/* usage - display the program usage.  do not exit from here */

void
usage (void)
{
  /* Display usage */

  fprintf (stderr, "PAUSE - Waits for the user to press a key\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "\tPAUSE\n");
}
