LOCAL PCStr	STACK_	DEV_make_name	(seg_t, off_t);
LOCAL PCStr	FAST_	DEV_find_name	(const MCBINFO*);
LOCAL void	FAST_	device_list	(void);

/*----------------------------------------------------------------------*/

LOCAL PCStr STACK_ DEV_make_name (seg_t seg, off_t off) {
	static char name_buf [sizeof FP (DEVICE, 0, 0)->dev_name + 1];
	if (is_CHAR_DEV (FP (DEVICE, seg, off)->attr)) {
		canonize_name (name_buf, FP (DEVICE, seg, off)->dev_name,
				  sizeof FP (DEVICE, seg, off)->dev_name);
	} else {
		char first = 0;
		DPB *dpb = SYS.OS.LoL->first_DPB;
		for (; FP_OFF (dpb) != 0xFFFF; dpb = dpb->_.DOS4.next) {
			if (FP (DEVICE, seg, off) == dpb->_.DOS4.dev) {
				char drv = dpb->drive + 'A';
				if (first == 0) first = drv;
				name_buf [5] = drv;
		}	}
		name_buf [0] = first;
		SetChar2 (&name_buf [1], ':', 0);
		if (name_buf [5] != first) {
			SetChar2 (&name_buf [2], ' ', '-'),
			name_buf [4] = ' ',
			SetChar2 (&name_buf [6], ':', 0);
	}	}
	return name_buf;
}

LOCAL PCStr FAST_ DEV_find_name (const MCBINFO *p) {
	register seg_t dev_seg = FP_SEG (SYS.OS.first_device);
	register off_t dev_off = FP_OFF (SYS.OS.first_device);
	do {	seg_t seg = (dev_off >> 4) + dev_seg;
		if (seg >= p->seg && seg < p->next_seg)
			return DEV_make_name (dev_seg, dev_off);
		seg = dev_seg,
		dev_seg = FP_SEG (FP (DEVICE, seg, dev_off)->next),
		dev_off = FP_OFF (FP (DEVICE, seg, dev_off)->next);
	} while (dev_off != 0xFFFF);
	return "";
}

LOCAL void FAST_ device_list (void) {
	seg_t dev_seg = FP_SEG (SYS.OS.first_device), seg;
	off_t dev_off = FP_OFF (SYS.OS.first_device);
	header (2, 1,
		"  Address    Attr  Driver    Program\n"
		"-----------  ----  --------  -----------------\n");

	do {	printf (" %Fp   %04X  %-10s",
			FP (DEVICE, dev_seg, dev_off),
			FP (DEVICE, dev_seg, dev_off)->attr.x,
			DEV_make_name (dev_seg, dev_off));

		const MCBINFO *p = MCB_find (dev_seg, dev_off);
		if (p && (p->type & ~(MT_SYSCODE | MT_SYSDATA | MT_UNKNOWN)))
			say (MCB_name (p));
		new_line ();

		seg = dev_seg,
		dev_seg = FP_SEG (FP (DEVICE, seg, dev_off)->next),
		dev_off = FP_OFF (FP (DEVICE, seg, dev_off)->next);
	} while (dev_off != 0xFFFF);
}
