{$A-,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
Unit Global;
{ **********************************************************
  Diese Unit enthlt diverse Standardschalter, die von
  den einzelnen Units ausgewertet werden (knnen).
  Dadurch kann das Hauptprogramm (oder eine Unit) einen
  Schalter fr alle Units setzen.
  Diese Unit bernimmt, evtl. zusammen mit der Unit Fehler,
  das globale Errorhandling.
  ----------------------------------------------------------
  Version 1.0.    30. September 1991.   Turbo Pascal 5.5.
          1.1     2001/26/06 Borland Pascal 7.01, RQ

  (P) 1991 Dietmar Hhmann.
  **********************************************************
}

Interface

Type
       ErrorAction = (DoNothing,CallErrorExit,CallRunError,ExitToDos);
Const
       OnError     : ErrorAction
                   = ExitToDos;        { Gibt an, was im Fehlerfall zu tun ist.}
       ErrorCode   : Byte = 0;         { FehlerCode.}
                                       { 254 = TP-Laufzeitfehler. }
                                       { 255 = DOS-Fehler. }
                                       { Ansonsten vom Modul abhngig. }
       ExtErrorCode: Word = 0;         { Erweiterter Fehlercode.}
       ErrorAddr   : Pointer = Nil;    { Bei Runtime-Fehler Fehlerposition.}
       ErrorFlag   : Boolean = False;
       Module      : Byte = 0;         { Modul, in dem der letzte Fehler aufgetreten ist od. erkannt wurde.}
                                       { 0 = Main      }
                                       { 1 = Inter2    }
                                       { 2 = ForComp   }
                                       { 3 = Stack     }
                                       { 4 = PGI       }
                                       { 5 = Driver    }
                                       { 6 = Unbekannt }
                                       { 7 = Share     }
                                       { 8 = Fehler    }
                                       { 9 = RS232     }
       TestMode    : Boolean = False;  { Programm luft im Testbetrieb.}
       DebugMode   : Boolean = False;  { Debugmodus.}
       ModuleNames : Array[0..9] of String[11] =
                     ('MAIN','INTER2','FORCOMP','STACK','PGI','DRIVER',
                      '*unknown*','SHARE','FEHLER','RS232');


Var    ErrorExit   : Procedure;

Procedure SetError(Modul,Code : Byte; ExtCode : Word);

Function Error : Boolean;



Implementation



Procedure SetError;
Begin
   Module:=Modul;
   ErrorCode:=Code;
   ExtErrorCode:=ExtCode;
   ErrorFlag:=True;
   Case OnError Of
      DoNothing     : ;
      CallErrorExit : ErrorExit;
      CallRunError  : RunError(255);
      ExitToDos     : Begin
{!!RQ!!1.61
                         Writeln('Im Modul ',ModuleNames[Module],' ist der Fehler ',
                                 ErrorCode,' / ',ExtErrorCode,' Aufgetreten.');
}                        WriteLn ('Error ', ErrorCode, '/', ExtErrorCode, ' in module ',
                                   ModuleNames [Module]);
                
                         Halt(ErrorCode);
                      End;
   End;
End;

Function Error;
Begin
   Error:=ErrorFlag;
   ErrorFlag:=False;
End;

End.