;*** KBFRINST  - (KBINST10 revision. minor bug fix)
;! Module MUST be FIRST in link order (link KBFRINST+KBFRRES) !
;
;*** Analysis and programming : 2011 Ninho
;*** initially based on Japheth's KeybGR
;
;*** (un/)installation & communication module :
;    sets vector: INT 15
;----------------------------------------------------------------------
;v2.0.rev: fixed regression when no UMBs exist and option "C" not given
;     + don't try to unload (future version!) resident from HMA
;     + semicolon as comment delimiter for command line
;v 2.0 : release.
;v 1.98: when freeing environment we used a potentially stale pointer! Fixed.
;      - do not unload resident under Windows enhanced
;v 1.97: load into upper memory by default; 'KBFR C' to force loading low.
;      - check for mem alloc failure, if so cleanup & exit gracefully
;      - do not try to enforce "critical" section (no more CLIs)
;v 1.95: new protocol uses private int 15/8FF4
;    KBFR <+ - U> : Activate/Deactivate/Unload from memory
;   Default: load (if not already in mem) & activate French kbd translation.
;v 1.5 : exclusive scheme for optimal placement into low memory

		.286
cr equ 13
lf equ 10
                include kbfr.inc
;----------------------------------------------------------------------

  _TEXT SEGMENT PUBLIC PARA 'code' ; alignment on paragraph required

firstb       label byte
;*** uninstall *** at the head, may be trashed by installation process

deinstall       proc c  ; returns : ZF = OK, NZ= could not deinstall

; Called only after we've checked KBFR is indeed resident 

; Windoze note : uninstalling a /global/ KBFR under MS Windows could freeze
; the system. Rather than being blamed by clueless users we FORBID unloading
; under Windows enhanced mode.
; Geeks who know what they do and want to be able to unload under Windows
; may disable the following conditional and recompile...

 IF True
                mov     AX, 1600h
                int     2Fh             ; MS-Windows enhanced mode running ?
                and     AL, 7Fh
                jnz     badret          ; -> if in Win "enhanced"
 ENDIF

; Now, check whether the resident KBFR still 'owns' int 15h :
		mov	  ax,3515h
		int 21h
                cmp       bx, offset introu15
                jne       badret
                mov       ax, ES        ; seg of int 15 vector
                cmp       AX, CS:[ResSeg]
                je       @F             ; -> if int 15h still ours
badret:         ret     ; NZ

; Is KBFR (a future version) resident in the HMA ?
         @@:    cmp      AH, 0EFh
                ja       badret         ; -> won't unload from the HMA

; Good! Can unhook KBFR and free its memory
                mov       DS, AX        ;  resident's seg
                mov       CX, AX        ;  dupe
                lds  dx,  ds:orgint15
                mov ax, 2515h
                int 21h                 ; restore prior int 15h

;      reset dead key related BIOS flags:
                push    40h ; BIOS data seg
                pop     ds
                 ASSUME   DS: BIOSSEG
                and     Cflags, not 3
                 ASSUME   DS: nothing

                mov     ES, CX          ; resident's seg
;       give back resident's memory
                MOV      AH,49h
		int 21h
                sub      ax, ax
                ret      ; ZF
deinstall	endp
;-------------------------------------------- 

main	proc c

local	prglen:word
 local   org_ulink:word ; saved UMB link status (-1 if unsupported)
 local   org_strat:word ; saved mem allocation strategy
local	installed:byte
local	deinst:byte
local   french:byte
 local   highmem:byte

                assume DS: Nothing

; Require an AT-class machine :
        .8086
                MOV       CS:psp, ES    ; save

		MOV	  AX,0F000h
		MOV	  ES,AX
		MOV	  AL,ES:[0FFFEh]
                CMP       AL,0FCh       ; AT BIOS ?
                JZ        @F
		mov	  dx,offset errstr1
                mov       al, 2        ;err level: not installed
; -----------------
msg_and_exit:
                push      ax    ; preserve error code
                call      msg
                pop       ax    ; restore
                mov       ah, 4ch
		int 21h
; -----------------
         .286
         @@:
                xor     ax, ax               ; reset : installed, deinst
                mov     word ptr deinst, ax
                mov     word ptr highmem,0101h ; set :  french, highmem

; check if already installed, using private API
                mov     AX, 8FF4h
                mov     BX, 1     ; KB id
                INT     15h
                cmp     AX, 0100h ; KB, API version 0
                jnz     @F
                cmp     BX, 50h   ; res segment should be >=50h
                jb      @F
                inc     installed  ;  := 1
                mov     CS:[ResSeg], BX
             @@:
;  process command line arguments
                mov       es,cs:[psp]
		MOV	  SI,0081h
        .while (1)
                MOV       AX,ES:[SI]
                inc       si
            .continue .if (al == 9)  ; TAB as blank
                CMP       AL, ' '
            .break    .if CARRY?     ; EoL, or fancy control char.
            .continue .if ZERO?      ; ignore spaces
            .break    .if (al==';')  ; semicolon introduces comments
            .if (al == '/')          ; slashes now optional
                INC       si
                MOV       al, ah
            .endif

            .if (al == '+'|| al =='1')
                mov       byte ptr french,1
             .continue   
            .elseif (al == '0'|| al == '-')
                mov       byte ptr french,0
             .continue   
            .endif

                AND       al, NOT 20h   ; to upper

            .if (al == 'U' || al== 'D')
                mov       dx,offset errstr6 ; msg: non install
                mov       al, 2    ; err level: KBFr not in mem
                cmp       installed,1
                jnz       jmxit

            call  deinstall
                mov       dx,offset errstr4 ; msg: dsinstall
                mov       al, 2  ; err level: KBFr not in mem
                jz        jmxit
                mov       dx,offset errstr5 ; msg: dsinst. impossible
               call    msg
                mov        byte ptr french, 0
                jmp  short updstate ; can't uninstal, go & disable instead

            .elseif (al == 'C')
                mov       byte ptr highmem,0

            .else
               jmp       helpstr
            .endif

        .endw
; ---------------------------------------------------------------------
                cmp       installed,0
                je        _TEXT:doinstall

updstate:
                MOV       DS, CS:[ResSeg]
                call      setstate    ; set/reset Fr translation 
          @@:    
                mov       al,[french] ;  errorlevel 0=Fr /1=native
jmxit:          jmp    msg_and_exit

helpstr:
                mov       dx,offset insstr3
                call      msg
                mov       dx,offset hlpstr3
                jmp       @B

;-------------------------------------------- installation

                even
psp             dw      0-1
ResSeg          dw      0-1

; ------
align 16

; IMPORTANT NOTE :
; Everything before this point /may/ be trashed by further copying,
; offset (from initial PSP) MUST be >= max resident's size (currently 1D9h)
; WWWW!    ...  else add enough filler paragraphs HERE...    WWWWW!

 Res_Size= 1D9h
.ERRNZ  $-Firstb lt (Res_Size-100h)

NMCB          DB     "M"        ; else "Z"
NOwner        DW      0         ; owner
NParas        DW      0         ; size
              DB      11 dup (?)

NPSP          DW      40h/2 dup (?)     ; new mini-PSP while installing
 Shft  EQU    10h+(NPSP-firstb) shr 4   ; #paras from old to new PSP
 Shftb  =     Shft shl 4                ; #bytes  d  

; ---------------------------------------------------------------------
msg:            ; side effect DS := CS !
                push      cs
		pop	  ds
		mov	  ah,09h
                int       21h
                retn
; ---------------------------------------------------------------------
setstate:    ; subroutine updates active/inactive resident status
; on entry: DS: -->   seg (resident)
; returns DX (msg ptr); trashes AL ; resident byte updated
                EXTRN  kvar:abs
                mov     BX, kvar; invariable offset (API v 0)
                mov     al, koff; magic : disable
                test    french, 1
                mov     dx,offset inactivstr
                jz      @F
                mov     al, kon ; magic : enable
                mov     dx,offset activstr
         @@:    mov     [BX], al; done!
                retn

; ---------------------------------------------------------------------
doinstall:
                mov       dx,offset insstr3
                call      msg

; KBINST3+ : optimal placement into memory
;            in ten steps and a half.

; 0.5 - Save, then Set memory options :

; KBINST10 revised case where UMBs are unavailable and no explicit "C" option
                mov       ax,5800h
		int 21h
                mov       org_strat,ax          ; Save Allocation Strategy

                mov       ax,5802h              ; UMB Link Status ?
		int 21h
           @@:  mov       org_ulink, 0-1
                JC        alloclow              ; -> if DOS UMBs unsupported

		xor	  ah,ah
                mov       org_ulink,ax          ; Save original Link status

                test    byte ptr highmem,1      ; "C" option ?
                jz         alloclow

                mov       ax,5803h              ; Set UMB Link Status
                mov       bx,0001h              ; to include UMBs
                int 21h
                jc        alloclow              ; -> no UMBs ; bugfix

                mov       ax,5801h              ;Set Allocation Strategie
                mov       bx,0081h              ; best fit, UMBs first
		int 21h
                jnc       @F                    ; rev:jnc instead of jmp
alloclow:
                mov       ax,5801h              ;Set Allocation Strategie
                sub       bx, bx                ; 1st fit, conventional
		int 21h
          @@:
; 1 - copy MCB +PSP out of the way, but still /inside/ this process's memory
;     (10h+40h bytes !) -> NMCB,NPSP
                mov     cx,(10h+40h)/2  ; size of MCB+size of mini-PSP
                CLD
                MOV     AX, CS:[psp]    ; initial PSP (this installer's)
                DEC     AX              ; AX: seg oldMCB
                MOV     DS, AX          ; Assume DS: oldMCB
                mov     BX, AX
                add     BX, Shft        ; BX: seg newMCB
                MOV     ES, BX          ; Assume ES: newMCB
                sub     si, si
                sub     di, di
           rep  movsw   ; copy 1+4 paras starting from MCB
                inc     BX              ; BX: seg newPSP
                mov     es:[10h+36h], BX; adjust seg(handles pointer)

; 2 - prepare new MCB, keeping copied M or Z signature
                mov     es:[1], BX      ; owner (self)
                sub     word ptr es:[3], Shft    ; size

; 3 - make copied PSP active :
                mov     ah, 50h
                int     21h     ; ASSUME BX:newPSP

;\\\   begin former-critical section  (#4, 5, 6)   
; (1.97) does not attempt to avoid interrupts any more,

; 4 - Adjust Original MCB to cover up to 'NewMCB' & mark it FREE.
            ;CLI\\\         ; protect critical section
                mov     word ptr ds:[3], Shft-1         ; paragraphs
                mov     byte ptr ds:[0], 'M'            ; signature
                mov     word ptr ds:[1], 0              ; mark free !

; 5 - FREE our environment block, if any :
                XOR     CX, CX
                xchg    CX, ES:[10h+2Ch]   ; zeroing not required but neat
                jcxz    @F
                DEC     CX
                mov     ES, CX
                MOV     word ptr ES:[1], 0 ; owner=None
@@:
; 6 - ask DOS for a suitable block; make it self owned
                extrn   RSiz:Abs
                mov     BX, RSiz
                mov     AH, 48h ; DOS allocate
                int     21h
                JNC    alloced  ; --> OK

; in the odd case DOS failed to alloc, clean up and exit
;STI\\\  ; no more critical
                call    Restore_Strat
                mov     DX, offset errstr7      ; inform user
                call    msg
                mov     AX, 4C02h       ; errlevel 2 (not installed)
                int 21h

; ----
Restore_Strat:  mov     ax,5801h        ; Alloc strategy
                mov     bx,org_strat
                int 21h                 ; Restore previous
                mov     bx,org_ulink    ; UMB Linking
                cmp     bx, 0-1
                je      @F              ; skip if not applicable
                mov     ax,5803h        ; Restore previous UMB Link Status
		int 21h
         @@:    RETn                    ; local label was missing ! rev2 bugfix
; ----

alloced:        mov     cx, ax
                dec      ax                    ; MCB of new block
                mov      ES, AX
                mov      es:[0001], cx         ; owner = self
;STI\\\ ; end former-critical section
                mov      word ptr es: [08],"BK"; indicator = "KBFR"
                mov      word ptr es:[0Ah],"RF"
                mov      byte ptr es:[0Ch], 0
;  Restore initial DOS memory options :
                call     Restore_Strat

; 7 - Copy resident to its final place :
                MOV     ES, CX
              ; Assume ES: new (allocated for resident) Segment
                mov     BX, KBRES   ; source segment is
                mov     DS, BX      ; inside the installer (this)
                mov     cx, offset EndofInt15 +1 ; byte count
                shr     cx, 1       ; -> word count
                xor      si,si
                xor      di,di
            rep  movsw

; 8 - set pointers to previous ints in resident code :
                 push     ES
                 pop      DS

        ASSUME  DS: KBRES   ; in fact, DS: *new* Resident Segment
                mov     ax, 3515h
		int 21h
                mov word ptr orgint15+0, bx
                mov word ptr orgint15+2, es


; 8.5- set French translations to active/inactive according to command param :
                call    setstate
                 PUSH    DS
                call    msg     ; output active/inactive state   XXXXX

; 9 - Put handler to work :
                ; reset dead key related flags:
                push    40h ; BIOS data seg
                pop     ds
                ASSUME  ds:BIOSSEG
                and     Cflags, not 3
                 POP     DS
                ; activate resident int 15 handler:
                ASSUME  DS:nothing
                ;  ASSUME DS: new (resident) segment
                mov     dx,offset introu15
                mov     ax,2515h
		int 21h

;10 - Installation done, return to DOS.
                mov     al, [french]    ; as errorlevel
                mov ah,4ch
		int 21h

main        endp
; ---------------------------------------------------------------------

errstr1 db "KBFR requiert une machine de classe PC/AT ou suprieure",cr,lf,'$'
insstr3 db "KBFR - gestionnaire du clavier franais v2.0"
                db "  -  Ninho, 2011.",cr,lf,"$"
hlpstr3 label byte
        db "Chargement: [lh] KBFR <+ - C U>",cr,lf
        db "KBFR + (ou simplement KBFR) active le clavier franais,",cr,lf
        db "KBFR - (ou KBFR 0) le dsactive,",cr,lf
        db "KBFR U (ou KBFR D) retire KBFR de la mmoire si possible,"
        db " le dsactive sinon.",cr,lf
        db 'Par dfaut, KBFR essaye de se charger en mmoire suprieure,',cr,lf
        db 'KBFR C force le chargement en mmoire "conventionnelle" (basse).'
        db cr,lf,'$'

activstr   db 'Clavier franais actif. "Kbfr -" le dsactive.',cr,lf,'$'
inactivstr db 'KBFR en mmoire mais inactif. "Kbfr +" pour l''activer.',cr,lf,'$'
errstr7 db "Manque de mmoire - ",07  ; --- followed by errstr6 --->
errstr6 db "KBFR n'est pas install!",cr,lf,'$'
errstr4 db "KBFR dsinstall.",cr,lf,'$'
errstr5 db 'Dsinstallation impossible!',07,cr,lf,'$'


  _TEXT ENDS

; --------------------------------------------------------------------
  KBRES SEGMENT PUBLIC PARA 'code' 
          ; resident segment, defined in module KBRES.
  KBRES ENDS
; --------------------------------------------------------------------

         end    main

