From: ror4@cryogen.com
Date: Wed, 14 Apr 1999 23:06:43 +0800
To: kernel@gcfl.net
Subject: [kernel] Driver to speed up floppy reads

Hi,

Here's a quick-and-dirty device driver for speeding up floppy reads which
I dashed out just a moment ago... `fastflop.asm' is the `nasm' source, and
`fastflop.hexdump' is a hex dump of the binary (for those who don't like
`nasm').

I tested it with DOS-C by adding the following line to `config.sys':

  device=fastflop.sys

and `command.com' loaded almost immediately. (Yes!)

Regards,

-- 
# -*- http://cryogen.com/ror4/ -*- http://wwp.mirabilis.com/8123598 -*-
# pgp -kvc: 1024/89d8686d  0f f4 b4 d9 2e 12 c7 b2  1a 85 bc 12 8f 54 77 f1

-- Listar MIME Decryption --------------
-- Name   : fastflop.asm.txt

%define	MAX_TRACK_SIZE	18

header:		dd	-1
		dw	0x8000
		dw	strat
		dw	intr
		db	"*KLUDGE*"

last_dx:
last_dl:	db	-1
last_dh:	db	-1
last_ch:	db	-1
track_size:	db	-1

old_0x13:
	pushf
	cli
	db	0x9a ; call far
old_0x13_vec:
	dw	0,0
	ret

new_0x13:
	sti
	test	dl,dl
	jns	.floppy
old:	jmp	far word [cs:old_0x13_vec]
floppy:
	cmp	ah,0x02
	jz	.handle_read
	cmp	[cs:last_dl],dl
	jnz	.old
	cmp	ah,0x16
	jz	.handle_cl
	mov	byte [cs:last_dl],-1
	jmp	short .old
handle_cl:
	call	old_0x13
	jnc	.exit
inval:	mov	byte [cs:last_dl],-1
exit:	retf	2
handle_read:
	push	ds
	push	bx
	xor	bx,bx
	mov	ds,bx
	lds	bx,[4*0x1e]
	cmp	byte [bx+3],2
	pop	bx
	pop	ds
	jnz	.old
	test	dh,dh
	jnz	.not_boot
	cmp	cx,0x0001
	jnz	.not_boot
	call	old_0x13
	jc	.inval
	cmp	byte [es:bx+2],0x90
	jnz	.ok
	cmp	byte [es:bx+0x18],MAX_TRACK_SIZE
	ja	.ok
	mov	byte [cs:last_dl],dl
	mov	byte [cs:last_dh],-1
	push	ax
	mov	al,[es:bx+0x18]
	mov	[cs:track_size],al
	pop	ax
ok:	clc
	retf	2
not_boot:
	cmp	[cs:last_dx],dx
	jnz	.read_track
	cmp	[cs:last_ch],ch
	jz	.copy_track
read_track:
	push	es
	push	ax
	push	bx
	push	cx
	mov	al,[cs:track_size]
	xor	bx,bx
	mov	es,bx
	les	bx,[es:4*0x1e]
	cmp	[es:bx+4],al
	jnb	.rd0
	mov	[es:bx+4],al
rd0:	mov	bx,cs
	mov	es,bx
	mov	bx,buf
	mov	cl,1
	call	old_0x13
	pop	cx
	pop	bx
	pop	ax
	pop	es
	jnc	.rd1
	mov	byte [cs:last_dl],-1
	jmp	.old
rd1:	mov	[cs:last_dx],dx
	mov	[cs:last_ch],ch
copy_track:
	test	cl,cl
	jz	.old_read
	cmp	cl,[cs:track_size]
	ja	.old_read
	push	ax
	add	al,cl
	dec	al
	cmp	al,[cs:track_size]
	pop	ax
	ja	.old_read
	pushf
	push	ds
	push	es
	push	cx
	push	si
	push	di
	cld
	mov	si,cs
	mov	ds,si
	dec	cx
	mov	ch,cl
	xor	cl,cl
	shl	ch,1
	mov	si,cx
	add	si,buf
	mov	ch,al
	mov	di,bx
rep	movsw
	pop	di
	pop	si
	pop	cx
	pop	es
	pop	ds
	popf
	xor	ah,ah
	retf	2
old_read:
	call	old_0x13
	jnc	.exit2
	mov	byte [cs:last_dl],-1
exit2:	retf	2

buf:

end		equ	$+MAX_TRACK_SIZE*512

strat:	mov	[cs:req],bx
	mov	[cs:req+2],es
	retf

intr:	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
	xor	ax,ax
	mov	ds,ax
	mov	ax,[4*0x13]
	mov	[cs:old_0x13_vec],ax
	mov	ax,[4*0x13+2]
	mov	[cs:old_0x13_vec+2],ax
	mov	word [4*0x13],new_0x13
	mov	word [4*0x13+2],cs
	mov	ax,cs
	mov	es,ax
	mov	ax,0x0201
	mov	bx,end
	mov	cx,0x0001
	xor	dx,dx
	int	0x13
	lds	bx,[cs:req]
	mov	word [bx+3],0x0100
	mov	word [bx+14],end
	mov	word [bx+16],cs
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	retf

req:
