
ifndef ?MASM
?MASM equ 1
endif

LF				EQU 0AH
CR				EQU 0DH

?VERSIONHIGH	equ 5
?VERSIONLOW		equ 40

?DMA			EQU 1		; 1=enable DMA support
?VDS			EQU 1		; 1=enable VDS support
?VCPI			EQU 1		; 1=enable VCPI support
?RING0EXC		EQU 1		; 1=display more infos on exc in ring 0
?A20XMS 		EQU 1		; 1=emu A20 by trapping XMS functions
?A20PORTS		EQU 1		; 1=emu A20 by trapping ports (92, 64, 60)
?ROMRO			EQU 1		; 1=make ROM page FF000 r/o
?VME			EQU 1		; 1=support P1+ VME extension
?EMMXXXX0		EQU 1		; 1=implement EMMXXXX0 IOCTL
?ALTBOOT		EQU 1		; 1=support ALTBOOT option
?MMASK			EQU 1		; 1=trap DMA master mask port (0F, DE)
?INVLPG			EQU 1		; 1=use INVLPG opcode on 80486+
?LOADSUPP		EQU 1		; 1=support LOAD command line option
?EMX			EQU 1		; 1=EMX compat switch supported
?SB 			EQU 1		; 1=SB compat switch supported
?PGE			EQU 1		; 1=support PGE on P3+ (requires ?INVLPG!) 
?EMM4F			EQU 1		; 1=implement int 67h, ah=4Fh
?EMM5556		EQU 1		; 1=implement int 67h, ah=55h/56h
?MOVEHIGH		EQU 1		; 1=support moving in first UMB
?CLEARHIGHESP	EQU 1		; 1=clear hiword(esp) for buggy VCPI clients

?SAFEMODE		EQU 0		; 1=make some additional security checks
?CODEIN2PAGE	EQU 0		; 1=move code away from first page
?FASTBOOT		EQU 0		; 1=fast boot (not impl. yet)
?UNIMPL_EMS_DBG	EQU	0		; 1=display a msg if an unimpl EMS func is called
?USETRIPLEFAULT	EQU 0		; 1=use triple fault to reboot

V86_TOS 		EQU 200H			; Size of monitor stack

?SYSPDE 		EQU 004h			; offset in pagedir for sys page table
?SYSPTE 		EQU 4				; offset in sys page table for system space
?SYSLINEAR		EQU ?SYSPDE shl 20 + ?SYSPTE shl 10
?SCRATCHPTE 	EQU 800h-8*4		; offset in sys page table scratch PTEs
?SCRATCHLINEAR	EQU ?SYSPDE shl 20 + ?SCRATCHPTE shl 10
?DMAPTE 		EQU ?SCRATCHPTE - 40h*4; start PTEs for DMA buffer
?DMALINEAR		EQU ?SYSPDE shl 20 + ?DMAPTE shl 10 ; linear address DMA buffer
?HMAPTE 		EQU ?SCRATCHPTE - 10h*4; start PTEs for HMA copy
?HMALINEAR		EQU ?SYSPDE shl 20 + ?HMAPTE shl 10 ; linear address HMA copy

?PAGEDIR		equ ?SYSLINEAR		; page dir is mapped at a fix linear address

?BPOPC			equ 0F4h			; opcode used for breakpoints

MAX_EMS_PAGES_ALLOWED	EQU	800h	; 32M max mem (16K each page), always even
; keep this value low for buggy VCPI clients that fail with large free amounts
MAXMEM16K_DEFAULT	EQU	1E00h	; 120M in 16K blocks

@KB_FLAG		EQU 417H			; Status SHIFT/CTRL/ALT etcetera.
@RESET_FLAG 	EQU 472H			; Flag for Warmboot (=1234h)

if ?DMA or ?VDS
?DMABUFFMAX		EQU 128				; max DMA-Buffer size in kB
endif

if ?DMA

;--- bits in GblFlags

HiLoFlag1		EQU 	0	  ; adressing the Hi-Byte , DMA #1
HiLoFlag2		EQU 	1	  ; Same for DMA controller #2
NeedBuffer		EQU 	2	  ; if DMA buffer is required

endif

if ?VCPI

; VCPI switch from V86 to protected mode data structure

V862PM	STRUC
swCR3		DD	?	; client's CR3 value
swGDTOFFS	DD	?	; offset of client's GDTR value
swIDTOFFS	DD	?	; offset of client's IDTR value
swLDTR		DW	?	; client's LDTR value
swTR		DW	?	; client's TR value
swCSEIP 	DF	?	; entry point in client
V862PM	ENDS

endif

@assumem macro reg_, pstruct_
if ?MASM
	assume reg_: pstruct_
endif
	endm

;--- EMS constants

MAX_HANDLES 	EQU 	255   ; There are only 255 handles to give away (lt.
							  ; Documentation  LIM EMS 4.0)
FREEPAGE_ID 	EQU 	255   ; Owner Handle of a free page

;--- EMS handle status

EMSH_SYSTEM	equ -1
EMSH_FREE	equ -2
EMSH_USED	equ -3

;--- EMS pool descriptor

EMSPD struc
wNibOfs dw ?		;nibble offset in pool descriptor
wPD		dw ?		;pool descriptor ID (offset/64 into PoolAlloc array)
EMSPD ends

; number of bytes for system info in EMS/VCPI pool allocation block,
;  must be >= sizeof POOL_SYSTEM_INFO_STRUC or bad things will happen quickly
POOLBLOCK_SYSTEM_SPACE	EQU	16

; number of bytes for allocation in a pool allocation block
; that are 48*8=384 bits, -> 384 * 4 kB -> 1536 kB
POOLBLOCK_ALLOCATION_SPACE	EQU	48

POOLBLOCK_TOTAL_SPACE	EQU	POOLBLOCK_SYSTEM_SPACE+POOLBLOCK_ALLOCATION_SPACE

POOL_SYSTEM_INFO_STRUC	struc
	psi_addressK	DD	?	; base address in K (may not be XMS handle base if handle size changed later)
	psi_descptr	DD	?	; pointer to XMS handle descriptor array entry/pseudo-handle value
	psi_startadj	DB	?	; unused K from XMS handle base for 4K alignment (0-3)
	psi_endadj	DB	?	; unused K at XMS handle end as 32K chunks (0-31)
	psi_16kmax	DB	?	; maximum number of 16K allocations (used allocation bytes*2), always even
	psi_16kfree	DB	?	; free number of 16K slots
	psi_4kfree	DW	?	; free number of 4K slots (>psi_16kfree*4 if any partials)
	psi_flags	DB	?	; various flag values
	psi_unused	DB	?
POOL_SYSTEM_INFO_STRUC	ends

if ?MASM
LPPOOL_SYSTEM_INFO_STRUC typedef ptr POOL_SYSTEM_INFO_STRUC
endif

POOLBLOCK_FLAG_DONTEXPAND	EQU	1	; don't try to expand or release this pool allocation block

XMS_ARRAY_STRUC	struc
	xas_flag		DB	?
	xas_lockcount	DB	?
	xas_addressK	DD	?
	xas_sizeK		DD	?
XMS_ARRAY_STRUC	ends

if ?MASM
LPXMS_ARRAY_STRUC typedef ptr XMS_ARRAY_STRUC
endif

;--- XMS handle flags

XMS_FREE	equ 1	;handle describes a free EMB
XMS_USED	equ 2	;handle describes a used EMB
XMS_INPOOL	equ 4	;handle is free


XMS_HANDLE_TABLE_STRUC	struc
	xht_sig			DB	?
	xht_sizeof		DB	?
	xht_numhandle	DW	?
	xht_array		DD	?		;converted to linear address!
XMS_HANDLE_TABLE_STRUC	ends

;--- TSS structure
;--- the only fields in the TSS which are needed are tsEsp0, tsSS0
;--- and tsOfs. Jemm386 will never switch tasks.

TSSSEG	struc
		dd ?	;+00 selector
tsEsp0	dd ?	;+04
tsSS0	dd ?	;+08
		dq ?	;+0C
		dq ?	;+14
tsCR3	dd ?	;+1C
tsEip	dd ?	;+20
tsEfl	dd ?	;+24
tsEax	dd ?	;+28
tsEcx	dd ?	;+2C
tsEdx	dd ?	;+30
tsEbx	dd ?	;+34
tsEsp	dd ?	;+38
tsEbp	dd ?	;+3C
tsEsi	dd ?	;+40
tsEdi	dd ?	;+44
tsES	dd ?	;+48
tsCS	dd ?	;+4C
tsSS	dd ?	;+50
tsDS	dd ?	;+54
tsFS	dd ?	;+58
tsGS	dd ?	;+5C
tsLDTR	dd ?	;+60
tsFlags	dw ?	;+64
tsOfs	dw ?	;+66
TSSSEG	ends

;--- stack frame for PUSHAD

PUSHADS struc
rEDI	dd ?
rESI	dd ?
rEBP	dd ?
        dd ?	;reserved
rEBX	dd ?
rEDX	dd ?
rECX	dd ?
rEAX	dd ?
PUSHADS ends

;--- stack frame for normal INTs in v86 mode

IRETDV86 struc
vEIP	dd ?	;+0
vCS		dd ?	;+4	
vEFL 	dd ?	;+8
vESP	dd ?	;+12
vSS		dd ?	;+16
vES		dd ?	;+20
vDS		dd ?	;+24
vFS		dd ?	;+28
vGS		dd ?	;+32
IRETDV86 ends

;--- stack frame in V86 monitor for exceptions with error code

V86FRGP  struc
gECX	dd ?	;+0
gEBX	dd ?	;+4
gEAX	dd ?	;+8
gIntNo	dd ?	;+12
gErrC	dd ?	;+16
gEIP	dd ?	;+20
gCS		dd ?	;+24	
gEFL	dd ?	;+28
gESP	dd ?	;+32
gSS		dd ?	;+36
gES		dd ?	;+40
gDS		dd ?	;+44
gFS		dd ?	;+48
gGS		dd ?	;+52
V86FRGP ends		

;--- stack frame in V86 monitor for IRQs and software INTs

V86FRAME struc
fECX	dd ?	;+0
fEBX	dd ?	;+4
fEAX	dd ?	;+8
fIntNo  dd ?	;+12
fEIP	dd ?	;+16
fCS		dd ?	;+20
fEFL	dd ?	;+24
fESP	dd ?	;+28
fSS		dd ?	;+32
fES		dd ?	;+36
fDS		dd ?	;+40
fFS		dd ?	;+44
fGS		dd ?	;+48
V86FRAME ends		 

;--- stack frame inside EMM/VCPI functions

EMMFRAME struc
eRet	dd ?	;+0
eEcx	dd ?	;+4
eEdi	dd ?	;+8
eEsi	dd ?	;+12
eEip	dd ?	;+16
eCS		dd ?	;+20
eEfl	dd ?	;+24
eEsp	dd ?	;+28
eSS		dd ?	;+32
eES		dd ?	;+36
eDS		dd ?	;+40
eFS		dd ?	;+44
eGS		dd ?	;+48
EMMFRAME ends

if ?EMMXXXX0

;--- structure returned by Jemm386 if an "INFO" request was made
;--- for device "EMMXXXX0"

EMX06 struc
e06_NoEMS	 	db ? ;+0
e06_Frame		dw ? ;+1 segment
e06_NoVCPI		db ? ;+3
e06_DMABuff		dd ? ;+4 physical address DMA buffer
e06_NoPGE 		db ? ;+8
				db ?
				db ?
				db ?
e06_DMASize		dw ? ;+12 in KB
e06_NoVME 		db ? ;+14
e06_NoA20 		db ? ;+15
e06_VCPITotal	dd ? ;+16 VCPI pages total (def 120 MB)
e06_VCPIUsed	dd ? ;+20 VCPI pages allocated
EMX06 ends

;--- this is the structure for an "UPDATE" request with IoctlWrite

EMX15W struc
e15_bVME	db ?
e15_bA20	db ?
e15_bVCPI	db ?
e15_bPGE	db ?
EMX15W ends

endif

;--- data for monitor initialization
;--- this structure is also defined in C (jemm386.c)!!!

JEMMINIT struc
jiMonitorStart		dd ?	;XMS memory block start address
jiMonitorEnd		dd ?	;XMS memory block end address
jiTotalMemory 		dd ?	;XMS highest physical memory address
jiMaxMem16k			dd ?	;MAX VCPI mem in 16 kB units (default 7680)
jiXMSHandleTable	dd ?	;XMS handle table (FAR16)
jiMaxEMSPages		dw ?	;EMS max 16 kB pages (default 2048)
jiXMSControlHandle	dw ?	;XMS memory block handle
jiDMABufferSize		dw ?	;DMA buffer size in kB
jiFrame				dw ?	;EMS page frame (default E000)
jiNoEMS				db ?
jiNoFrame			db ?
jiNoPool			db ?
jiAltBoot 			db ?
jiNoVME				db ?
jiNoVDS				db ?
jiNoPGE				db ?
jiNoA20				db ?
jiNoVCPI			db ?
jiNoInvlPg			db ?
jiV86Flags			db ?
JEMMINIT ends

;--- this is the table of RSEG offsets 
;--- the values are byte-offsets into the RSEG segment
;--- there is just one instance defined in jemm16.asm.

RSOFS struc
wBpTab		dw ?	;offset of BP table
if ?DMA
wRFlags		dw ?	;offset of DMA flags
endif
RSOFS ends

?NUMUMBS	equ 8

UMBBLK struc
wSegm	dw ?	;segment address
wSize	dw ?	;size in paras, high bit used as flag free/allocated
UMBBLK ends

;--- macros

; Macro for bypassing the 386-Bug with 32-Bit-Stringoperations
; only needed for Mask-version B3
; AddressSize - Prefix + NOP attached
; obsolete, since Jemm386 now runs in a 32bit code segment

@BIG_NOP MACRO
;;		DB 67h	  ;  32-Bit-Prefix
;;		NOP
		ENDM

@BPOPC macro
	db ?BPOPC
	endm

@mov_eax_cr4 macro
	db 0fh, 20h, 0E0h
	endm
@mov_ecx_cr4 macro
	db 0fh, 20h, 0E1h
	endm

@mov_cr4_eax macro
	db 0fh, 22h, 0E0h
	endm
@mov_cr4_ecx macro
	db 0fh, 22h, 0E1h
	endm
@mov_cr4_edx macro
	db 0fh, 22h, 0E2h
	endm

@cpuid	macro
;	cpuid
	db 0Fh,0A2h
	endm

@wrmsr	macro
	db 0Fh,030h
	endm
	
@rdtsc	macro
	db 0Fh,031h
	endm

@rdmsr	macro
	db 0Fh,032h
	endm
 
;--- macro to get a pointer to PTEs
;--- reg: register to set
;--- ofs: offset in page dir/page table
;--- bIsConst: if blank, then ofs is/contains a register
 
@GETPTEPTR macro reg, ofs, bIsConst
if 0
	mov reg,[PAGEDIR]
  ifnb <ofs>  
	lea reg, [reg+ofs]
  endif  
else
  ifnb <ofs>
	ifnb <bIsConst>
	  mov reg,?PAGEDIR+ofs
	else
	  lea reg,[?PAGEDIR+ofs]
	endif
  else
	mov reg, ?PAGEDIR
  endif
endif
	endm

@GETPTE macro reg, ofs, bIsConst
if 0
	mov reg,[PAGEDIR]
	mov reg,[reg+ofs]
else
	ifnb <bIsConst>
	  mov reg,ds:[?PAGEDIR+ofs]
	else
	  mov reg,[?PAGEDIR+ofs]
	endif
endif
	endm

