/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+-----------------------------------------------------------------------------+
| 2002/12/22 ץ 2000-3g/3h  format ҫإ fat mAçspWh        |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "bootmgr.h"
#include "common.h"
#include "global.h"

/*
static sword Auto_Modify_ID (PARTN *ptr);
*/
static sword Formatting (PARTN *partnArr, sword ndx);

/*==========================  t    D {  ========================*/
#if SUPPORT_QKFORMAT

sword Quick_Format (PARTN *partnArr, sword ndx)
{
#if ( DISPLAY == CHINESE )
    #define ARE_YOU_SURE_QKFORMAT    "      d l a  ϡA\nz T w n i     H"
    #define FS_EXIST_STILL_FORMAT    "         t  I\n T w n i     H"
    #define PROMPT_KEY               "(Y)Tw   (N)"
    #define DANGER_TITLE_MSG         "M  I"
#else   
    #define ARE_YOU_SURE_QKFORMAT    "The function don't check bad sector,\nAre you sure to quick format ?"
    #define FS_EXIST_STILL_FORMAT    "Found file system exist !\nAre you sure to continue ?"
    #define PROMPT_KEY               "(Y)es  or  (N)o"
    #define DANGER_TITLE_MSG         "danger"
#endif

    PARTN  *ptr;
    sword  key;
           
    if ( IsUpdatePartn() )                  /** Y partition ʥB|xs **/
        return(2);
 
    ptr = &partnArr[ndx];
    if ( YN_box(IMMEDIATE_BOX, ARE_YOU_SURE_QKFORMAT) )
    { 
        byte  buff[512];
        
        if ( (linear_ReadWDK(GetStart(ptr), 1, buff) == 0) && \
             (*(word *)&buff[0x1fe] == 0xaa55) )
        {
            key = Message_Box(DANGER_TITLE_MSG, 
                              FS_EXIST_STILL_FORMAT, PROMPT_KEY, FALSE);
            if ( toupper(key) != 'Y' )
                return(1);
        } /* end if */
    }
    else
        return(1);
 
#if 0
    if ( Auto_Modify_ID(ptr) == 0 &&                   /** Modify System ID **/
         (!IsAllowSavePartn() || Write_Partn(partnArr, 0, 0)) )
    {
         return(-1);
    }
#endif
 
    if ( Formatting(partnArr, ndx) )
        return(-2);                             /**@tκϰϤlaϰ **/
 
    return(0);
} /* end Quick_Format */

#endif  /* SUPPORT_QKFORMAT */


/*============================= Modify System ID ============================*/
#if 0
static sword Auto_Modify_ID (PARTN *ptr)
{ 
    sword  old_id = ptr->old_id;
    dword  size;
 
    size = Get_nSector(ptr) / 2048L;                           /** Unit: MB **/
 
    if ( size < 16 )
        ptr->old_id = 1;
    else if ( size < 32 )
        ptr->old_id = 4;
    else if ( size < 512 )
        ptr->old_id = 6;
    else if ( size >= 2048 )
        ptr->old_id = 0xb;
    else if ( ptr->old_id != 6 && ptr->old_id != 0xb && ptr->old_id != 0xe )
        ptr->old_id = ( g_Info.fd.use_fat32 ) ? 0xb : 6;
   
    if ( (ptr->no < 5) && (ptr->end > 1023) )
        ptr->old_id = (ptr->old_id == 0xb || ptr->old_id == 0xc) ? 0xc : 0xe;
 
    if ( ptr->id != HIDDEN_ID )
        ptr->id = ptr->old_id;
 
    return( old_id == ptr->old_id );
} /* end Auto_Modify_ID */
#endif


/*====================== إ FAT 12 or 16 or 32 BPB ========================*/
static dword GetSectorPerFat (sword fatType, dword tSector,
                              word nBootSect, word nRootSect, word sectPerClust)
{
    sword  decClust, incSect, shift;
    dword  nFatSect, nClusts;

    nClusts   = tSector - nBootSect - nRootSect;
    nFatSect  = (nClusts % sectPerClust) / 2;
    nClusts  /= sectPerClust;
    nClusts  += ((fatType == 32) ? 3 : 2);     /* fat entry + root next link */

    if ( sectPerClust > 1 )
    {
        incSect  = sectPerClust / 2;              /* {{w FAT u */
        decClust = 1;
    }
    else
    {
        incSect  = 1;
        decClust = 2;                             /* {{w FAT u */
    } /* end if */

    if ( fatType == 12 )
    {
        /** nFatSect x 512 / 1.5 = nFatSect x 512 x 2 / 3 **/
        while ( ((nFatSect << 10) / 3)  < nClusts )
        {
            nFatSect += incSect;
            nClusts  -= decClust;
        } /* end while */
    }
    else
    {
        /* nSLOT: fat32=(nFatSect * 512 / 4), fat16=(nFatSect * 512 / 2) */
        shift = ( fatType == 32 ) ? 7 : 8;

        while ( (nFatSect << shift) < nClusts )
        {
            nFatSect += incSect;
            nClusts  -= decClust;
        } /* end while */
    } /* end if */

    return( nFatSect );
} /* end GetSectorPerFat */


/*====================== إ FAT 12 or 16 or 32 BPB ========================*/
sword CreateBPB (PARTN *partnArr, sword ndx, void *buffer)
{
    const   byte noNameLabel[] = "NO NAME    ";
    dword   extStart, tSector, serno, size/*, tmp*/;
    sword   fatType;
    byte    FAR *codePTR;
    byte    *bootStrap;
    PARTN   *ptr;
    DOSBPB  *bpb;

    serno = time(NULL);
                      
    ptr = partnArr + ndx;
    memset(buffer, 0, 512);
    bpb = (DOSBPB *)buffer;
 
    extStart = 0;
    if ( ptr->no > 4 )
    {
        ndx = Find_EXT(partnArr);                            /* MXR */
        extStart = GetStart(partnArr + ndx);
    } /* end if */
 
    tSector = Get_nSector(ptr);                            /* κϰ`   */
 
    CopyMem(bpb->comm.oem, "MSWIN4.1", 8);                 /* ѧOr       */
    bpb->comm.bytePerSect  = 512;                          /* Cϰ Byte  */
    bpb->comm.nFAT         = 2;                   /* {{w FAT u */
    bpb->comm.m_descriptor = 0xf8;                         /* wЬ 0xf8    */
    bpb->comm.sectPerTrack = (word)CUR_DK->lgeo.maxSect;   /* Cyhֺϰ */
    bpb->comm.nHead        = (word)CUR_DK->lgeo.maxHead + 1;/* CϬWh֭ */
    bpb->comm.tSector4     = tSector;                      /* κϰ`   */
    bpb->comm.nHiddSect    = GetStart(ptr) - extStart;     /* úϰϼ     */
    bpb->comm.magicNum     = 0xaa55;                       /* Magic Number   */
 
    size = tSector / 2048;                                 /* ⦨ MB      */
 
    fatType = ( ptr->old_id == 1 ) ? 12 :
              ( ptr->old_id == 0x4 || ptr->old_id == 0x6 ) ? 16 :
              ( ptr->old_id == 0xb || ptr->old_id == 0xc ) ? 32 :
              ( ptr->old_id == 0xe && tSector >= (16UL << 11) ) ? 16 : 12;
              
    /*----------------------+
    |         FAT 32        |
    +----------------------*/
    if ( fatType == 32 )
    {
        bpb->comm.nBootSect    = 32;                     /* Odϰϼ       */
        bpb->fat32.rootClust   = 2;                      /* ڥؿΤL */
        bpb->fat32.fsInfoSect  = 1;                      /* ɮרtθTϰ */
        bpb->fat32.bakBootSect = 6;                      /* ҰʺϰϪϰϼ */
        bpb->fat32.firstHD     = 0x80;                   /* Ĥ@wХN   */
        bpb->fat32.signature   = 0x29;                   /* SxX           */
        bpb->fat32.serNoLow    = (word)serno;
        bpb->fat32.serNoHigh   = *((word *)&serno + 1);
        CopyMem(bpb->fat32.label, noNameLabel, 11);              /* Label    */
        CopyMem(bpb->fat32.fsType, "FAT32   ", 8);               /* ɮרt */ 

      
        /*----------- C Cluster ϰϼ ------------*/
        bpb->comm.sectPerClust = ( size <   259L ) ?  1 :
                                 ( size <  8192L ) ?  8 :
                                 ( size < 16384L ) ? 16 :
                                 ( size < 32768L ) ? 32 : 64;

        /* p@ FAT ϰϼ */
        bpb->fat32.nFatSect =
            GetSectorPerFat(fatType, tSector, bpb->comm.nBootSect,
                            bpb->comm.sectPerClust, bpb->comm.sectPerClust);

        bootStrap = bpb->fat32.bootStrap;            /** Ұʵ{Xm **/
    }
    /*---------------------+
    |     FAT 12 or 16     |
    +---------------------*/
    else
    {
        bpb->comm.nBootSect  = 1;                        /** FAT eϰϼ **/
        bpb->fat1x.nFdbRoot  = 512;                          /** ڥؿ **/
        bpb->fat1x.firstHD   = 0x80;                     /** Ĥ@wХN **/
        bpb->fat1x.signature = 0x29;                             /** SxX **/
        bpb->fat1x.serNoLow    = (word)serno;
        bpb->fat1x.serNoHigh   = *((word *)&serno + 1);
        CopyMem(bpb->fat1x.label, noNameLabel, 11);               /** Label **/
        
        /* J FAT16 ɮרtΦr, FAT12 |byԭץ */
        CopyMem(bpb->fat1x.fsType, "FAT16   ", 8);

        if ( fatType == 12 )
        {
            bpb->fat1x.fsType[4] = '2';
            bpb->comm.sectPerClust = 8;                           /** FAT12 **/
        }
        else
        {
            /*----------- C Cluster ϰϼ ------------*/
            bpb->comm.sectPerClust = ( size <=   32 ) ?  1 :      /** FAT16 **/
                                     ( size <=   64 ) ?  2 :        
                                     ( size <=  127 ) ?  4 :       
                                     ( size <=  255 ) ?  8 :       
                                     ( size <=  511 ) ? 16 :      
                                     ( size <= 1023 ) ? 32 : 64; 
        } /* end if */

        /* p@ FAT ϰϼ */
        bpb->fat1x.nFatSect =
            (word)GetSectorPerFat(fatType, tSector, bpb->comm.nBootSect,
                                  bpb->fat1x.nFdbRoot / 16, bpb->comm.sectPerClust);

        bootStrap = bpb->fat1x.bootStrap;            /** Ұʵ{Xm **/
    } /* end if */


    codePTR = (byte FAR *)BOOT_HEAD;
    while ( codePTR != (byte FAR *)BOOT_END )            /** JҰʵ{X **/
        *bootStrap++ = *codePTR++;
 
    /*--------------------------------------+
    |  Modify SI context at BootSect.asm    |
    |  and fill JUMP instruction to buffer  |
    +--------------------------------------*/
    bpb->comm.nop = 0x90;                                      /** NOP O **/
    bpb->comm.jumpCode = 0xeb;
    if ( fatType == 32 )
    {                                        /** JMP O 58h  BPB  **/
        bpb->comm.jumpOffset = 512 - sizeof(bpb->fat32.bootStrap) - 4;
        bpb->fat32.bootStrap[ (word)BOOT_DATA - (word)BOOT_HEAD + 1 ] += 0x5a;
    }
    else
    {                                        /** JMP O 3Ch  BPB  **/
        bpb->comm.jumpOffset = 512 - sizeof(bpb->fat1x.bootStrap) - 4;
        bpb->fat1x.bootStrap[ (word)BOOT_DATA - (word)BOOT_HEAD + 1 ] += 0x3e;
    } /* end if */
    
    return( fatType );
} /* end CreateBPB */

     
/*=======================   FAT32   t    =====================*/
void CreateFsSector (PARTN *ptr, void *bootSect, void *target, sword bNew)
{
    #if ( DISPLAY == CHINESE )
        #define WORKING_MSG     " b p      cluster ơDDD"
    #else 
        #define WORKING_MSG     "It's count the number of free cluster...."
    #endif
    
    FS_SECT  *fsSect = (FS_SECT *)target;
    DOSBPB   *bpb    = (DOSBPB *)bootSect;
    dword    firstFree, amount, count, maxNO, i;
    dword    nSysSector, tSector;
    sword    j;

    memset(target, 0, 512);
 
    tSector = Get_nSector(ptr);                            /** κϰ` **/
    nSysSector = bpb->fat32.nFatSect * bpb->comm.nFAT +
                 bpb->comm.nBootSect + bpb->comm.sectPerClust;

    /*-------------------------------------------------------+
    |            p       cluster  q            |
    +-------------------------------------------------------*/
    if ( bNew )
    {
        firstFree = 2;
        amount    = (tSector - nSysSector) / (dword)bpb->comm.sectPerClust;
    }
    else
    {
        byte  buff[512];

        count     =
        amount    =  0;
        firstFree = -1UL;

        /** D̫@ cluster s **/
        maxNO = (tSector - nSysSector) / bpb->comm.sectPerClust + 3;

        ShowMSG(WORKING_MSG);
        for ( i = GetStart(ptr) + bpb->comm.nBootSect ; count < maxNO ; i++ )
        {
            if ( linear_ReadWDK(i, 1, buff) == 0 )
                for ( j = 0 ; j < 512 && count < maxNO ; j += 4 )
                {
                    if ( *(dword *)&buff[j] == 0 )
                    {
                        if ( firstFree > count )
                            firstFree = count;   /** O̫@ӥϥ cluster **/
                        amount++;                   /** p⥼ϥΪ clust ` **/
                    } /* end if */
        
                    count++;
                } /* end for */
        } /* end for */

        ShowMSG(NULL);
    } /* end if */

    fsSect->next_free_clus = firstFree;
    fsSect->free_clust_cnt = amount;
    fsSect->title          = 0x41615252L;
    fsSect->signature      = 0x61417272L;
    fsSect->magicNum       = 0xaa55;
} /* end CreateFsSector */


/*=======================   FAT32   t    =====================*/
void CreateFsSector2 (PARTN *ptr, void *bootSect, void *target)
{
    FS_SECT2  *fsSect2 = (FS_SECT2 *)target;

    (void)ptr;
    (void)bootSect;
    memset(fsSect2, 0, 512);
    fsSect2->magicNum = 0xaa55;
} /* end CreateFsSector2 */


/*=======================   FAT32   t    =====================*/
static sword CreateFAT (PARTN *ptr, void *bootSect, sword fatType, sword bClear)
{
    DOSBPB  *bpb = (DOSBPB *)bootSect;           /* bootSect must be initial */
    dword   sect = GetStart(ptr);
    dword   nSect;
    sword   i;
    byte    buff[512];
    
    memset(buff, 0, 512);

    sect += bpb->comm.nBootSect;
    if ( fatType == 32 )
    {
        nSect = bpb->fat32.nFatSect;
        *(dword *)&buff[4] =
        *(dword *)&buff[8] = 0x0fffffffL;
        buff[3] = 0x0f;
    }
    else
    {
        nSect = bpb->fat1x.nFatSect;
        if ( fatType == 16 )
            buff[3] = 0xff;
    } /* end if */

    buff[0] = bpb->comm.m_descriptor;                      /** ]ƴyzr **/
    buff[1] = 0xff;
    buff[2] = 0xff;

    if ( bClear && Fill_Sector(CUR_DK, sect, (sword)nSect * 2, 0) )
        return(-1);

    for ( i = 0 ; i < bpb->comm.nFAT ; i++,  sect += nSect )
        if ( linear_WriteWDK(sect, 1, buff) )
            return(-1);

    return(0);
} /* end CreateFAT */


/*========================= x s FAT32     =========================*/
sword SaveDosBootSector (PARTN *ptr, void *bootSect, sword fatType)
{
    DOSBPB  *bpb = (DOSBPB *)bootSect;           /* bootSect must be initial */
    dword   sect = GetStart(ptr);
    void    *pbuf;
    sword   i;

    if ( fatType == 32 )
    {
        byte  buff[512];

        /* Fill_Sector(CUR_DK, sect, bpb->nBootSect, 0); */
        for ( i = 1 ; i < 4 ; i++ )
        {
            switch ( i )
            {
                case 1:                                     /** boot sector **/
                    pbuf = bootSect;
                    break;
                case 2:                             /** fat32 fsinfo sector **/
                    pbuf = buff;
                    CreateFsSector(ptr, bpb, buff, TRUE);
                    break;
                case 3:                           /** fat32 fsinfo sector 2 **/
                    pbuf = buff;
                    CreateFsSector2(ptr, bpb, buff);
                    break;
            } /* end switch */

            if ( linear_WriteWDK(sect, 1, pbuf) ||
                 linear_WriteWDK(sect + bpb->fat32.bakBootSect, 1, pbuf) )
                return(-i);
            
            sect++;
        } /* end for */
    }
    else
    {
        if ( linear_WriteWDK(sect, 1, bootSect) )
            return(-1);        
    } /* end if */
    
    return(0);
} /* end SaveDosBootSector */


/*============================= i     ==============================*/
static sword Formatting (PARTN *partnArr, sword ndx)
{
    #if ( DISPLAY == CHINESE )
        #define FORMATING_MSG   " b i    ơA w    "
    #else 
        #define FORMATING_MSG   "It's formatting, completed  "
    #endif
 
    dword   nSysSector, nowSect, sect;
    byte    bootSect[512];
    sword   fatType, ratio, nSect;
    PARTN   *ptr = partnArr + ndx;
    DOSBPB  *bpb = (DOSBPB *)bootSect;

    nowSect = GetStart(ptr);                               /** oҩlϰ **/
    fatType = CreateBPB(partnArr, ndx, bpb);                   /** إ BPB **/

    if ( fatType == 32 )                       /** pɮרtΦΦhֺϰ **/
        nSysSector = bpb->fat32.nFatSect * bpb->comm.nFAT +
                     bpb->comm.nBootSect + bpb->comm.sectPerClust;
    else
        nSysSector = bpb->fat1x.nFatSect * bpb->comm.nFAT +
                     bpb->comm.nBootSect + (bpb->fat1x.nFdbRoot >> 4);

    /*--------------- t      -----------------*/
    nSect = 32;
    ShowMSG(FORMATING_MSG);
    for ( sect = 0 ; sect < nSysSector ; sect += nSect )
    {
        if ( (sword)(nSysSector - sect) < nSect )
            nSect = (sword)(nSysSector - sect);
        if ( Fill_Sector(CUR_DK, nowSect + sect, nSect, 0) )
            return(-1);
  
        ratio = (sword)(sect * 100 / nSysSector);
        c_printf("%3d%%\b\b\b\b", ratio);                    /** ܧv **/
    } /* end for */

    ShowMSG(NULL);

    /** create boot sector **/
    if ( SaveDosBootSector(ptr, bpb, fatType) )
        return(-1);

    /** create FAT entry **/
    if ( CreateFAT(ptr, bpb, fatType, FALSE) )
        return(-1);

    return(0);
} /* end Formatting */
