/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "bootmgr.h"
#include "common.h"
#include "global.h"

/* ]weƥwİϮeq */
/* ثeis e@ù  GܮءfΪ̬O eܮءf */
#define BUFFER_SIZE         ((80 * 25 + (42 * 8) * 2) * 2)

/* ]wiHsJ(ƥ)e */
#define LIMIT_PUSH_TIMES    (5)

static byte  gs_BuffHead[BUFFER_SIZE];                      /** ƥe **/
static byte  *gs_BuffEnd = gs_BuffHead + BUFFER_SIZE;

static byte  *gs_Stack[LIMIT_PUSH_TIMES] = { gs_BuffHead, NULL };
static sword gs_Top = 0;

/*======================= t m     J   ========================*/
static void *PushBuffer (sword size)
{
    byte  *ret = gs_Stack[gs_Top];
    byte  *end = ret + size;
 
    #if SPF_DEBUG
        if ( end > gs_BuffEnd )
        {
            Bug_Msg_Box("BUFFER_SIZE is not enough !\n"
                        "Please press ctrl-c to terminate", NULL);
            return( NULL );
        } /* end if */
  
        if ( (gs_Top + 1) >= LIMIT_PUSH_TIMES )
        {
            Error_Msg_Box("LIMIT_PUSH_TIMES is not enough !", NULL);
            return( NULL );
        } /* end if */
    #endif  /* SPF_DEBUG */
 
    gs_Stack[++gs_Top] = end;
    return( ret );
} /* end PushBuffer */

   
/*========================== O s  e e  ==============================*/
static void *PopBuffer (void)
{
    #if SPF_DEBUG
        if ( gs_Top == 0 )
        {
            Bug_Msg_Box("PopBuffer() be called too much !"
                        "\nPlease press ctrl-c to terminate", NULL);
            return( NULL );
        } /* end if */
    #endif /* SPF_DEBUG */
 
    return( gs_Stack[--gs_Top] );
} /* end PopBuffer */


/*========================== O s   e  ==============================*/
void PushScreenBlock (sword x1, sword y1, sword x2, sword y2)
{
    void *buff = PushBuffer( (x2 - x1 + 1) * (y2 - y1 + 1) * 2 );

#if ( SPF_DEBUG ) 
    if ( buff )
#endif
        c_gettext(x1, y1, x2, y2, buff);
} /* end PushScreenBlock */


/*========================== ^ s   e  ==============================*/
void PopScreenBlock (sword x1, sword y1, sword x2, sword y2)
{
    void *buff = PopBuffer();

#if ( SPF_DEBUG ) 
    if ( buff )
#endif
        c_puttext(x1, y1, x2, y2, buff);
} /* end PopScreenBlock */


/*==================     @  O s    e  =================*/
void GiveupScreenBlock (void)
{
    PopBuffer();
} /* end GiveupScreenBlock */


/*========================== O s  e e  ==============================*/
void SaveScreen (void)
{  
    /* c_gettext(1, 1, 80, 25, gs_Screen); */
    PushScreenBlock(1, 1, 80, 25);
} /* end SaveScreen */


/*========================== ^ s  e e  ==============================*/
void RestoreScreen (void)
{
    /* c_puttext(1, 1, 80, 25, gs_Screen); */
    PopScreenBlock(1, 1, 80, 25);
} /* end RestoreScreen */


/*============================ øsίx ===============================*/
void MenuBox (sword x1, sword y1, sword x2, sword y2, sword *h_line)
{
    c_textattr(PAR_MENU_COLOR);
    Clr_Block(x1-1, y1-1, x2-1, y2-1);                         /** M **/
    Square(x1, y1, x2, y2, h_line);                              /** e **/
    c_textattr(DEFAULT_COLOR);
} /* end MenuBox */


/*============================ bTCqr ===============================*/
void ShowMSG (const sbyte *str, ...)
{
    va_list  va_ptr;
 
    c_textattr(MESSAGE_COLOR);
    Clr_Block(12, 22, 77, 22);
    if ( str )
    {
        c_gotoxy(13, 23);
        va_start(va_ptr, str);
        c_vprintf(str, va_ptr);
        va_end(va_ptr);
    } /* end if */
 
    c_textattr(DEFAULT_COLOR);
} /* end ShowMSG */


/*========================== YCܦr =============================*/
void ShowCenter (sword row, const sbyte *str)
{
    sword  col;
 
    col = (80 - strlen(str)) / 2;
    c_printXY(col, row, str);
} /* end ShowCenter */


/*========================   d    r  ==========================*/
void ShowRangeStr (sword Front, sword Rear, void *buff, sword len, FILE *fptr)
{
    byte   *ptr = (byte *)buff;
    byte   chr;
    sword  i;
 
    for ( i = 0 ; i < len ; i++ )
    {
        chr = (ptr[i] >= Front && ptr[i] <= Rear) ? ptr[i] : '.';
        if ( fptr )
            new_fputc(chr, fptr);
        else
            c_putch(chr);
    } /* end for */
} /* end ShowRangeStr */


/*=================================  @ n ================================*/
void Beep (void)
{
    c_putch(7);
} /* end Beep */
