/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <alloc.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include "global.h"
#include "common.h"

extern DiskDRV  g_diskDrv;                             /** in the diskdrv.c **/

static sword    gs_ChkET (void);
static int      gs_NO_CTRL_BREAK (void);
static int      gs_CTRL_BREAK (void);

static void     (FAR *gs_OldInt24)() = NULL;

/*----------------------------- System Initial -------------------------------+
|             {}lɩһݰPx]wAҦpGdIYӤ_          |
+----------------------------------------------------------------------------*/
sword SystemInitial (void)
{
    sword  i;

    #if MSDOS
        gs_ChkET();                  /** pGbʤѤ大UhJ­^Ҧ **/
        gs_OldInt24 = Get_Vector(0x24);
        Set_Vector(0x24, (void (FAR *)())MY_INT_24);       /** dI INT 24h **/
        Enable_Ctrl_Break();                    /** dIåB\ Ctrl_Break **/
        g_Info.swap_status = Get_Disk_Extra_Status();
        Disk_Extra_Ctrl(PAUSE_DISK_XCHG);          /** ȰϺХN\ **/
    #endif
 
    Init_Screen();                              /** Initial display modular **/

    if ( CreateDiskParaTable() )                         /** إߺϺаѼƪ **/
    {
        ShowError(0);                                        /** O餣 **/
        return(-1);
    } /* end if */
 
    /** }ҩҦϺг] **/
    for ( i = g_Info.nFP + g_Info.nHD - 1 ; i >= 0 ; i-- )
        g_DTable[i].drv->open(&g_DTable[i]);
 
    return(0);
} /* end SystemInitial */


/*----------------------------- System Recovery ------------------------------+
|             {ɩһ٭Px]wAҦpG__            |
+----------------------------------------------------------------------------*/
void SystemRecovery (void)
{
    sword  i;
 
    /** ҦϺг] for linux **/
    for ( i = g_Info.nFP + g_Info.nHD - 1 ; i >= 0 ; i-- )
        g_DTable[i].drv->close(&g_DTable[i]);
 
    End_Screen();                              /** Recovery display modular **/
 
    #if MSDOS
        Disk_Extra_Ctrl(DISK_XCHG);                /** ҥκϺХN\ **/
        if ( gs_OldInt24 )
        {
            Set_Vector(0x24, gs_OldInt24);
            gs_OldInt24 = NULL;
        } /* end if */
    #endif
} /* end SystemRecovery */


/*----------------------- Create Disk Parameter table ------------------------+
| إ᪺߫ϺаѼư}C| g_DTable ܼƫVA}Ces g_Info.nFP |
| ӤOnЪϺаѼƪA۳s g_Info.nHD ӤhOwаѼƪ          |
+----------------------------------------------------------------------------*/  
sword CreateDiskParaTable (void)
{
    sword   nDisk, no, i;
    DiskDT  *dk;
 
    /*----- onBwо -----*/
    nDisk  = g_Info.nFP = GetNumDisk(0);
    nDisk += g_Info.nHD = GetNumDisk(1);
 
    /*--- tmϺаѼƪŶ ---*/
    if ( nDisk > 0 )
    {
        g_DTable = (DiskDT *) malloc(sizeof(DiskDT) * nDisk);
        if ( g_DTable == NULL )
            return(-1);                                   /** Out of memory **/
    } /* end if */
 
    /*-----------------------------------------------+
    |  DϺЪ(nBwЬƦ SCSI w)      |
    |  MA driverAAoϺдX           |
    +-----------------------------------------------*/
    no = 0;
    for ( dk = g_DTable, i = 0 ; i < nDisk ; i++,  no++,  dk++ )
    {
        if ( i < g_Info.nFP )
            dk->flag = FLOPPY_DISK;                                /** n **/
        else
        {
            if ( i == g_Info.nFP )
                no = 0x80;
            dk->flag = HARD_DISK;                                  /** w **/
        } /* end if */
  
        dk->diskNO = no;
        dk->drv    = &g_diskDrv;                      /** MwϥΪ driver **/
  
        dk->drv->open(dk);                             /** }ҳoӺϺг] **/
        dk->drv->getAttr(dk);                    /** oϺдXΨ䥦Ѽ **/
        dk->drv->close(dk);                            /** oӺϺг] **/
    } /* end for */
 
    g_Info.reboot_flag = 0;    /** N}ɨMwO_ܽЭsҰʪXM **/
 
    /*-----------------------------------+
    |  Nu@йw]VĤ@wаѼƪ  |
    +-----------------------------------*/
    SetWorkingDisk( GetHardDiskDT(1) );                  /** ]wu@Ϻ **/
 
    return(0);
} /* end CreateDiskParaTable */


/*----------------------------- onwЭӼ -------------------------------+
|  kind Ϻо                                                        |
|    = 0     onоӼ                                                   |
|    = 1     owЭӼ                                                     |
+-----------------------------------------------------------------------------+
|  return value:  Ϻо                                                    |
+----------------------------------------------------------------------------*/
sword GetNumDisk (sword kind)
{
    union Regs regs;
 
    regs.h.ah = 8;
    regs.h.dl = ( kind == 0 ) ? 0 : 0x80;                     /** n:w **/
    BiosCall(0x13, &regs, NULL);
    return( (regs.x.cflag == 0) ? (sword)regs.h.dl : 0 );
} /* end GetNumDisk */


/*---------------------       \     ---------------------+
|   ѼơG                                                                    |
|             ctrl = DISK_XCHG                ҥκϺФ                    |
|                    PAUSE_DISK_XCHG          ȰϺФ                    |
|                    DETECT_XCHG_STATUS       O_ҥκϺиm          |
|                    RELEASE_MY_INT13          My int13h                  |
|   Ǧ^ȡG                                                                  |
|             ctrl = DETECT_XCHG_STATUSAǦ^ 0 ҥθmA1 ҥΡA      |
|                                        䥦ȫhOW MY_INT13h           | 
|             ctrl = 䥦AYOǦ^D  ܥW MY_INT13h (in int13.asm)  |
+----------------------------------------------------------------------------*/
sword Disk_Extra_Ctrl (byte ctrl)
{
    #if MSDOS
        if ( g_Info.swap_status == DISK_XCHG )
            return( Ctrl_DrvExchg(ctrl) );             /** in the bootmgr.c **/
        else
            return(-1);
    #else
        return(-1);
    #endif
} /* end Disk_Extra_Ctrl */


/*------------------  o  B ] w  e      A --------------*/
sword Set_Disk_Extra_Status (byte ctrl)
{
    #if MSDOS
        sword  ret = 0;

        if ( g_Info.swap_status == DISK_XCHG )
        {
            ret = Get_Disk_Extra_Status();
            Disk_Extra_Ctrl(ctrl);
        } /* end if */

        return( ret );
    #else
        return(-1);
    #endif
} /* end Set_Disk_Extra_Status */


/*---------------------  o  e       A --------------------*/
sword Get_Disk_Extra_Status (void)
{
    #if MSDOS
        sword  ret;
    
        ret = Ctrl_DrvExchg(DETECT_XCHG_STATUS);
        if ( ret == 1 )
            return( DISK_XCHG );
        else if ( ret == 0 )
            return( PAUSE_DISK_XCHG );
        else
            return(-1);
    #else
        return(-1);
    #endif    
} /* end Get_Disk_Extra_Status */


/*-----------------  o  e    b  m  C    ------------*/
#if  ( DISPLAY == TEXTMODE )

word GetCurTextAttr (void)
{
    union Regs regs;

    regs.h.ah = 8;
    regs.h.bh = 0;
    BiosCall(0x10, &regs, NULL);
    return( regs.x.ax );
} /* end GetCurTextAttr */

#endif


/*----------------------------  d O _    -------------------------*/
sword ChkKeyPressed (void)
{
    #if MSDOS
        union Regs regs;
      
        regs.h.ah = 0x0b;
        BiosCall(0x21, &regs, NULL);
        return( regs.h.al == 0xFF );                 /** DOS version >= 4.0 **/
    #else
        return(0);
    #endif
} /* end ChkKeyPressed */


/*---------------------------------------------------------------------------*/
/*  Ǧ^䤧 ASCII codeApGO function key |Ǧ^ 0 MO scan code   */
/*---------------------------------------------------------------------------*/
sword GetCharacter (void)
{
    #if MSDOS
        union Regs regs;
 
        regs.h.ah = 7;
        BiosCall(0x21, &regs, NULL);
        return( (sword)(byte)regs.h.al );    /** console input without echo **/
    #else
        return(0);
    #endif
} /* end GetCharacter */


/*-------------------------------  J   -------------------------------*/
/*                    get prass key ascii code and scan code                 */
/*---------------------------------------------------------------------------*/
word GetRealKey (void)
{
    #if MSDOS
        union Regs regs;
 
        regs.h.ah = 0;
        BiosCall(0x16, &regs, NULL);
        return( regs.x.ax );                     /** scan_code : ascii_code **/
    #else
        return(0);
    #endif
} /* end GetRealKey */


/*---------------------- Read partition table to buffer ----------------------+
|                                                                             |
|   dk              ŪϺ                                              |
|   partn           Ūνs                                          |
|   partnAddr       oΪҩlϰ                                  |
|   buff            sŪ partition table                                |
+----------------------------------------------------------------------------*/
sword GetPartnToBuffer (DiskDT *dk, byte partn, dword *partnAddr, byte *buff)
{
    return( GetPartn(dk->diskNO, partn, partnAddr, buff) );
} /* end GetPartnToBuffer */


/*----------------------------   ^  shell ----------------------------*/
sword TempToShell (void)
{
    #if ( DISPLAY == CHINESE )
        #define IS_TEMP_TO_SHELL   "T w n   ^  DOS H\nz i H   'EXIT'  ^ { C"
    #else
        #define IS_TEMP_TO_SHELL   "Are you sure to enter OS shell ?\nYou can type 'EXIT' go back SPFDisk."
    #endif

    static sword busy = 0;
    sword  bakColor = GetColor();
    sword  ret;
 
    if ( busy )
        return(0);
    else
        busy = 1;
 
    SaveScreen();                                              /** xse **/
 
    #if MSDOS
        if ( !YN_box(TALK_BOX, IS_TEMP_TO_SHELL) )
        {
            RestoreScreen();                                   /** _e **/
            c_textattr(bakColor);
            busy = 0;
            return(0);
        } /* end if */
    #endif
 
    End_Screen();                                 /** Recovery display mode **/
 
    #if MSDOS
        Disk_Extra_Ctrl(DISK_XCHG);                /** ҥκϺХN\ **/
        if ( gs_OldInt24 )
        {
            Set_Vector(0x24, gs_OldInt24);
            gs_OldInt24 = NULL;
        } /* end if */
  
        #if ( DISPLAY == TEXTMODE )
            c_textattr(INIT_COLOR);
            c_clrscr();
        #endif
        
        fprintf(stdout, "type 'EXIT' back to SPFDisk");
    #endif
 
    ret = system("");                                 /** run default shell **/
 
    #if MSDOS
        gs_ChkET();                  /** pGbʤѤ大UhJ­^Ҧ **/
        gs_OldInt24 = Get_Vector(0x24);
        Set_Vector(0x24, (void (FAR *)())MY_INT_24);       /** dI INT 24h **/
        Enable_Ctrl_Break();                    /** dIåB\ Ctrl_Break **/
        Disk_Extra_Ctrl(PAUSE_DISK_XCHG);          /** ȰϺХN\ **/
    #endif
 
    Init_Screen();                              /** Initial display modular **/
    RestoreScreen();                                           /** _e **/
    c_textattr(bakColor);
    busy = 0;
 
    return( ret );
} /* end TempToShell */


/*----------------------------  \ Ctrl_Break -----------------------------*/
void Enable_Ctrl_Break (void)
{
    #if MSDOS
        ctrlbrk(gs_CTRL_BREAK);
    #else
        return;
    #endif
} /* end Enable_Ctrl_Break */


/*---------------------------- T  Ctrl_Break -----------------------------*/
void Disable_Ctrl_Break (void)
{
    #if MSDOS
        ctrlbrk(gs_NO_CTRL_BREAK);
    #else
        return;
    #endif
} /* end Disable_Ctrl_Break */


/*============================================================================+
|                              static function                                |
+============================================================================*/

#if  MSDOS      /* @Ш̫@C gs_CTRL_BREAK() **/

/*-------------------------- ˬdʤѤO_sb ---------------------------*/
static sword gs_ChkET (void)
{
    union  Regs regs;
    sword  status;
 
    regs.h.ah = 0x91;
    BiosCall(0x10, &regs, NULL);
    if ( regs.h.ah == 0x91 )
        status = 0;
    else
    {
        if ( (regs.h.dh & 0x80) == 0 )         /** Ob­^ҦU~ **/
            fprintf(stdout, "%cIA", 27);
#if 0
        if ( regs.h.dh & 0x80 )
        {
           regs.x.ax = 0x804e;                   /** ­^Ҧ^Ҧ **/
           BiosCall(0x10, &regs, NULL);
        } /* end if */
#endif

        status = 1;
    } /* end if */
 
    return( status );
} /* end gs_ChkET */


/*------------------------ T Ctrl_Break N{ -----------------------*/
static int gs_NO_CTRL_BREAK (void)
{
    return(1);                                   /** ^줤_m~ **/
} /* end gs_NO_CTRL_BREAK */


/*------------------------ \ Ctrl_Break N{ -----------------------*/
static int gs_CTRL_BREAK (void)
{                       
    SPFDisk_End_Process();
    return(0);                                                 /** { **/
} /* end gs_CTRL_BREAK() */

#endif   /* MSDOS */
