/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include "fdisk.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

/*========================   t  ID  T =============================*/
static void Show_sysid_name (void)
{
    sword  id, h, y;
 
    Clr_Block(0, 0, 79, 23);

    h = 0;
    y = 1;
    for ( id = 0 ; id < 256 ; id++ )
    {
        /*----------------- uܤw ID name ---------------*/
        if ( g_SysName[id] == g_SysName[0x100] )
            continue;
        c_textattr(MESSAGE_COLOR);
        c_printXY(h * 19 + 3, y, "%02x ", id);
        c_textattr(DEFAULT_COLOR);
        c_printf(g_SysName[id]);
        if ( ++h > 3 )
        {
            h = 0;
            y++;
        } /* end if */
    } /* end for */
 
    DISPLAY_OK:
 
    c_gotoxy(1, 10);
} /* end Show_sysid_name */


/*============================ ]wt ID ==================================*/
void Set_ID (PARTN *partnArr, sword ndx)
{
    #if ( DISPLAY == CHINESE )
        #define INPUT_SYS_ID_MSG    " J t  ע N XG "
    #else
        #define INPUT_SYS_ID_MSG    "Input system ID number: "
    #endif

    sword  update, newID, oldID;
    sbyte  buff[512];
    PARTN  *ptr;
 
    ptr = &partnArr[ndx];

    /*g_Info.fd.clr_screen = TRUE; */
    Show_sysid_name();
 
    sprintf(buff, "%02X", ptr->id);             /** Initial for GetStr(...) **/
    do
    {
        c_printXY(3, 24, INPUT_SYS_ID_MSG);
        if ( GetStr(buff, 2, HEX_STR | HAS_INITIAL | ALLOW_ESC) == ESC_KEY )
            return;
    } while ( *buff == 0 );

    newID = (sword)strtoul(buff, NULL, 16);
    if ( ptr->id != newID )
    {
        update = 1;
        if ( Is_Extended(newID) )
        {
            if ( !Is_Extended(ptr->old_id) )           /** 쥻OXR **/
            {
                if ( g_Info.fd.ext_head != -1 )   /** ˬdXRάO_wsb**/
                {
                    update = 0;
                    ShowError(9);
                }
                else
                {
                    if ( ptr->stCyl == 0 )                 /** վҩlϬW **/
                        ptr->stCyl = 1;
                    g_Info.fd.ext_head = ptr->stCyl;       /** إXR **/
                    g_Info.fd.ext_end  = ptr->endCyl;
                    g_Info.fd.maxParNO = 4;
                    Ins_elem(partnArr, g_Info.fd.used, ptr->stCyl, ptr->endCyl);
                } /* end if */
            } /* end if */
        }
        else
        {
            if ( newID == 0 )                     /** pG ID O 0 R **/
            {
                Del_Partn(partnArr, ndx);
            }
            else if ( Is_Extended(ptr->old_id) )           /** Ext אּ䥦 **/
            {
                if ( ptr->stCyl == 1 )                     /** վҩlϬW **/
                    ptr->stCyl = 0;
                g_Info.fd.used     =  g_Info.fd.pri_use;
                g_Info.fd.ext_head = -1;
                g_Info.fd.ext_end  = -1;
                g_Info.fd.maxParNO =  4;
            } /* end if */
        } /* end if */
  
        if ( update )
        {
            if ( newID != 0 )
            {
                ptr->id = newID;
                oldID   = ptr->old_id;

                if ( !IsHiddenID(newID) )
                    ptr->old_id = newID;
                else if ( IsHiddenWinID(newID) )
                    ptr->old_id = newID & 0x0f;

                if ( !Is_Extended(oldID) && Is_Extended(newID) )
                    if ( ChkValidLogicPartn(ptr) )
                        ReloadLogicPartn(partnArr);
            } /* end if */

            if ( g_Info.fd.modified <= 0 )
                g_Info.fd.modified = -1;             /** pGSإ߷s **/
        } /* end if */
    } /* end if */
} /* end Set_ID */


/*============================ / ==============================*/
void Hidden_partn (PARTN *ptr)
{
    sword  id;
 
    id = ptr->id;

    if ( IsHiddenPartn(ptr) )
        ptr->id = ptr->old_id;
    else
    {
        ptr->old_id = ptr->id;
        ptr->id = ( ChkSysID(id, NT_FAT12_16_32) ) ? id | 0x10 : HIDDEN_ID;
    } /* end if */

    if ( (id != ptr->id) && (g_Info.fd.modified <= 0) )
        g_Info.fd.modified = -1;
} /* end Hidden_partn */
