/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "bootmgr.h"
#include "selemenu.h"
#include "global.h"
#include "keymap.h"
#include "undo.h"

/*=============================== D {  ==================================*/
void main (int argc, sbyte *argv[])
{
    #if ( DISPLAY == CHINESE )
        #define PROMPT_KEY_MSG      "  W U        I"
    #else 
        #define PROMPT_KEY_MSG      "Please move light bar to choice item !"
    #endif

    static PARTN partnArr[MAX_PARTN_ELEM];
    sword  sele;
    extern SeleMenu g_Menu;                                /** ο檫 **/

 /* atexit( SystemRecovery );   */      /** ɦ۰ʩIs SystemRecovery() **/
 
    if ( SPFDisk_Initial() || ProcCommandLinePara(argc, argv) )  /** l **/
    {
        SystemRecovery();                        /** recovery system status **/
        return;
    } /* end if */
 
    c_textattr(DEFAULT_COLOR);
    c_clrscr();                                /** NeM DEFAULT_COLOR **/
    
    ShowExtra(VER_LINE);                                 /** ܪTC **/
    Show_Copyright();                            /** ܪvr in help.c **/
 
    sele = 1;
    do
    {
        if ( g_Info.bm.clr_screen )
        {
            Boot_Menu_Picture( TRUE );                       /** ܥDe **/
            g_Info.bm.clr_screen = FALSE;
        } /* end if */
  
        List_BootMenu_Rec(g_Boot, g_BootPara.nBootREC);/** ܶ} **/
        ShowMSG(PROMPT_KEY_MSG);
  
        /*--------------------+
        |   ]wοݩ  |
        +--------------------*/
        g_Menu.enableCtrl( M_WRAP |            /* i`ο           */
                           M_SENS |            /* ^䤣jpg         */
                           M_LOCK |            /* UDk䤣}     */
                           M_AUTOENTER );      /* UŦX䤣ݦA Enter */

        g_Menu.disableCtrl( M_ONESELE );     /* u@ӿﶵɤܿ */
        g_Menu.menuColor(DEFAULT_COLOR, LIGHT_BAR_COLOR);        /* C */
  
        switch ( g_Info.usingMenu )
        {
            default:
            case MAIN_MENU:
                sele = Bootmgr_Menu(sele, g_Boot, partnArr);
                if ( g_Info.usingMenu != MAIN_MENU )     /** pG^D **/
                    sele = 2;
                break;

            case BOOTMGR_EDIT_MENU:
                sele = Bootmgr_Edit_Menu(sele, g_Boot, partnArr);
                if ( g_Info.usingMenu == MAIN_MENU )     /** pG^D **/
                    sele = 3;                /** ΰbyszﶵ **/
                break;

            case BOOTMGR_OPTION_MENU:
                sele = Bootmgr_Option_Menu(sele, g_Boot, partnArr);
                if ( g_Info.usingMenu == MAIN_MENU )     /** pG^D **/
                    sele = 4;                /** ΰbyi]wzﶵ **/
                break;

            case FDISK_TOOL_MENU:
                Fdisk(partnArr);
                SwitchMenu( g_Info.prevMenu );
                g_Info.bm.clr_screen = TRUE;
                break;
        } /* end switch */
    } while ( sele != QUIT_TO_DOS );

    SPFDisk_End_Process();                               /** { **/
} /* end main */


/*--------------------- Command line parameter analysis ---------------------*/
void SwitchMenu (sword menu)
{
    g_Info.prevMenu  = g_Info.usingMenu;
    g_Info.usingMenu = menu;
} /* end SwitchMenu */


/*--------------------- Command line parameter analysis ---------------------*/
sword ProcCommandLinePara (sword argc, sbyte **argv)
{
    #if ( DISPLAY == CHINESE )
        #define REBUILD_MBR_DONE_MSG    "Master Boot Record  s   I"
        #define RESTORE_DONE_MSG        "UNDO      ^ s   I"
    #else
        #define REBUILD_MBR_DONE_MSG    "Master Boot Record rebuild done !"
        #define RESTORE_DONE_MSG        "Backup/UNDO file restore done !"
    #endif

    sbyte  *fname = NULL;
    sword  flag, err, i;
 
    flag = 0;
    for ( i = 1 ; i < argc ; i++ )
        if ( stricmp(argv[i], "/mbr") == 0 )
            flag |= F_REBUILD_MBR;
        else if( stricmp(argv[i], "/undo") == 0 )
        {
            if ( fname || ((i + 1) >= argc) )
            {
                flag |= F_INVALID;
                break;
            }
            else
            {
                flag |= F_UNDO_FILE;
                fname = argv[i+1];
                i++;
            } /* end if */
        }
        else if ( stricmp(argv[i], "/?") == 0 )
            flag |= F_HELP;
        else
            flag |= F_INVALID;
 
    if ( flag & (F_HELP | F_INVALID) )
    {          
        Show_Help();                                           /** 䥦Ѽ **/
        if ( flag & F_INVALID )
            ShowError(4);

#if ( DISPLAY != TEXTMODE )
        else
            WaitKey();
#endif
        return( TRUE );
    } /* end if */

    /*------ pG^s undo ɪѼ ------*/
    if ( flag & F_UNDO_FILE )
    {
        err = TryToRestoreUNDO(fname);
        if ( err == 0 )
            Prompt_Msg_Box(RESTORE_DONE_MSG, NULL);
        else
        {
            if ( err == -1 )
                c_printf("filename: %s\n", fname);
            ShowError( ( err == -1 ) ? 8 :                 /** ɮ׶}ҥ **/
                       ( err == -2 || err == -3 ) ? 10 :   /** ɮפe~ **/
                       ( err == -4 ) ? 16 : 17 );        /** Check Sum ~ **/
        } /* end if */

        return( TRUE );
    } /* end if */

    /*------- pGU MBR Ѽ --------*/
    if ( flag & F_REBUILD_MBR )
    {
        if ( Update_MBR( GetHardDiskDT(1) ) )        /** sĤ@w MBR **/
            ShowError( 2 );                                   /** sѡI**/
        else
            Prompt_Msg_Box(REBUILD_MBR_DONE_MSG, NULL);
        return( TRUE );
    } /* end if */
 
    return( FALSE );
} /* end ProcCommandLinePara */


/*===============================  l  ==================================*/
sword SPFDisk_Initial (void)
{
    #if ( DISPLAY == CHINESE )
        #define NOT_FOUND_HD        "wг]ơATw~ϥΡH"
    #else
        #define NOT_FOUND_HD        "Not found any hard disk!\nAre you sure to continue?"
    #endif

    /* extern SeleMenu g_Menu; */

    g_Info.prevMenu   =                              /** OW@ϥο **/
    g_Info.usingMenu  = MAIN_MENU;                   /** ܥثeϥΪ **/

    g_Info.expertMode = FALSE;                             /** w]@Ҧ **/
    g_Info.undoFP     = NULL;

    if ( SystemInitial() )                     /** Pxl]w **/
        return( TRUE );

    /* w */
    if ( g_Info.nHD <= 0 )
    {
        /* n */
        if ( g_Info.nFP <= 0 )
        {
            ShowError( 3 );                             /** xs]ƤsbI**/
            return( TRUE );
        }
        else
        {
            g_Info.expertMode = TRUE;                    /** MaҦ **/
            if ( !YN_box(PROMPT_BOX, NOT_FOUND_HD) )       /** ߰ݬO_~ **/
                return( TRUE );
        } /* end if */
    } /* end if */ 

    Reset_Bootmgr();                                   /** in the bootrec.c **/
    Reset_Fdisk();                                       /** in the fdisk.c **/
 
    /* g_Menu.setHotKey(F5_KEY, TempToShell, TRUE); */
    SetHotKey(F5_KEY, TempToShell, TRUE);          /**  F5 Ȯɦ^ shell **/
 
    return( FALSE );
} /* end SPFDisk_Initial */


/*======================== Program terminate process ========================*/
void SPFDisk_End_Process (void)
{
    if ( g_Info.reboot_flag )
    {
        #if ( DISPLAY == CHINESE )
            Warning_Msg_Box("ΪʡAаOos}I", NULL);
        #else      
            Warning_Msg_Box("Partition table has been modified,\nplease reboot !", NULL);
        #endif
    } /* end if */
 
    #if ( DISPLAY == TEXTMODE )
        c_textattr(INIT_COLOR);
        c_clrscr();
    #endif
    
    SystemRecovery();                    /** {ɶ檺tΦ^_ʧ@ **/
 
    fprintf(stdout, "Bye Bye !\n");
} /* end SPFDisk_End_Process */
