/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <io.h>
#include "bootmgr.h"
#include "common.h"
#include "global.h"
#include "keymap.h"
#include "getobj.h"

struct eatKey
{
    word vdirkey : 1;
    word hdirkey : 1;
    word escape  : 1;
    word space   : 1;
    word hold    : 4;
} gs_EatKey;

static struct MenuHotKey
{
    sword sw;
    sword eat;
    sword key;
    sword (*func)(void);
} gs_hotKey;


/*================================ Y =================================*/
static sword FilterKey (sword *key)
{
    return( gs_EatKey.space   && (*key == ' ') || 
            gs_EatKey.escape  && (*key == ESC_KEY) ||
            gs_EatKey.vdirkey && (*key == UP_KEY || *key == DOWN_KEY) ||
            gs_EatKey.hdirkey && (*key == LEFT_KEY || *key == RIGHT_KEY) );
} /* end FilterKey */


/*======================= ƦrβĤ@ӦrO '+'  ========================*/
#if 0
sword CheckInput (sword key, sbyte *var, sword offset, sword item, sword len)
{
    /* קK compiler oXê [ܼƫŧiqϥ] ĵiT */
    (void)offset;
    (void)item;
    (void)len;
    (void)var;
    return( !((key == '+' && offset == 1) || (key != '-') || (key != '.')) );
}
#endif


/*============================  J    } ============================*/
sword Input_CHS_LBA (dword *cyl, dword *head, dword *sector, dword *linearSect)
{
#if ( DISPLAY == CHINESE )
    #define C_TITLE     "ϡ@@WG "
    #define H_TITLE     "ϡ@@YG "
    #define S_TITLE     "ϡ@@ϡG "
    #define LBA_TITLE   "uʺϰϡG "
    #define PROMPT_MSG  "Y [uʺϰ] 즳JơA[ϬWBYBϰ] NQϥ"
#else
    #define C_TITLE     "Cylinder:  "
    #define H_TITLE     "Head:      "
    #define S_TITLE     "Sector:    "
    #define LBA_TITLE   "LBA Sector:"
    #define PROMPT_MSG  "if input LBA field then CHS field will be ignored"
#endif   
    #define C_LEN       10
    #define H_LEN        3
    #define S_LEN        2
    #define LBA_LEN     10
    
    extern GETOBJ g_GetObj;
    static sbyte  linearStr[LBA_LEN + 1],                 /* J LBA ϰϥ */
                  cStr[C_LEN + 1],                             /* JϬW */
                  hStr[H_LEN + 1],                             /* JY */
                  sStr[S_LEN + 1];                             /* Jϰϥ */
    sbyte  pict[] = "@9";                  /* ˪JƦrBt +, -  */
    sword  key;

    ShowMSG(PROMPT_MSG);

    *linearStr = '\0';
    sprintf(cStr, "%lu", *cyl);
    sprintf(hStr, "%lu", ((*head >= 0 && *head < 256) ? *head : 255) );
    sprintf(sStr, "%lu", ((*sector >= 0 && *sector < 64) ? *sector : 63) );

    PushScreenBlock(24, 9, 52, 17);                          /* ƥϰe */
    MenuBox(24, 9, 52, 17, NULL);                      /* øs@Ӭܮ */

    g_GetObj.disableCtrl( G_AUTOENTER | G_ALLOW | G_WRAP |
                          G_USETAB | G_ALLOWLEAVE | G_CUR_RESET );
    g_GetObj.enableCtrl( G_CURMEM );

    /* ]wݽs誺 */
    g_GetObj.s_get(28, 10, C_TITLE, C_LEN, cStr, pict);
    g_GetObj.s_get(28, 12, H_TITLE, H_LEN, hStr, pict);
    g_GetObj.s_get(28, 14, S_TITLE, S_LEN, sStr, pict);
    g_GetObj.s_get(28, 16, LBA_TITLE, LBA_LEN, linearStr, pict);
    g_GetObj.edit(1);
    key = g_GetObj.lastkey();

    if ( linearStr[0] )                    /* pG LBA Sector 즳J */
    {
        *linearSect = strtoul(linearStr, NULL, 10);
        if ( *linearSect < CUR_DK->lgeo.tnSector )     /* WLϺ`ϰϼ */
            Sect_to_CHS(*linearSect, cyl, head, sector, CUR_DK);
    }
    else
    {
        *cyl        = ( cStr[0] ) ? strtoul(cStr, NULL, 10) : 0;
        *head       = ( hStr[0] ) ? strtoul(hStr, NULL, 10) : 0;
        *sector     = ( sStr[0] ) ? strtoul(sStr, NULL, 10) : 1;
        *linearSect = CHS_to_Sect(*cyl, *head, *sector, CUR_DK);
    } /* end if */

    PopScreenBlock(24, 9, 52, 17);                          /* ^sϰe */
    return( key );   
} /* end Input_CHS_LBA */


/*================================= r걵 ================================*/
/*  key_flag Pɳ]whӦӲͺXĬɡANHUCǨΡG              */
/*                                                                           */
/*        PASSWORD > HEX_STR > LIMIT_NUM_SYMB > LIMIT_NUMERIC                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
sword GetStr (sbyte *str, sword len, sword key_flag)
{
    extern GETOBJ g_GetObj;
    sword  key, x, y;
    sbyte  *pict = ( key_flag & PASSWORD       ) ? "@P" :
                   ( key_flag & HEX_STR        ) ? "@H" :
                   ( key_flag & LIMIT_NUM_SYMB ) ? "@#" : 
                   ( key_flag & LIMIT_NUMERIC  ) ? "@9" : NULL;

    /** TRUE okV **/
    gs_EatKey.hdirkey = ( (key_flag & PASSWORD) ||
                          (key_flag & DISABLE_HDIRKEY) ) ? TRUE : FALSE;
    /** TRUE oWUV **/
    gs_EatKey.vdirkey = ( (key_flag & PASSWORD) ||
                          (key_flag & DISABLE_VDIRKEY) ) ? TRUE : FALSE;
    /** TRUE oť **/
    gs_EatKey.space   = ( key_flag & ALLOW_SPACE ) ? FALSE : TRUE;

    /** TRUE o ESC  **/
    gs_EatKey.escape  = ( key_flag & ALLOW_ESC ) ? FALSE : TRUE;

    /* wqrNqаѦ getobj.h */
    g_GetObj.disableCtrl( G_AUTOENTER | G_ALLOW | G_WRAP | G_USETAB | G_ALLOWLEAVE );

    if ( key_flag & AUTO_ENTER )
        g_GetObj.enableCtrl( G_AUTOENTER );

    GetXY(&x, &y);
    x++;
    y++;

    if ( !(key_flag & HAS_INITIAL) )
        *str = 0;

    /* ܽsõݿJAХisϤN */
    g_GetObj.get(x, y, NULL, len, str, NULL, pict, FALSE, NULL, NULL, FilterKey, NULL);
    g_GetObj.edit(1);
    key = g_GetObj.lastkey();

    Repeat_Char('\b', len);
    c_printXY(x, y, "%-*s", len, ((key_flag & PASSWORD) ? " " : str) );
    Repeat_Char('\b', len);

    return( key );
} /* end GetStr */


/*=============================== Ʀr ==================================*/
sword InputDWORD (void *var, dword min, dword max, sword len, sword key_flag)
{
    extern GETOBJ g_GetObj;
    sbyte  str[11];
    sword  key;
    dword  tmp;

    key_flag |= LIMIT_NUMERIC;

    if ( len > 10 )
        len = 10;

    if ( min > max )                                       /* swap min, max */
    {
        tmp = min;
        min = max;
        max = tmp;
    } /* end if */

    if ( key_flag & HAS_INITIAL )
        sprintf(str, ((key_flag & HEX_STR) ? "%lX" : "%ld"), *(dword *)var);

    do
    {
        do
        {
            key = GetStr(str, len, key_flag);
            if ( key == ESC_KEY )
                return( ESC_KEY );
        } while ( *str == '-' );                          /*  '-' }Y */

        if ( (key_flag & DIRECT_ENTER) && (*str == 0) )
            tmp = min;
        else
            tmp = strtoul(str, NULL, (key_flag & HEX_STR) ? 16 : 10);
    } while ( (tmp < min) || (tmp > max) );

    sprintf(str, ((key_flag & HEX_STR) ? "%lX" : "%lu"), tmp);
    c_printf("%-*s", len, str);
    Repeat_Char('\b', len);

    *(dword *)var = tmp;
    return( key );
} /* end InputDWORD */


/*=============================== Ʀr ==================================*/
sword InputWORD (void *var, dword min, dword max, sword len, sword key_flag)
{
    dword  tmp;
    sword  key;

    tmp = (dword) *(word *)var;
    key = InputDWORD(&tmp, min, max, len, key_flag);
    *(word *)var = (word)tmp;
    return( key );
} /* end InputWORD */


/*================================ ߰ݬO_ =================================*/
sword Is_Yes (sbyte *chinese)
{
   sword  sele;

   ShowMSG(chinese);
   c_textattr(KEY_IN_COLOR);
   c_printf(" \b");

   while ( ((sele = toupper(WaitKey())) != 'Y') && (sele != 'N') );
   c_textattr(DEFAULT_COLOR);

   return( sele == 'Y' );
} /* end Is_Yes */


/*==============================  J  W ================================*/
sword Input_Filename (sbyte *str, sword len)
{
   sword  flag = TRUE;

   #if ( DISPLAY == CHINESE )
      ShowMSG("  J   W ١G ");
   #else 
      ShowMSG("Please input filename: ");
   #endif
   if ( (GetStr(str, len, ALLOW_ESC) == ESC_KEY) || (strlen(str) == 0) )
       flag = FALSE;
   ShowMSG(NULL);
   return( flag );
} /* end Input_Filename */


/*===========================  d O _  \ =============================*/
sword Is_Overwrite (sbyte *str)
{
   #if ( DISPLAY == CHINESE )
       return( new_access(str, 0) == -1 ||
               YN_box(WARNING_BOX, "ɤwsbAnл\\ܡH") );
   #else 
       return( new_access(str, 0) == -1 ||
               YN_box(WARNING_BOX, "The file already exist, overwrite ?") );
   #endif
} /* end Is_Overwrite */


/*============================== Mwİ ==============================*/
void ClrKeyBuffer ()
{
    while ( c_kbhit() )
        c_getch();
} /* end ClrKeyBuffer */


/*-------------------------------- Check Key --------------------------------*/
sword c_kbhit (void)
{
    return( ChkKeyPressed() );
} /* end c_kbhit */


/*-------------------------------  J   -------------------------------*/
/*  Ǧ^䤧 ASCII codeApGO function key |Ǧ^ 0 MO scan code   */
/*---------------------------------------------------------------------------*/
sword c_getch (void)
{
    return( GetCharacter() );
} /* end c_getch */


/*=============================== ] w   ===============================*/
sword SetHotKey (sword key, sword (*func)(void), sword eat)
{
    gs_hotKey.key  = key;
    gs_hotKey.func = func;
    gs_hotKey.eat  = eat;
    gs_hotKey.sw   = TRUE;
    return(0);
} /* end SetHotKey */


/*========================= ] w      A =========================*/
void SetHotKeySW (sword key, sword flags)
{
    if ( gs_hotKey.key == key )
        gs_hotKey.sw = flags;
} /* end SetHotKeySW */


/*=============================== B z   ===============================*/
/* ثeuBz@Ӽ */
static sword ProcHotKey (sword key)
{
    sword  cursorStatus;
    sword  x, y;

    if ( (key == gs_hotKey.key) && gs_hotKey.sw )
    {
        cursorStatus = IsCursorShow();                     /** ƥЪA **/
        GetXY(&x, &y);
        if ( gs_hotKey.func )
            gs_hotKey.func();
        c_gotoxy(x+1, y+1);
        Ctrl_Cursor( cursorStatus );                       /** ٭ЪA **/
        if ( gs_hotKey.eat )                           /** Wh즹 **/
            return( TRUE );
    } /* end if */
 
    return( FALSE );               /** ׬O_AWh|즹 **/
} /* end ProcHotKey */


/*====================== rܵݿJB|ˬd =====================*/
sword WaitKey (void)
{
    static  sbyte str[] = "-\\|/";
    static  sbyte *ptr = str;
    sword   key;

    do
    { 
        while ( c_kbhit() == 0 )
            if ( !IsCursorShow() )
            {
                if ( *(++ptr) == 0 )
                    ptr = str;
                c_printf("%c\b", *ptr);
            } /* end if */
     
        if ( !IsCursorShow() )
            c_printf(" \b");
     
        /* added by SPF, 2001.05.20 */
        key = (sword)(byte)c_getch();
        if ( key == 0 )                                     /** if function key **/
            key = (sword)c_getch() << 8;      /** (scan code << 8) + ASCII code **/

    } while ( ProcHotKey(key) );            /** if TRUE then Y䤣ǵWh **/
     
    return( key );
} /* end WaitKey */


/*============================ O _  \   ============================*/
sword IsFuncKey (sword key)
{
    return( (key & 0x00ff) == 0 );
} /* end IsFuncKey */


/*-------------------------------  J   -------------------------------*/
/*                    get prass key ascii code and scan code                 */
/*---------------------------------------------------------------------------*/
word c_get_real_key (void)
{
    return( GetRealKey() );
} /* end c_get_real_key */
