/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "bootmgr.h"
#include "common.h"
#include "selemenu.h"
#include "global.h"
#include "keymap.h"

sword Fdisk (PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        #define PROMPT_MSG   "[Esc]:^Ұʺ޲zA [TAB]:\\A [][] :Bz"
        #define IS_QUIT_MSG  "O _ n  }   {  H"
    #else 
        #define PROMPT_MSG   "[Esc]:Quit, [TAB]:Menu, [][] :Process partition"
        #define IS_QUIT_MSG  "Are you sure to quit ?"
    #endif
 
    extern SeleMenu g_Menu;
    sword  lastkey, sele, err;
 
    g_Info.fd.use_fat32 = TRUE;                     /** ]wO_䴩 FAT 32 **/
    g_Info.fd.modified = 0;                                  /** mʺX **/
 
    err = Chg_Work_Disk(partnArr);                         /** ܤu@w **/
    if ( err & 0x40 )
        return(0);                                     /** iJΤu **/
    else if ( err & 0x80 )
        return(-1);                                        /** o͵w~ **/
       
    sele = 1;
    do
    {
        ShowMSG(PROMPT_MSG);
        Redraw_Fdisk_Picture(TRUE);
  
        /*===============================================================*/
        /*  HΤeA General_sele  禡 PartnMnu.C   */
        /*===============================================================*/
        sele = Sele_Partn(partnArr, 0, 0, General_sele);
        lastkey = g_Menu.lastKey();                  /** o̫U **/
  
        if ( sele > 0 )
            Fdisk_Menu(partnArr, sele);      /** γBz, in fd_menu.c **/
        else if ( sele < 0 )
        {
            if ( lastkey == TAB_KEY )            /** Tab , in fd_menu.c **/
                Fdisk_Tab_Menu(partnArr);
            else if ( lastkey == ESC_KEY )                 /** }ε{ **/
                if ( g_Info.fd.modified )
                {
                    err = Prompt_Save_Partn(partnArr);         /** O_xs **/
                    if ( err && !YN_box(TALK_BOX, IS_QUIT_MSG) )
                        lastkey = ENTER_KEY;                   /** } **/
                } /* end if */
        } /* end if */
    } while ( lastkey != ESC_KEY );
 
    return(0);
} /* end Fdisk */


/*============================= Reset FDisk =================================*/
void Init_Fdisk (void)
{                      
    g_Info.fd.ext_head    = -1;
    g_Info.fd.ext_end     = -1;
    g_Info.fd.modified      =  0;
    g_Info.fd.maxParNO    =  0;  
    g_Info.fd.used        =  0;       
    g_Info.fd.pri_use     =  0;    
    g_Info.fd.primary     =  0;
 /* g_Info.fd.use_fat32   =  0; */
    g_Info.fd.logic_exist = FALSE;
    g_Info.fd.canSaveFlag = TRUE;
    g_Info.fd.clr_screen  = TRUE;
} /* end Init_Fdisk */


/*============================= Reset FDisk =================================*/
void Reset_Fdisk (void)
{
    Init_Fdisk();
} /* end Reset_Fdisk */


/*===========================  l PARTN   =============================*/
void Init_Partn_Elem (PARTN *ptr)                  /* ptr mΤ */
{
    memset(ptr, 0, sizeof(PARTN));                             /** me **/
    ptr->sector = 1;                                           /** ҩlϰ **/
} /* end Init_Partn_Elem */


/*============================ ] w     ============================*/
void Set_Active_Partn (PARTN *partnArr, PARTN *ptr, sword bToggle)
{
    sword  i;
 
    if ( ptr->active != 0x80 )
    {
        ptr->active = 0x80;
        for ( i = 0 ; i < g_Info.fd.pri_use ; i++ )
            if ( &partnArr[i] != ptr )
                partnArr[i].active = 0;
    }
    else if ( bToggle )
        ptr->active = 0;
    else
        return;

    if ( g_Info.fd.modified == 0 )
        g_Info.fd.modified = -2;
} /* end Set_Active_Partn */


/*========================   O _   FAT 32 =========================*/
sword Set_Fat32_Support (void)
{
    Redraw_Fdisk_Picture(FALSE);
 
    #if ( DISPLAY == CHINESE )
        ShowCenter(11, "psإߪήeq ֡עۢ N]w FAT32 ɮרt");
        ShowCenter(14, "O Windows 95B NT  MS-DOS Τ@ǺϺФuN䴩Ӥ");
        return( Is_Yes("n   FAT32   t   H ") );
    #else
        ShowCenter(11, "If new partition capacity >= 512MB will use FAT32 file system");
        ShowCenter(14, "But earlier version of windows 95 or NT or MS-DOS will not support");
        return( Is_Yes("Do you wish to use FAT32 file system ? ") );
    #endif
} /* end Set_Fat32_Support */


/*========================   O _ x s  B z =======================*/
sword Prompt_Save_Partn (PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        #define PROMPT_SAVE_TO_HD    "O _ x s    G  w  H"
    #else 
        #define PROMPT_SAVE_TO_HD    "Do you want to save to hard disk ?"
    #endif

    sword  err = 1;
 
    if ( IsAllowSavePartn() )
    {
        Beep();
        
        if ( YN_box(IMMEDIATE_BOX, PROMPT_SAVE_TO_HD) )
        {
           err = Save_Partn(partnArr);
           Clr_Block(2, 3, 77, 20);
           if ( err == -1 )
               ShowError( 6 );                                /** gJѡI**/
        } /* end if */
    } /* end if */
 
    return( err );
} /* end Prompt_Save_Partn */


/*===========================   D e  ================================*/
static void Show_Diskpara (sword showFlag)
{
    #if ( DISPLAY == CHINESE )
        #define NUMBER_OF_HD_FMT   "wоơG%2d"
        #define CHS_FMT            "   ϬWG%5lu  YG%3lu  ϰϡG%3lu %24s"
        #define WORK_HD_MSG        "u@wСG "
        #define EXPERT_MSG         "Ma"
    #else 
        #define NUMBER_OF_HD_FMT   "Number of H.D:%2d"
        #define CHS_FMT            "   Cyl:%5lu  Head:%3lu  Sector:%3lu %22s"
        #define WORK_HD_MSG        "Work H.D: "
        #define EXPERT_MSG         "Expert"
    #endif  /* DISPLAY == CHINESE */
 
    c_textattr(DEFAULT_COLOR);
    c_printXY(3, 2, NUMBER_OF_HD_FMT, g_Info.nHD);
 
    if ( !showFlag )
        c_printf("%50c", ' ');
    else
    {
        c_printf(CHS_FMT, CUR_DK->lgeo.maxCyl + 1,   
                          CUR_DK->lgeo.maxHead + 1, 
                          CUR_DK->lgeo.maxSect, WORK_HD_MSG);
  
        c_textattr( (g_Info.fd.modified == 0) ? NO_UPDATE_COLOR : UPDATE_COLOR );
        c_printf("%2d ", CUR_DK->diskNO - 0x7f);
  
        #if ( DISPLAY != CHINESE )
            c_textattr(DEFAULT_COLOR);
            c_printf(" ");
        #endif
    } /* end if */
 
    c_gotoxy(56, 2);
    if ( g_Info.expertMode )
    {
        c_textattr(EXPERT_COLOR);
        c_printf(EXPERT_MSG);
        c_textattr(DEFAULT_COLOR);
    } /* end if */
} /* end Show_Diskpara */


/*===========================   D e  ================================*/
void Fdisk_Picture (sword showFlag)
{
    static sword line[] = { 3, 22, 0 };
 
    Square(1, 1, 80, 24, line);                                  /** e **/
    Show_Diskpara(showFlag);
 
    c_textattr(PMT_LINE_COLOR);
    #if ( DISPLAY == CHINESE )
        c_printXY(1, 25, " SPF w    {     ");
    #else 
        c_printXY(1, 25, "$ SPF Disk partition managememt menu");
    #endif

    c_textattr(DEFAULT_COLOR);

   #if ( DISPLAY == CHINESE )
      c_printXY(4, 23, "TCG");
   #else 
      c_printXY(4, 23, "Prompt: ");
   #endif
} /* end Fdisk_Picture */


/*===========================  ø D e  ================================*/
void Redraw_Fdisk_Picture (sword showFlag)
{
    Clr_Block(2, 3, 78, 20);
    Fdisk_Picture(showFlag);
} /* end Redraw_Fdisk_Picture */
