/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "undo.h"
#include "bootmgr.h"
#include "selemenu.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

struct InstPara
{
    DiskDT  *dk;                                         /** Ow˪Ϻ **/
    PARTN   *partnArr;
    PARTN   pos;
    sword   update;
};

/*========================= w˱Ұʺ޲z{֤ ============================*/
static sword Install_BMGR_Kernel (struct InstPara *inst)
{
    byte      FAR *pCode, FAR *pEndCode, FAR *pData;
    byte      buff[512];
    sword     nCodeSect, nDataSect, remainder, i, j;
    dword     instSect;
    KERL_LDR  *KerLDR;
 
    nCodeSect = GetBootCode_nSect();
    nDataSect = GetBootData_nSect();
 
    SetWorkingDisk(inst->dk);                      /** Nw˺г]u@Ϻ **/
    g_BootPara.instDisk = inst->dk->diskNO;
 
    inst->dk->drv->reset(inst->dk);                            /** mϺ **/
    instSect = GetStart(&inst->pos);                       /** oϰ **/
 
    /*----- ˬd@ӺϭyO_w SPF BootMGR -----*/
    if ( g_BootPara.instPartn == _MBR_ &&
         inst->dk->lgeo.maxSect < GetBootmgr_nSect() )
    {
        return(-2);                                                /**  **/
    } /* end if */
 
    /*-------------------------------------------+
    |   pGw˨ MBR hŪX MBRA              |
    |   pGw˨nСAhˬdO_Ϥ       |
    +-------------------------------------------*/
    if ( linear_ReadWDK(instSect, 1, buff) )
        return(-1);
 
#if 0
    /**  nܭ MBR **/
    if ( inst->pos.stCyl > 1023 && Update_MBR(0x80) )
        return(-1);
#endif
 
    /*---------------------------+
    |    J Loader wİ    |
    +---------------------------*/
    pCode = (byte FAR *)LOADER;
    for ( i = 0 ; i < 0x1a0 && pCode < (byte FAR *)LDR_END ; i++ )
        buff[i] = *pCode++;
 
    j = ( g_BootPara.instPartn == _MBR_ ) ? 0x1a0 : 0x200;
    for ( ; i < j ; i++ )
        buff[i] = 0;
 
    *(word *)&buff[510] = 0xaa55;
 
    /*-----------------------+
    |    J֤߬T    |
    +-----------------------*/
    KerLDR               = (KERL_LDR *)buff;
    g_BootPara.nCodeSect =
    KerLDR->nCodeSect    = nCodeSect;
    g_BootPara.nDataSect =
    KerLDR->nDataSect    = nDataSect;
    KerLDR->disk         = ( inst->dk->flag & HARD_DISK ) ? inst->dk->diskNO : 0;
    KerLDR->cyl          = (inst->pos.stCyl <= 0xFFFFUL) ? (word)inst->pos.stCyl : (word)0xFFFF;
    KerLDR->head         = (byte)inst->pos.side;
 
    KerLDR->sector       = (byte)inst->pos.sector + 1;
    KerLDR->begin        = ++instSect;
    g_BootPara.dataBegin = KerLDR->begin;                /** Ƭqҩlϰ **/
    g_BootPara.codeBegin = KerLDR->begin + nDataSect;    /** {qҩlϰ **/
 
    /*-------------------------------+
    |    w  Boot Manager Loader   |
    +-------------------------------*/
    if ( linear_WriteWDK(instSect - 1, 1, buff) )
        return(-1);
 
    /*---------------------------------------------------------+
    |   w Boot Manager Loader mWL 1023 ϬWh MBR  |
    |   H MBR ̪ code ҰʶWL 1023 ϬWH᪺{  |
    +---------------------------------------------------------*/
    if ( inst->pos.stCyl > 1023 && Update_MBR(GetHardDiskDT(1)) )
        return(-1);
 
    remainder = nCodeSect + nDataSect;
 
    /*-------------------------------------+
    |      w  Boot Manager   q     |
    +-------------------------------------*/
    pData = (byte FAR *)g_Magic_Str;
    for ( i = 0 ; i < nDataSect ; i++,  instSect++ )
    {
        for ( j = 0 ; j < 512 ; j += 4, pData += 4 )
            *(dword *)&buff[j] = *(dword FAR *)pData;
  
        c_printf("%04d\b\b\b\b", --remainder);
        if ( linear_WriteWDK(instSect, 1, buff) )
            return(-1);
    } /* end for */
    
    /*-------------------------------------+
    |      w  Boot Manager {  q     |
    +-------------------------------------*/
    pCode    = (byte FAR *)BootHead;
    pEndCode = (byte FAR *)End_of_BMGR;
 
    i = 0;
    while ( pCode < pEndCode )
    {
        for ( ; i < 512 && pCode < pEndCode ; i++, pCode++ )
            buff[i] = *pCode;
  
        if ( pCode == (byte FAR *)End_of_BMGR )
        {
            /** Link My INT 13h, implement in INT13.asm **/
            pCode    = (byte FAR *)MY_INT_13;
            pEndCode = (byte FAR *)END_INT13;
            if ( i < 512 )
                continue;
        }
        else if ( pCode == (byte FAR *)END_INT13 )
        {
            for ( ; i < 512 ; i++ )
               buff[i] = 0;
        } /* end if */
                         
        c_printf("%04d\b\b\b\b", --remainder);
        if ( linear_WriteWDK(instSect++, 1, buff) )
            return(-1);
        i = 0;
    } /* end while */
 
    return(0);
} /* end Install_BMGR_Kernel */


/*================ w˱Ұʺ޲z{{ǰtXإ Undo ɥ ===================*/
static sword Install_Process (void *pArg)
{
    struct InstPara *para = (struct InstPara *)pArg;

    if ( para->update && Write_Partn(para->partnArr, 0, 0) ) /** xsΪ **/
        return(-100);
    return( Install_BMGR_Kernel(para) );                       /** iw **/
} /* end Install_Process */


/*================== ˬdw˰ OEM ϰO_t LILO r ==================*/
static sword CheckLILO (sbyte *buff)
{
    sword  i;
    
    for ( i = 3 ; i < 8 ; i++ )
        if ( buff[i] == 'L' && buff[i+1] == 'I' && 
             buff[i+2] == 'L' && buff[i+3] == 'O' )
            return( TRUE );
    return( FALSE );
} /* end CheckLILO */


/*======================= ]wҰʺ޲z{w˰ ============================*/
void Install_Boot_Menu (BMGR *boot, PARTN *partnArr)
{
#if ( DISPLAY == CHINESE )
    #define WHICH_HD_INSTALL             " w     w  H"
    #define WHICH_FLOPPY_INSTALL         "w  b  X  n СH "
    #define WHICH_PARTN_INSTALL          "w       H"
    #define FLOPPY_WILL_DESTORY          "o i      N Q } a I\n T w n i  w  H"
    #define ARE_YOU_SURE_TO_INSTALL      "T w n i  w  H"
    #define INST_HD_PARTN_MSG            "%s@ %d wСA  %d Ӥ"
    #define INST_MBR_MSG                 "%s@Master Boot Record"
    #define INST_FLOPPY_MSG              "%s@ %d nо"
    #define INST_TO_FRONT_SPACE_MSG      "1) V e  K  "
    #define INST_TO_REAR_SPACE_MSG       "2) V   K  "
    #define INSTALLING_PLEASE_WAIT       " b i  w ˡA  y ԡDDD"
    #define INSTALL_DONE_MSG             "   z {  w    I"
    #define FOUND_LILO_MSG               "o{æ LILO {bw˰ϡA~ܡH"
 
    static  sbyte menuInstToBootSect[] = "1) wбҰʺϰ";
    static  sbyte menuInstToMBR[]      = "2) ۢТ";
    static  sbyte menuInstToFloppy[]   = "3) n";

    static  sbyte instStr[]            = " w   ";

#else
    #define WHICH_HD_INSTALL             "Which Hard disk do you want to install ?"
    #define WHICH_FLOPPY_INSTALL         "Which floppy do you want to install? "
    #define WHICH_PARTN_INSTALL          "Which partition do you want ?"
    #define FLOPPY_WILL_DESTORY          "This disk data will be destroyed !\nAre you sure to install now ?"
    #define ARE_YOU_SURE_TO_INSTALL      "Are you sure to install now ? "
    #define INST_HD_PARTN_MSG            "%s Hard disk: %d,  Partition: %d"
    #define INST_MBR_MSG                 "%s Master Boot Record"
    #define INST_FLOPPY_MSG              "%s Floppy disk %d"
    #define INST_TO_FRONT_SPACE_MSG      "1. Install to front"
    #define INST_TO_REAR_SPACE_MSG       "2. Install to rear"
    #define INSTALLING_PLEASE_WAIT       "It's install, please wait a moment....."
    #define INSTALL_DONE_MSG             "Install success, please reboot !"
    #define FOUND_LILO_MSG               "Found similar LILO in install area,\ndo you want to continue ?"
    
    static  sbyte menuInstToBootSect[] = "1. HD Boot Sector";
    static  sbyte menuInstToMBR[]      = "2. MBR";
    static  sbyte menuInstToFloppy[]   = "3. Floppy";

    static  sbyte instStr[]            = "Install to  ";
#endif /* end DISPLAY != CHINESE */

    sword  sele, disk, dir, par, err, i;
    dword  instSect, begin, end;
    dword  nFreeSect, nCyl;
    sbyte  *msgStr;
    PARTN  *ptr;
    struct InstPara  inst;
    extern SeleMenu  g_Menu;                               /** ο檫 **/
 
    ShowMSG(instStr);
 
    i = 27;
    g_Menu.prompt(i, 23, menuInstToBootSect, g_Info.nHD > 0);
    i += sizeof(menuInstToBootSect) + 3;
    g_Menu.prompt(i, 23, menuInstToMBR, g_Info.nHD > 0);
    i += sizeof(menuInstToMBR) + 3;
    g_Menu.prompt(i, 23, menuInstToFloppy, g_Info.nFP > 0);
 
    sele = g_Menu.select(1);                                   /** ο **/
    if ( sele < 1 )
        return;

    inst.partnArr = partnArr;                    /** ǤJܼ(Cݦsb) **/
    inst.update   = FALSE;
    err           = 0;
 
    /*-----------------------------------------+
    |              w   n             |
    +-----------------------------------------*/
    if ( (sele == 3) || (g_Info.nHD == 0) )
    {    
        ShowMSG(WHICH_FLOPPY_INSTALL);
        if ( InputWORD(&disk, 1, g_Info.nFP, 2, ALLOW_ESC) == ESC_KEY )
            return;
        msgStr    = INST_FLOPPY_MSG;                   /** w˦bnЪT **/
        par       = _FLOPPY_;
        inst.dk   = GetFloppyDT(disk);
        nFreeSect = (dword)inst.dk->lgeo.tnSector;
    }
    /*----------------------------------------+
    |              w   MBR             |
    +----------------------------------------*/
    else if ( sele == 2 )
    { 
        msgStr    = INST_MBR_MSG;                     /** w˦b MBR T **/
        par       = _MBR_;
        inst.dk   = GetHardDiskDT(1);
        nFreeSect = inst.dk->lgeo.maxSect - 1;
    }
    /*----------------------------------------+
    |       w   w           |
    +----------------------------------------*/
    else
    {
        msgStr = INST_HD_PARTN_MSG;                    /** w˦bΪT **/
        PushScreenBlock(54, 9, 77, 21);                    /** xsϰe **/
        g_Info.bm.clr_screen = TRUE;

        ShowMSG(WHICH_HD_INSTALL);

        /*
         *  ܦw˺
         */
        if ( (disk = Sele_HD(FALSE, 0)) < 0 )
        {
            GiveupScreenBlock();
            return;
        } /* end if */
                     
        /*
         *  oθT
         */
        inst.dk = GetHardDiskDT(disk);
        err = Get_Disk_Info(inst.dk, partnArr, TRUE);
        if ( err )
        {
            Disk_Err_Msg( err );
            GiveupScreenBlock();
            return;
        } /* end if */

        if ( !IsAllowSavePartn() )               /** pGO\xsA **/
        {
            GiveupScreenBlock();
            return;
        } /* end if */

        /*
         * MtmΩΪ̬Ot ID  0x20  0x0a 
         */
        ShowMSG(NULL);
        for ( i = 0 ; i < g_Info.fd.pri_use ; i++ )
            if ( (g_Info.fd.primary < 4) && (partnArr[i].no == 0) ||
                 (partnArr[i].id == 0x20) || (partnArr[i].id == 0x0a) )
                break;

        if ( i == g_Info.fd.pri_use )
        {
            ShowError( 14 );             /** w|ӥDΩΤwLŶiw **/
            GiveupScreenBlock();
            return;
        } /* end if */

        ShowMSG(WHICH_PARTN_INSTALL);

        /*
         *  ܤΡA ID20h_or_unused 禡 Partnmnu.C 
         */
        par = Sele_Partn(partnArr, 0, 0, ID20h_or_unused);
        if ( par < 1 )
        {
            GiveupScreenBlock();
            return;
        }
        else
            par--;

        ptr = &partnArr[par];
        nFreeSect = Get_nSector(ptr);
        
        if ( (ptr->stCyl == 0) && (ptr->side == 0) )
            nFreeSect -= (inst.dk->lgeo.maxSect - ptr->sector + 1);
    } /* end if */


    /*----------------------------------------+
    |    d O _       w    |
    +----------------------------------------*/
    if ( GetBootmgr_nSect() > nFreeSect )
    {
        ShowError(25);                                         /** Ŷ **/
        GiveupScreenBlock();
        return;
    } /* end if */

    if ( sele != 1 )                                      /** MBR or FLOPPY **/
    {
        g_BootPara.instPartn = par;                 /** par = MBR or FLOPPY **/
        inst.pos.side        = 0;
        inst.pos.stCyl       = 0;
        inst.pos.sector      = 1;
        inst.pos.id          = 0x20;            /** SPF Boot Manager SYS_ID **/
    }
    else
    {
        inst.update = TRUE;

        nCyl = GetBootmgr_nSect() / inst.dk->lgeo.sectPerCyl;
        if ( GetBootmgr_nSect() % inst.dk->lgeo.sectPerCyl )
            nCyl++;

        if ( ptr->id == 0 )
        {
            ShowMSG(NULL);
            if ( nCyl == GetNumCyl(ptr) )
            {
                begin = ptr->stCyl;
                end   = begin + nCyl - 1;
                dir   = 1;
            }
            else
            {
                MenuBox(26, 9, 52, 15, NULL);            /** øsΤ **/
 
                g_Menu.enableCtrl( M_LOCK );
                g_Menu.menuColor(PAR_MENU_COLOR, LIGHT_BAR_COLOR);
                g_Menu.prompt(30, 11, INST_TO_FRONT_SPACE_MSG, TRUE);
                g_Menu.prompt(30, 13, INST_TO_REAR_SPACE_MSG,  TRUE);
 
                dir = g_Menu.select(1);                        /** ο **/
                
                /*
                 * dir=1: VeK,  dir=2: VK
                 */
                if ( dir == 1 )
                {
                    begin = ptr->stCyl;
                    end   = begin + nCyl - 1;
                }
                else if ( dir == 2 )
                {
                    end   = ptr->endCyl;
                    begin = end - nCyl + 1;
                }
                else
                {
                    Cancel_Box();                              /**  **/
                    GiveupScreenBlock();
                    return;
                } /* end if */
   
                ShowMSG(NULL);
            } /* end if */

            /*-------------   D   -------------*/
            Create_Partn(partnArr, par, begin, end, PRIMARY_PARTN, 1);
            g_Info.fd.modified = 1;

            if ( dir == 2 )                              /** pGOVK **/
            {
                par++;
                ptr++;
            } /* end if */
        }
        else
        {
            g_Info.fd.modified = ( ptr->id == 0x0a ) ? -1 : -2;
        } /* end if */

        if ( !Is_Extended(ptr->id) )
            ptr->id = 0x20;                          /** SPF BMGR System ID **/

        Set_Active_Partn(partnArr, ptr, FALSE);              /** Set ACTIVE **/

        Boot_Menu_Picture( TRUE );                           /** ܥDe **/
        PopScreenBlock(54, 9, 77, 21);                     /** ^sϰe **/
        List_BootMenu_Rec(boot, g_BootPara.nBootREC);      /** sܸ **/

        g_BootPara.instPartn = ptr->no;
        inst.pos = *ptr;                                   /** Ow˦m **/
    } /* end if */
 
    ShowMSG(msgStr, instStr, disk, g_BootPara.instPartn);  /** ܦw˦m **/
 
    /* pGw˨wФW */
    if ( sele != 3 )
    {
        sbyte  buff[512];

        instSect = GetStart(&inst.pos);
        if ( linear_ReadWDK(instSect, 1, buff) == 0 )  /* Ūw˰ϭӺϰ */
        {
            buff[11] = 0;
            strupr(buff);
            if ( CheckLILO(buff) )                    /* ˬdO_w LILO */
               if ( !YN_box(WARNING_BOX, FOUND_LILO_MSG) )
               {
                   Cancel_Box();
                   return;
               } /* end if */
        } /* end if */

        if ( !YN_box(TALK_BOX, ARE_YOU_SURE_TO_INSTALL) ||
             PromptCreateUndoFile(Install_Process, &inst, TRUE) )   /* Undo file */
        {
            Cancel_Box();
            return;
        } /* end if */
    }
    /* pGw˨nФW */
    else if ( !YN_box(WARNING_BOX, FLOPPY_WILL_DESTORY) )
    {
        Cancel_Box();
        return;
    } /* end if */
 
    /*----------------------+
    |     w  {  q    |
    +----------------------*/
    ShowMSG(INSTALLING_PLEASE_WAIT);
    err = Install_Process(&inst);                      /** xsΪΦw **/

    ShowMSG(NULL);
    if ( err == -100 )                                   /** Ϊxs **/
        ShowError(6);
    else if ( err == -1 )                              /** Ұʵ{w˥ **/
        ShowError(7);
    else if ( err == -2 )                                /** CyϰϼƤ **/
        ShowError(25);
    else
        Prompt_Msg_Box(INSTALL_DONE_MSG, NULL);
} /* end Install_Boot_Menu */
