/*  Edit's Clipboard

*/

#include "dflat.h"

char *Clipboard;
unsigned ClipboardLength;

void CopyTextToClipboard(char *text)
{
    ClipboardLength = strlen(text);
    Clipboard = DFrealloc(Clipboard, ClipboardLength);
    memmove(Clipboard, text, ClipboardLength);

}

void CopyToClipboard(WINDOW wnd)
{
    if (TextBlockMarked(wnd))
        {
/*      char *bbl=TextLine(wnd,wnd->BlkBegLine)+wnd->BlkBegCol;
        char *bel=TextLine(wnd,wnd->BlkEndLine)+wnd->BlkEndCol;
*/
        char *bbl=TextBlockBegin(wnd);
        char *bel=TextBlockEnd(wnd);

        ClipboardLength=(unsigned) (bel-bbl);
        if (bbl>=bel)
            {
            ErrorMessage("Not copied to clipboard");
            return;
            }

        Clipboard = DFrealloc(Clipboard, ClipboardLength);
        memmove(Clipboard, bbl, ClipboardLength);
        }

}

void ClearClipboard(void)
{
    if (Clipboard != NULL)
        {
        free(Clipboard);
        Clipboard = NULL;
        }

}

BOOL PasteText(WINDOW wnd, char *SaveTo, unsigned len)
{
    if (cfg.read_only)
        {
        MessageBox("Edit", "You cannot modify a read only file");
        wnd->TextChanged=FALSE;
        return TRUE;
        }

    if (SaveTo != NULL && len > 0)
        {
        unsigned plen = strlen(wnd->text) + len;

        if (plen <= wnd->MaxTextLength)
            {
            if (plen+1 > wnd->textlen)
                {
                wnd->text = DFrealloc(wnd->text, plen+3);
                wnd->textlen = plen+1;
            }

            memmove(CurrChar+len, CurrChar, strlen(CurrChar)+1);
            memmove(CurrChar, SaveTo, len);
            BuildTextPointers(wnd);
            wnd->TextChanged = TRUE;
            return TRUE;
            }

        }

    return FALSE;

}
