#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<io.h>
#include<fcntl.h>
#include<DOS.h>

#define CF 1	/*Carry flag */
#define BYTE unsigned char

			/* action to be performed */
#define MA_Query    1   /* MODE detects a problem from DISPLAY.SYS */
#define MA_Prepare  2
#define MA_Select   3
#define MA_MODE   100   /* MODE detected a problem */


/*////////// V A R I A B L E S  ////////////////////////////////////*/


	unsigned int table[20];	 /* table to allocate current status of DISPLAY */


/*////////// F U N C T I O N S  ////////////////////////////////////*/


void deviceError ( BYTE action, BYTE errorcode )
{
	if (action==MA_Query)
	{
		switch (errorcode)	{
			case 26:  puts ("MODE: Active codepage was never set");
				    break;
			case 27:  puts ("MODE: Device read codepage error");
				    break;
			default:  puts ("MODE: Unknown error reading codepage");
		}
	}
	else if (action==MA_Prepare)
	{
		switch (errorcode)	{
			case 27:  puts ("MODE: Codepage was not found in CPI file");
				    break;
			case 29:  puts ("MODE: Error obtaining codepage information from file");
				    break;
			case 31:  puts ("MODE: specified CPI file is damaged or has errors");
				    break;
			default:  /* and case 29 (Aitor: unknwon error reason?) */
				    puts ("MODE: Unknown codepage prepare error");
		}
	}
	else if (action==MA_Select)
	{
		switch (errorcode)	{
			case 26:  puts ("MODE: Specified codepage was not");
				    break;
			case 27:  puts ("MODE: KEYB failed to change codepage");
				    break;
			case 31:  puts ("MODE: Device select codepage error");
				    break;
			default:  puts ("MODE: Unknown select prepare error");
		}
	}
	else if (action==MA_MODE)
	{
		switch (errorcode)	{
			case 100:  puts ("MODE: INTERNAL ERROR: size for prepared table too small");
				     break;
			case 101:  puts ("MODE: Non-compatible driver in use");
				     break;
			case 102:  puts ("MODE: File not found");
				     break;
			case 103:  puts ("MODE: Error specifying the codepage and buffer");
				     break;
			case 104:  puts ("MODE: Error: buffer selected not present");
				     break;
			default:   puts ("MODE: Unknown MODE error");
		}
	}
	else puts ("MODE: Unknown agent error");

	exit (errorcode);
}


unsigned int GetCodepage ( void )
{
	unsigned int cp;

	asm {  MOV AX, 0xAD02
		 INT 0x2F
		 MOV cp, BX
	}

	return cp;
}


void FillTableData ( void )
{
	unsigned int s,o;
	unsigned char i;

	for (i=0; i<20; i++) table[i]=0;

	s = FP_SEG (table);
	o = FP_OFF (table);
	asm {	MOV AX, 0xAD03
		MOV CX, 25
		MOV ES, s
		MOV DI, o
		INT 0x2F
		PUSHF
		POP AX
		MOV i,AL
		}
	if (i & CF)
		deviceError (MA_MODE, 100);
	if (! (table[2] | table[0]) )
		deviceError (MA_Query, 27);
}


unsigned int ShowStatus ( void )
{
	unsigned int cp=0;
	unsigned char i;

	puts   ("Status for device CON:");
	puts   ("======================");
	puts   ("");

	cp = GetCodepage();
	if (cp != 0xFFFF)
		printf ("Active codepage for device CON is %u\n", cp);
	else
		puts   ("Active codepage was never set");

	FillTableData ();
	printf ("\n\nNumber of subfonts: %u\n",table[1]);
	printf ("Hardware codepages: ");
	for (i=1;i<=table[2];i++)
	{
	   printf ("%u",table[2+i]);
	   if (i<table[2]) printf(", ");
	}
	printf ("\nPrepared codepages: ");
	for (i=1;i<=table[0];i++)
	{
	   printf ("%u",table[2+i+table[2]]);
	   if (i<table[0]) printf(", ");
	}
	puts   ("\n\nMODE status code page function completed");
	return (cp);
}



unsigned int CodepageSelect ( unsigned int cp )
{
	unsigned int success;

	asm { MOV AX, 0xAD01
		MOV BX, cp
		INT 0x2F
		MOV success, AX
	}
	if (success)
		printf ("MODE select codepage %u function completed\n", cp);
	else  {
		printf ("MODE: unable to select codepage %u\n", cp);
		asm { MOV AX, 0xAD05
			XOR BX,BX
			INT 0x2F
			MOV success, BX
		}
		deviceError (MA_Select, success);
	}
	return (success);
}



unsigned int CheckFDDisplayVer ( void )
{
	unsigned char Rah;
	unsigned int  Rbx;

	asm { MOV AX, 0xAD00
		INT 0x2F
		MOV Rah, AH
		MOV Rbx, BX
	}
	return ( (Rah==0xFF) && (Rbx==0x0009) );
						/* version 0.09 only! */
}


unsigned int  ReadNumber (char *line, unsigned int *lineptr )
{
	char     cvtstr[8];
	unsigned int i=0;

	while ( (line[*lineptr]>='0') && (line[*lineptr]<='9'))
		cvtstr[i++] = line[(*lineptr)++];
	cvtstr[i] = 0;

	return (  (unsigned int) (atoi (cvtstr)) );
}



/* returns buffer to fill, starts on 0 */
unsigned int GetPosition (char *s, unsigned int *cp)
{
	unsigned int pos = 0;
	unsigned int i = 1;

	if (s[0] != '(')
                deviceError (MA_MODE, 103);

	while (s[i]==',')
	{	pos++;  i++; }

	*cp = ReadNumber (s, &i);

	while (s[i]==',') i++;


	if (s[i++] != ')')
		deviceError (MA_MODE, 101);

	if (s[i])
		deviceError (MA_MODE, 102);

	return pos;
}



unsigned int CodepagePrepare (char *bufferpos, char *filename)
{
	int cpf;
	unsigned int  cp, pos;
	unsigned char buf[9728];
	unsigned int  s,o,f;

	/** Determine that it is FreeDOS DISPLAY **/
	if (!CheckFDDisplayVer())
		deviceError (MA_MODE, 101);

	/** Parse the number and position **/
	pos = GetPosition (bufferpos, &cp);

	FillTableData ();

	if (pos > table[0] )
		deviceError (MA_MODE, 104);

	/** Check that the file exists **/
	if ((cpf = open(filename, O_RDONLY | O_BINARY)) == -1)
		deviceError (MA_MODE, 102);

	/** Check that the file has the correct size **/
	if ( filelength(cpf) != 9728)  /*  9728=256*(8+14+16)  */
		deviceError (MA_Prepare, 31);

	/** Read the buffer **/
	if ( read(cpf, buf, 9728) != 9728 )
		deviceError (MA_Prepare, 29);

	/** Send the buffer **/
	s = FP_SEG(buf);
	o = FP_OFF(buf);
	asm {   MOV AX, 0xAD0E
		  MOV BX, cp
		  MOV DX, pos
		  MOV DS, s
		  MOV SI, o
		  INT 0x2F
		  PUSHF
		  POP AX
		  MOV f, AX
	}

	/** Check the result **/
	if ( f & CF )
	{
		printf ("MODE: Error when preparing codepage %u\n", cp);
		asm { MOV AX, 0xAD05
			XOR BX,BX
			INT 0x2F
			MOV cpf, BX
		}
		deviceError (MA_Prepare, cpf);
	}

		printf ("MODE prepare codepage %u function completed\n", cp);

}



#define NoAction    		0
#define ShowStatusCodepage 	1
#define SetCodepage 		2
#define PrepareCodepage 	3
#define FastHelp			4
#define RefreshCodepage		5
#define SyntaxError	     10
#define CPSyntaxError	     11


int main (int argc, char *argv[])
{

	unsigned char action = NoAction;
	unsigned int  codpn  = 0;

	puts ("FreeDOS MODECON 0.09\n");

	action = SyntaxError;

	switch (argc)
	{
		case 2:
		   if ( !strcmp (argv[1], "/?") )	/* check FastHelp /? */
		   {
			action = FastHelp;
			break;
		   }

		case 3: case 4: case 5:

		   /*** First param should always be CODEPAGE ***/
		   strupr (argv[1]);
		   if ( strcmp (argv[1], "CODEPAGE") && strcmp (argv[1], "CP"))
		   {
			action = SyntaxError;
			break;
		   }
		   if (argc==2)
		   {
			action = ShowStatusCodepage;
			break;
		   }
		   if (argc==3)
		   {
			if ( !strcmp(strupr(argv[2]),"REFRESH"))
			{
				codpn = GetCodepage();
				if (codpn == 0xFFFF)
				{
					puts ("MODE: Active codepage was never set");
					exit (0);
				}
			}
			action = RefreshCodepage;
			break;
		   }

		   /*** If 3 or 4 parameters, should be either PREPARE or SELECT ***/
		   strupr (argv[2]);
		   if ( !strcmp (argv[2], "SELECT") || !strcmp (argv[2], "SEL"))
		   {
			codpn = atoi (argv[3]);
			if  ( codpn )
				action = SetCodepage;
			break;
		   }
		   if ( argc==4 )
		   {
			action = SyntaxError;
			break;
		   }

		   if ( !strcmp (argv[2], "PREPARE") || !strcmp (argv[2], "PREP"))
			action = PrepareCodepage;
	}

	switch (action)
	{
			case ShowStatusCodepage:
			   ShowStatus ();
			   break;
			case RefreshCodepage:
			case SetCodepage:
			   CodepageSelect (codpn);
			   break;
			case PrepareCodepage:
			   CodepagePrepare (argv[3], argv[4]);
			   break;
			case FastHelp:
			   puts ("MODECON  CODEPAGE ");
			   puts ("MODECON  CODEPAGE  SELECT  n");
			   puts ("MODECON  CODEPAGE  PREPARE b filename");
			   puts ("MODECON  CODEPAGE  REFRESH");
			   puts ("MODECON   /?\n");
			   puts ("Interfaces codepage management with FreeDOS DISPLAY 0.06..0.08 driver");
			   puts ("CODEPAGE                     Shows currently active codepage");
			   puts ("CODEPAGE PREPARE b filename  Prepares codepage buffer, see below");
			   puts ("CODEPAGE REFRESH             Refreshes current codepage");
			   puts ("CODEPAGE SELECT n            Sets (previously prepared) codepage n");
			   puts (" 				         as active codepage");
			   puts ("REMARKS");
			   puts ("- CODEPAGE may be abbreviated by CP");
			   puts ("- PREPARE may be abbreviated by PREP");
			   puts ("- SELECT may be abbreviated by SP");
			   puts ("- Codepages should be prepared before they can be selected");
			   puts ("- To prepare a buffer, set the number in brackets, with commas to");
			   puts ("  indicate the buffer position. E.g.  (,,866) prepares cp866 in the");
			   puts ("  third buffer (only ONE buffer at a time)");
			   break;
			case SyntaxError:
			   puts ("MODECON: Syntax error");
			   puts ("Please, check  MODECON /?  for further information");
			   return (-1);
			case CPSyntaxError:
			   puts ("MODECON: Invalid codepage number.");
			   return (-1);
			default:
			   puts ("MODECON: Internal error");
			   puts ("Please, report commandline to aitor.sm@wanadoo.es");
			   return (-1);
	}
}
