
;   FreeDOS DISPLAY.COM v0.08
;
;   ===================================================================
;
;   FreeDOS driver for loading EGA/VGA/SVGA character generator
;   to bring national language support to different screen modes
;
;   Copyright (C) 9 Aug 2000 Ilya V. Vasilyev aka AtH//UgF@hMoscow
;   e-mail: hscool@netclub.ru
;
;   Copyright (C) 27 Aug 2002-03 Aitor Santamara_Merino
;   email:  aitor.sm@wanadoo.es
;
;   WWW:    http://www.freedos.org/
;
;   ===================================================================
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;   ===================================================================
;
;   Limitations:
;   - EGA and VGA monitors  (VESA working (?))
;   - commandline tool (no device driver, no IOCTL yet)
;   - to be used with supplied MODECON.EXE only
;   - parses RAW files only (no CPI files)
;   - does not query KEYB before selecting a new codepage
;   - does not admit "check hardware type" by commandline
;   - does not support subfonts
;
;
;               .       .       .       .       .       line that rules

;%define DEBUG

;===================================================================
; CONSTANTS
;
; Video mode constants

NO              EQU      0      ; ???
MDA             EQU      2      ; Not supported
HGA             EQU      4      ; Currently not supported
CGA             EQU      6      ; Not supported
EGA             EQU      8
MCGA            EQU     10      ; Supported ?
VGA             EQU     12
VESA            EQU     14      ; Currently not detected

; Other constants

CommandLine_Offset      EQU     080h    ; where in PSP is commandline
CPTableSize             EQU     9732    ; Size (for the format, see data)
Version                 EQU     0008H   ; Version of the driver

;===================================================================
; PROGRAM HEADER
;
; COM file interface (present)

                ORG     100H

                jmp      NEAR Install     ; simply go to Install

; Driver interface   (future)
;
;                DB      -1
;                DW      8000H           ; Attributes
;                DW      Strategy-100H
;                DW      Init-100H
DevName          DB      "        "      ; Device name
;dRequest:       DD      ?


;===================================================================
; INTERRUPT ROUTINE FOR 10h (video adapter interrup)
;
; ah=00h   (set video mode) 
;          reload the font after changing the video mode
; ax=4f02h (set superVGA mode)
;          reload the font after changing the video mode
; ah=11h   (character generation functions)
;          al= 30h: get info about tables
;          al= 1h, 2h, 4h, 11h, 12h, 14h: load fonts in text mode
;          al= 22h, 23h, 24h: load fonts in graphics mode
;
;               .       .       .       .       .       line that rules

                ;************** check if active

New10:          push    ax              
                mov     ax,[cs:wCPselected]
                cmp     ax,[cs:wCPhard]  ; check if selected=HW codepage.
                pop     ax
                je      jOld10           ; in that case, switch to old handler


                ;************** check if ah=00h and flgOur is clear

                or      ah,ah
                jnz     i10n0
                cmp     ah,[cs:flgOur]  ; VESA switching can call i10Fn0
                jnz     jnzOld10        ; ah=00h BUT flgOur set, so chain to next int10h

                ;************** AH=00h and flgOur clear: call old, then load fonts
                ; Here we fix Classic Video BIOS Fn 00: Set Screen Modee

                push    ax
                pushf
                call    FAR [cs:dOld10]
                pop     ax              ; Do not assume i10Fn0 saved AL

                push    ax
                and     al,7fH          ; High bit means save video memory
iSFpr:          push    cx              ; preconditions for SetFont
                push    ds
                push    es
                push    di
                push    cs
                pop     es
                call    SetFont         ; everything ready, call setfont
                pop     di              ; undo it!
                pop     es
                pop     ds
                pop     cx

                pop     ax
                iret

                ;************** AH <> 00h
                ;************** check if ah=4f02h (set VESA SuperVGA mode)
i10n0:
                cmp     ax,4f02H        ; VESA SET MODE
                jnz     i10nVESA

                inc     BYTE [cs:flgOur]; prevent our processing the call
                pushf
                call    FAR  [cs:dOld10]
                dec     BYTE [cs:flgOur]
                push    ax
                mov     al,-1           ; Call SetFont with Unknown video mode
                jmp     SHORT iSFpr     ; (mode determined dinamically)

                ;************** AH <> 00h, 4f02h
                ;************** All other business is with character generator functions (ah=11h)
i10nVESA:
                cmp     ah,11H          ; ah=11h?
jnzOld10:       jnz     jOld10          ; no, then jump to next

                cmp     al,30H          ; Get Font Information?
                jnz     i10f11n30

                ;************** AL = 30h (Get Font Information), BH: font info to be supplied

                ;************** unsupported cases: bh=5, bh>6, bh=6 on NON-VGA

                cmp     bh,5            ; Font 9x14 not supported (now?)
                jz      jOld10
                cmp     bh,6
                ja      jOld10          ; Font 9x16 not supported (now?)
                jb      i10f1130n6
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA

                ;************** supported cases: bh<5, VGA-bh=6
i10f1130n6:
                sub     cx,cx           ; CH register must be zero on exit
                mov     es,cx
                mov     dl,[es:484H]    ; Number of lines - 1
                mov     cl,[es:485H]    ; Bytes per char
                cmp     bh,1
                ja      i10f1130a1
                jz      i10f1130s1
                les     bp,[es:7cH]     ; SubFn 00: Return vector 1FH
                iret
i10f1130s1:
                les     bp,[es:43H*4]   ; SubFn 01: Return vector 43H
                iret
i10f1130a1:
                push    cs              ; All other functions return fonts
                pop     es              ;   from DISPLAY.SYS segment
                cmp     bh,3
                ja      i10f1130a3
                jz      i10f1130f3
                mov     bp,bFont8x14    ; SubFn 02: Return ROM font 8x14
                iret
i10f1130f3:
                mov     bp,bFont8x8     ; SubFn 03: Return ROM font 8x8 (00..7f)
                iret
i10f1130a3:
                cmp     bh,6
                jz      i10f1130s6
                mov     bp,bFont8x8+1024; SubFn 04: Return ROM font 8x8 (80..ff)
                iret
i10f1130s6:
                mov     bp,bFont8x16    ; SubFn 06: Return ROM font 8x16
                iret

                ;************** subfunctions AL= 01/11, 02/12 and (VGA+) 04/14

i10f11n30:
                cmp     al,01           ; SubFn 01: Set ROM font 8x14
                jz      i10f1101
                cmp     al,11H          ; SubFn 11: Set ROM font 8x14
                jnz     i10f11n11
i10f1101:
                push    bp
                push    bx
                mov     bp,bFont8x14
                mov     bh,14
i10set:         push    es              ; set a font, by calling ax=1110h, bh=bytes/char
                push    ax
                push    cx
                push    dx
                push    cs
                pop     es
                mov     cx,256          ; load 256 characters
                cwd                     ; DX=0
                and     al,10H
                pushf
                call    FAR [cs:dOld10]
                pop     dx
                pop     cx
                pop     ax
                pop     es
                pop     bx
                pop     bp
                iret
jOld10:         DB      0eaH
dOld10:         DD      -16
i10f11n11:
                cmp     al,02           ; SubFn 02: Set ROM font 8x8
                jz      i10f1102
                cmp     al,12H          ; SubFn 12: Set ROM font 8x8
                jnz     i10f11n12
i10f1102:
                push    bp
                push    bx
                mov     bp,bFont8x8
                mov     bh,8
                jmp     i10set
i10f11n12:
                cmp     al,04           ; SubFn 04: Set ROM font 8x16
                jz      i10f1104
                cmp     al,14H          ; SubFn 14: Set ROM font 8x16
                jnz     i10f11n14
i10f1104:
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
                push    bp
                push    bx
                mov     bp,bFont8x16
                mov     bh,16
                jmp     i10set

                ;************** subfunctions AL= 22, 23 and (VGA+) 24

i10f11n14:
                cmp     al,22H          ; SubFn 22: Set ROM font 8x14 (INT 43)
                jnz     i10f11n22
                push    bp
                push    cx
                mov     bp,bFont8x14
                mov     cx,14
i10setg:        push    es
                push    ax
                push    cs
                pop     es
                mov     ax,1121H
                pushf
                call    FAR [cs:dOld10]
                pop     ax
                pop     es
                pop     cx
                pop     bp
                iret

i10f11n22:
                cmp     al,23H          ; SubFn 23: Set ROM font 8x8 (INT 43)
                jnz     i10f11n23
                push    bp
                push    cx
                mov     bp,bFont8x8
                mov     cx,8
                jmp     i10setg

i10f11n23:
                cmp     al,24H          ; SubFn 24: Set ROM font 8x16 (INT 43)
                jnz     jOld10
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
                push    bp
                push    cx
                mov     bp,bFont8x16
                mov     cx,16
                jmp     i10setg

;===================================================================
; INTERRUPT ROUTINE FOR 2Fh (DOS Multiplexer)
;
; MuX CODE:  0adH
;
; 00: Installation check (return al non-zero)
; 01: Set Active Codepage (IN: bx=requested codepage)
; 02: Get Active Codepage (OUT: bx=active codepage)
; 0E: Set Codepage information  (IN: DS:SI->buffer)
; 0F: Get codepage information  (IN: ES:DI->buffer)
;
; Note: DISPLAY may not save information about 8x16 font on EGA,
;       so don't expect to get 8x16 font from EGA via Fn 0F
;
;        .      .       .       .       .       .       line that rules

                ;************** check first MUX code for DISPLAY: ADh

New2f:          pushf                   ; we must preserve flags!
                cmp     ah,0adH         ; ADh is MUX code for DISPLAY and KEYB
                jnz     jOld2f

                ;************** function 00h: Installation check

                test    al,0ffH
                jnz     mDno0

                mov     ah,0ffH         ; required for MS-DISPLAY compatibility
                mov     bx, Version     ; return version in BX (major.minor)
                                        ; bh=0 will stand for the beta versions of
                                        ; FreeDOS DISPLAY

%ifdef DEBUG
                mov     cx, 08888H      ; FD-DISPLAY DEBUG version signature
%endif
                popf
                clc                     ; clear carry
                retf    2

                ;************** function 01h: Set active codepage

mDno0:          cmp     al,01
                jnz     mDno1

                call    SelectCodepage   ; returns success on AX

                test    ax, 0ffh
                jz      retSet

retClear:       popf                    ; restore flags,
                clc                     ; clear carry (success)
                retf    2               ; and return, discarding flags
retSet:         popf
                stc                     ; set carry: error
                retf    2


                ;************** function 02h: Get active codepage

mDno1:          cmp     al,02
                jnz     mDno2           ; we return the active codepage

                mov     bx, [cs:wCPselected]

                cmp     bx, -1          ; if it was never set,
                jne     retClear        ; then we have to
                mov     ax, 0001h       ; set ax to 1 (see RBIL)
                jmp     retSet


                ;************** function 0Eh: Set codepage table (from DS:SI)

mDno2:
%ifdef DEBUG
                cmp     al,03           ; DEBUG routine3: return INFO
                jne     mDno2n

                push    cs              ; ES:DI-> CPHard
                pop     es
                mov     di,wCPhard
                jmp     retClear
mDno2n:
%endif
                cmp     al,0eh
                jnz     jOld2f

                call    PrepareCodepage
                jmp     retClear

                ;************** jump to next multiplex handler

jOld2f:         popf
                DB      0eaH
dOld2f:         DD      -16


;-------------------------------------------------------
; DRIVER INTERFACE
;
;               .       .       .       .       .       line that rules
;Strategy:
;                mov     [cs:dRequest-100H],bx
;                mov     [cs:dRequest+2-100H],es
;                ret
;
;Init:           push    ds
;                push    bx
;                lds     bx,[cs:dRequest-100H]
;                test    BYTE [cs:flgInstalled-100H],-1
;                jz      iExit
;                cmp     BYTE [bx+2],0
;                jz      InitFn0
;iExit:
;                mov     WORD [bx+3],8003H
;                pop     bx
;                pop     ds
;                retf
;
; .SYS initilization code goes here
;
;InitFn0:
;                push    ds                      ; Save Request
;                push    bx
;
;                mov     ax,cs
;                push    ax
;                call    _Install
;
;                pop     bx
;                pop     ds                      ; Restore Request
;                mov     ax,[cs:pMemTop-100H]
;                mov     WORD [bx+14],ax
;                mov     WORD [bx+16],cs
;                mov     WORD [bx+3],0100H       ; Status "Operation Complete"
;                pop     bx
;                pop     ds
;                retf
;_Install
;                sub     ax,10H
;                push    ax
;                mov     ax,DoInstall
;                push    ax
;                retf


;-------------------------------------------------------
; RESIDENT SUBROUTINES
;
;       .       .       .       .       .       .       line that rules

; Fn:   SModeTest
; Does: Determines wether text mode or graphic mode is enabled
; In:   nothing
; Out:  Carry set if graphic mode is set
;
;               (EGA/VGA only!)


SModeTest:
                push    ax
                mov     al,6
                push    dx
                mov     dx,3ceH
                out     dx,al
                call    sfr             ; Small delay
                inc     dx
                in      al,dx           ; Graph Controller Misc Register
                pop     dx
                shr     al,1
                pop     ax
sfr:            ret


; Fn:   SetFont
; Does: Set a proper localized font for a given video mode
; In:   AL Screen mode (-1 if unknown)
; Mod:  (none)
;
; Summary: self-determine rows per character, then call the load-character-table
;          function, which is int10h: AX=1100h (for text mode),
;          AX=1121h (for graphics mode)
;
; PRECONDITIONS (IMPORTANT):   (optimization due to problems with stack limit!)
;  
;    AX, CX, DS, ES, DI  saved (will be destroyed!)
;    ES == CS              (must have changed already!)

SetFont:
;                push    ds
;                push    es
;                push    ax			; Can't use PUSHA -- 8086/88
;                push    cx			; compatibility required.  This
                push    dx			; saves 2 bytes of stack. ;-)
                push    bx
                push    si
;                push    di
                push    bp


                ;************ initialise DX to number of lines (rows)
		;             in the screen

                sub     bx,bx                   ; BL: Zero!
                mov     ds,bx
                mov     dx,[484H]
                mov     bh,dh                   ; BH: bytes per character
                inc     dx                      ; DL: number of lines

                ;************ restore int1Fh vector with pointer to 8x8 table

                mov     WORD [7cH],bFont8x8+1024; Kinda tradition to restore
                mov     [7eH],cs                ; vector 1fH every time

                ;************ ES <- CS

;                push    cs
;                pop     es

                ;************ determine the table to be installed (the number
		;             of rows)

                cmp     BYTE [cs:bAdapter],VGA  ; if VGA (or better) or BH>=16,
                jb      sfNo8x16		; then 8x16
                cmp     bh,16
                jb      sfNo8x16
                mov     bh,16                   ; force bh=16 (in case it's >16)
                mov     bp,bFont8x16
                jmp     SHORT sfSetIt
sfNo8x16:
                cmp     bh,14                   ; check bh>=14
                jb      sfNo8x14
                mov     bh,14                   ; force bh=14 (in case it's >14)
                mov     bp,bFont8x14
                jmp     SHORT sfSetIt
sfNo8x14:
                cmp     bh,8                    ; check bh>=8  If below 8,
                jb      sfpr                    ; then unsupported ->RETURN
                mov     bh,8                    ; force bh=8 (in case it's >8)
                mov     bp,bFont8x8

                ;************ We have checked the number of rows, then set it
sfSetIt:
                cmp     al,13H
                ja      sfTest          ; Screen modes above 13H are unknown
                cmp     al,0dH
                jae     sfGraph         ; Screen modes 0d..13H   are graphics
                cmp     al,4
                jb      sfText          ; Screen modes  0..3     are text
                cmp     al,7
                jz      sfText          ; Screen mode    7       is  text
                jb      sfGraph         ; Screen modes  4..6     are graphics

                ;************ unknown, test if text/graphics mode
sfTest:         call    SModeTest
                jc      sfGraph

                ;************ set the font for text mode: use int10h / ax=1100h
sfText:
                mov     cx,256          ; Load 256 characters
                mov     ax,1100H        ; Load user font, reprogram controller
                cwd                     ; DX=0, BL is already zero, BH=bpc
                jmp     SHORT sfi10

                ;************ set the font for graphics mode:
		;             use int10h / ax=1121h
sfGraph:
                mov     cl,bh           ; bytes per character
                sub     ch,ch           ; BL is already zero, DL=# of lines
                mov     ax,1121H        ; Set vector 43H for user font

                ;************ call the appropriate interrupt function
sfi10:          pushf
                call    FAR [cs:dOld10]

                ;************ end of interrupt
sfpr:
                pop     bp
;                pop     di
                pop     si
                pop     bx
                pop     dx
;                pop     cx
;                pop     ax
;                pop     es
;                pop     ds
                ret


; Fn:   FindCodepage
; Does: Finds a codepage in the prepared array
; In:   BX=new codepage
; Out:  DI=0 if not found, the near ptr otherwise
;
; NOTES: it ages the array in one

FindCodepage:
                push    ax
                push    cx
                push    si

                mov     si,wCPhard      ; initial conditions
                xor     cx,cx
                mov     di,cx
                mov     cl,[cs:bCPMaxArray]
                inc     cl              ; count the hardware pool too!

loop3:
                mov     ax,[cs:si]      ; get codepage and
                cmp     ax,bx           ; compare
                jne     NoMatch
                mov     di,si           ; if we match, store at di
NoMatch:        add     si, CPTableSize ; add the table size to SI
                inc     WORD [cs:si+2]  ; AGE
                loop    loop3           ; loop even if found, because
                                        ; we need to age all

                cmp     di,wCPhard      ; if it's hardware, end call
                je      FindCodepageEnd
                test    di,0ffh         ; if we found it, then annihilate
                jz      FindCodepageEnd ; it's age
                mov     [cs:di+2], cx   ; remember: CX=0

FindCodepageEnd:
                pop     si
                pop     cx
                pop     ax

                ret

; Fn:   old10call
; Does: clears BX and calls the old driver
; In:   AX = some function of the old 10handler
; Out:  results of the call

old10call:      xor     bx, bx
                pushf
                call    FAR [cs:dOld10]
                ret


; Fn:   SetHWCodepage
; Does: Sets the hardware codepage, helped by the old int 10h handler
; In:   -
; Out:  -

SetHWCodepage:

                push    ax
                push    bx

                call    SModeTest
                jc      RestoreGraph

                mov     ax, 1101h       ; text mode calls
                call    old10call
                mov     ax, 1102h
                call    old10call
                mov     ax, 1104h
                call    old10call
                jmp     SetHWCodepageEnd

RestoreGraph:                           ; graphics mode calls
                mov     ax, 1122h
                call    old10call
                mov     ax, 1123h
                call    old10call
                mov     ax, 1124h
                call    old10call

SetHWCodepageEnd:
                pop     bx
                pop     ax

                ret

                
; Fn:   SelectCodepage
; Does: Selects a codepage from the pool
; In:   BX=new codepage
; Out:  AX=0 if not found
;
; NOTES: it ages the array in one

SelectCodepage: push    di

;                cmp     bx,0ffffh
;                je      SelectCodepageError
                test    bx,0ffffh
                jz      SelectCodepageError
                cmp     bx, [cs:wCPselected]
                je      SelectCodepageEnd2

                call    FindCodepage    ; se if we find it
                test    di, 0ffh
                jnz     CPFound

SelectCodepageError:
                xor     ax, ax
                pop     di              ; we couldn't find it:
                ret

                ;************ move the data as appropriate

CPFound:
                mov     ax,[cs:di]
                mov     [cs:wCPselected],ax

                push    cx
                push    es
                push    ds

                push    cs              ; source at ds:si
                pop     ds

                mov     ax,di
                add     ax,4            ; add offset of where data starts
                mov     si,ax

                push    cs              ; target at es:di
                pop     es

                mov     di,bFont8x8

                cld			; for crazy callers
                mov     cx,[cs:WTableSize]
           rep  movsw

                ;************ set the font

                mov     ax,[cs:wCPselected]
                cmp     ax,[cs:wCPhard]
                jne     SetOurFont
                call    SetHWCodepage
                jmp     SelectCodepageEnd

SetOurFont:
                call    SetFont         ; we are already in preconditions!


SelectCodepageEnd:
                pop     ds
                pop     es
                pop     cx

SelectCodepageEnd2:
                pop     di
                mov     ax, 0001h
                ret
                

; Fn:   FindOldestCodepage
; Does: Finds the oldest codepage in the table
; Out:  DI: near ptr to the oldest
;
; NOTES: it ages the array in one
;

FindOldestCodepage:
                push    ax
                push    bx
                push    cx
                push    si

                mov     cx,wCPhard      ; initial conditions
                add     cx,CPTableSize
                mov     si,cx           ; we start in the first
                mov     di,si           ; offset of the oldest age
                mov     bx,[cs:si+2]    ; BX: oldest age found
                xor     cx,cx           ; CX will be the counter
                mov     cl,[cs:bCPMaxArray]

loop4:
                mov     ax,[cs:si+2]    ; get AGE and
                cmp     ax,bx           ; compare
                jle     NoMatch2
                mov     di, si          ; if it is older, get its address
                mov     bx,[cs:si+2]    ; and its age
NoMatch2:       inc     WORD [cs:si+2]  ; AGE
                add     si,CPTableSize  ; add the table size
                loop    loop4

                mov     [cs:di+2], cx   ; remember we had CX=0

                pop     si
                pop     cx
                pop     bx
                pop     ax

                ret

; Fn:   PrepareCodepage
; Does: Prepares the codepage in the oldest pool
; In:   BX:      codepage number
;       DS:SI->  RAW table to be copied from
; Out:  DI=0 if not found, the near ptr otherwise
;

PrepareCodepage:
                push ax
                push cx
                push es
                push di

                call FindOldestCodepage ; set ES:DI to the begining of the
                push cs                 ; begining of the oldest
                pop  es                 ; codepage table

                mov  [es:di],bx         ; store the codepage
                mov  ax,di
                add  ax,4               ; move to the begining of the RAW table
                mov  di,ax

		cld			; for crazy callers
                mov     cx,[cs:WTableSize]
           rep  movsw

                pop  di
                pop  es
                pop  cx
                pop  ax

                ret


;===================================================================
; DISPLAY DATA SEGMENT
;               .       .       .       .       .       line that rules
;
; Internal variables
;

bAdapter        DB      0               ; Adapter type
flgOur          DB      0               ; Our INT 10 Fn 00?
WTableSize	DW	4864		; Total RAW table size: 128*(8+14+16) WORDs
bCPMaxArray     DB      1               ; by default we have 2 pools

;===================================================================
; DISPLAY DATA POOLS
;               .       .       .       .       .       line that rules
;
; Prepared Codepage Tables (array of these structures)
;
;  Offset  Size         Description     (Table 02971)
;  00h          WORD    software codepage
;  02h          WORD    age
;  04h     9728 BYTEs   codepage data
;
; NUMBER 0: This is special
;

wCPhard         DW       0              ; Hardware codepage
wCPselected     DW      -1              ; Selected codepage

bFont8x8:       times 2048 DB 0         ; space for the 8x8 font
bFont8x14:      times 3584 DB 0         ; space for the 8x14 font
bFont8x16:      times 4096 DB 0         ; space for the 8x16 font

; NUMBER 1
;
; NOTE: all the codepages here should start with Age=1
; (use CodePage=0 if not set, and then fill with 0s)
; most of this is to be discarded when reading bCPMaxArray

SCP1            DW      858
AGE1            DW      1
CPD1            incbin  "cp00858.raw"
;CPD1            times 9728 db 0

; NUMBER 2

SCP2            DW      866
AGE2            DW      1
CPD2            incbin  "cp00866.raw"

; NUMBER 3-5  (no more than 5 is possible)

                DW      0
                DW      1
                times   9728 db 0

                DW      0
                DW      1
                times   9728 db 0

                DW      0
                DW      1
                times   9728 db 0


bLastByte:
;-----------------------------
; End of Resident part
;

pMemTop:        DW      bLastByte


;===================================================================
; MAIN FOR THE .COM VERSION
;
;               .       .       .       .       .       line that rules


                ;****** MAIN ***********
Install:
                push    cs
                call    DoInstall       ; call DoInstall
                jc      Done            ; Carry? then we should exit
                mov     dx,[pMemTop]
                int     27H             ; TSR  for .COM files
Done:           int     20H             ; Exit for .COM files


                ;****** ERROR: driver is already in memory
Already:
                mov     dx,errAlready
OutStrDX:       mov     ah,9
                int     21H
		stc			; Error
                ret			; From DoInstall

                ;****** DoInstall (Install if possible)
                ;****** CF: set on error
DoInstall:

                ;****** show copyright and version

                mov     dx,copyVer
                call    OutStrDX

                ;****** check if already loaded

                mov     ax,0ad00H
                int     2fH
                cmp     al,-1
                jz      Already

                ;****** check if EGA or better

                call    TestAdapter
                mov     dx,errAcient	; driver requires EGA or better
                cmp     al,CGA
                jbe     OutStrDX
                push    ax              ; save AdapterID for later

                ;****** SCAN COMMANDLINE, in STAGES

                cld 
                cli

                push    cs
                pop     es
                push    cs
                pop     ds


                ; 1.- Find the string and capitalize it

                mov     cx, [cs:CommandLine_Offset]
                mov     si, CommandLine_Offset+1
                mov     di, DevName
loop0:          mov     al, [cs:si]
                cmp     al, 13
                je      endUpper
                cmp     al, 'a'
                jb      cont0
                cmp     al, 'z'
                ja      cont0
                sub     al, 'a'-'A'
                mov     [cs:si], al
cont0:          inc     si
                loop    loop0
endUpper:

                ; 2.- Remove starting spaces
    
                mov     cx, [cs:CommandLine_Offset]
                mov     si, CommandLine_Offset+1
loop1:          lodsb
                cmp     al, 13
                jne     skp1
                mov     dx, SES_ParamRequired
                jmp     SyntaxError
skp1:           cmp     al, ' '
                loopne  loop1


                ; 3.- Save device name
                ;     Also block illegal chars (ASCII compatibility
                ;     assumed)

                mov     di, DevName
                mov     cx, 8
loop2:          mov     al, [es:si]
                cmp     al, '='
                je      EndDevName
                cmp     al, ':'
                je      EndDevName
                cmp     al, 13
                jne     skp2
                mov     dx, SES_UnexpectedEOL
                jmp     SyntaxError
skp2:           cmp     al, '/'
                je      illegalChar
                cmp     al, '\'
                je      illegalChar
                cmp     al, '"'
                je      illegalChar
                cmp     al, '*'
                je      illegalChar
                cmp     al, '|'
                je      illegalChar
                cmp     al, '<'         ; illegal chars: '<'..'?'
                jb      cont1
                cmp     al, '?'
                ja      cont1
                cmp     al, '='         ; and =
                je      cont1              
                jmp     illegalChar
cont1:          movsb
                loop    loop2
                mov     dx, SES_NameTooLong
                jmp     SyntaxError

illegalChar:    mov     dx, SES_IllegalChar
                jmp     SyntaxError

EndDevName:
                cmp     al, ':'
                jne     cont2
                inc     si

cont2:          inc     si              ; it was pointing to =
                mov     al, '('
                mov     di, si
                scasb
                je      skp3
                mov     dx, SES_OpenBrExpected
                jmp     SyntaxError
       

                ; 4.- Compare with EGA

skp3:           inc     si
                mov     di, EgaName
                mov     cx, 3
loop3b:         cmpsb
                jne     skp3b
                loop    loop3b
                jmp     EndHwName

skp3b:          mov     dx, SES_WrongHwName
                jmp     SyntaxError     ; only EGA supported

EndHwName:
                mov     di, si
                mov     al, ','
                scasb
                je      jmp4

needC:          mov     dx, SES_CommaExpected
                jmp     SyntaxError
jmp4:           inc     si


                ; 5.- HWCodepage and ArraySize

                call    ReadNumber
                mov     [wCPhard], ax

                mov     di, si
                mov     al,','
                scasb
                jne     needC           ; , expected
                inc     si

                call    ReadNumber
                cmp     al, 5
                jna     numberOk
                mov     dx, SES_TooManyPools
                jmp     SyntaxError
numberOk:       test    al,0ffh
                jnz     jmp4b
                inc     al
jmp4b:          mov     [cs:bCPMaxArray], al

                mov     di, si
                mov     al,')'
                scasb
                je      jmp5
                mov     dx, SES_CloseBrExpected
                jmp     SyntaxError
jmp5:           inc     si


                ; 6.- No more arguments

loop4b:         lodsb
                cmp     al,' '
                je      loop4b
                cmp     al,13
                je      jmp6
                mov     dx, SES_WrongNumberPars
                jmp     SyntaxError     ; wrong # of params specified

jmp6:           sti                     ; success

                ;****** END SCAN COMMANDLINE

                ;****** EVERYTHING IS OK!!
                ;****** set our interrupt vectors

                mov     ax,352fH        ; Get vector 2f
                int     21H
                mov     [dOld2f],bx
                mov     [dOld2f+2],es

                mov     dx,New2f
                mov     ax,252fH        ; Set vector 2f
                int     21H

                mov     ax,3510H        ; Get vector 10
                int     21H
                mov     [dOld10],bx
                mov     [dOld10+2],es

                mov     dx,New10
                mov     ax,2510H        ; Set vector 10
                int     21H

                ;****** Compute the resident size

                xor     ax,ax
                mov     al,[cs:bCPMaxArray]
                dec     al
                mov     dx,CPTableSize
                mul     dx              ; CPTableSize x (MaxArray-1)
                add     ax,SCP2         ; + BeginCodepage2
                mov     [cs:pMemTop],ax

                ;****** Finally, save 4K on EGA

                pop     ax              ; recover the AdapterID
                cmp     al,VGA          ; if not EGA, end
                jae     EndInstall      ; 4096=256*16
                sub     WORD [pMemTop],4096   

                mov     WORD [WTableSize],128*(8+14)

EndInstall:
                ;****** Free environtment space

                mov     ax, [cs:02ch]
                mov     es, ax
                mov     ah, 049h
                int     21h

                clc
                retf


;===================================================================
; INSTALLATION RUNTIME FUNCTIONS
;
;       .       .       .       .       .       .       line that rules

; Fn:   TestAdapter
; In:   (none)
; Out:  AL Video adapter type
; Note: No VESA check yet.

TestAdapter:
                 mov    ax,1a00H        ; Call DCC
                 int    10H
                 cmp    al,1aH
                 jnz    taNoDCC

; Now we know, that have PS/2 Video BIOS.
; Active adapter code is now in BL register

                 cmp    bl,0cH
                 ja     taNoDCC
                 sub    bh,bh
                 mov    al,[tblDCC+bx]
                 cmp    al,bh
                 jnz    taKnowAdapter
taNoDCC:
                 mov    bl,10H          ; Get Configuration Information
                 mov    ah,12H          ; Alternate Select
                 int    10H
                 mov    al,EGA
                 cmp    bl,10H
                 jnz    taKnowAdapter   ; if bh<>0, EGA_MONO

                 int    11H             ; EquipList
                 and    al,30H
                 cmp    al,30H
                 mov    al,MDA
                 jz     taKnowAdapter
                 mov    al,CGA
taKnowAdapter:
                 mov    [bAdapter],al
                 ret


; Fn:   WriteNumber
; In:   AX: number of at most 3 cyphers to be written
; Out:  -
; Note: SyntaxErrorStr space is reused (as it is no longer used when
;       this function is called)
;       I know this is not the most optimal code in the world...

WriteNumber:     mov    di,SyntaxErrorStr     ; reuse the space
                 mov    bx,100
                 call   DWriteCypher
div10:           shr    ax,8
                 mov    bx,10
                 call   DWriteCypher
                 shr    ax,8
                 call   WriteCypher
                 mov    BYTE [es:di],'$'
                 mov    dx, SyntaxErrorStr
                 jmp    OutStrDX              ; write the str and exit

DWriteCypher:    div    bl
                 test   al,0FFh
                 jz     retWC
WriteCypher:     add    al,'0'
                 mov    [es:di],al
                 inc    di
retWC:           ret


; Fn:   SyntaxError
; In:   DX: error string to be displayed
; Out:  -

SyntaxError:     push   dx                 ; save address of string to output
                 mov    dx, SyntaxErrorStr
                 call   OutStrDX

                 mov    ax, si
                 sub    ax, CommandLine_Offset
                 call   WriteNumber

                 pop    dx
                 call   OutStrDX

                 mov    dx, ReturnString
                 call   OutStrDX

                 mov    dx, FastHelpString
                 call   OutStrDX

                 sti
                 stc
                 jmp    Done

; Fn:   ReadNumber
; In:   ES:SI -> a string number of at most 5 cyphers
; Out:  AX the number read
; Note: it stops whenever it finds the first non-number character or
;       whenever 5 characters are read
;       I know this is not the most optimal code in the world...


ReadNumber:      xor    ax,ax
                 xor    bx,bx
                 mov    cx,5
loop5:           cmp    BYTE [es:si],'0'
                 jb     EndReadNumber
                 cmp    BYTE [es:si],'9'
                 ja     EndReadNumber
                 mov    dx, 10             ; DX annihilated by MUL!
                 mul    dx
                 mov    bl, [es:si]
                 add    ax, bx
                 sub    ax, '0'
                 inc    si
                 loop   loop5
EndReadNumber:   ret

;===================================================================
; STRINGS, ARRAYS and STRUCTURES
;
;               .       .       .       .       .       line that rules


tblDCC           DB     NO,MDA,CGA,NO,EGA,EGA,NO,VGA,VGA,NO,MCGA,MCGA,MCGA
EgaName          DB     "EGA"

; Miscellaneous DISPLAY loading error messages
errAlready       DB     "DISPLAY is already loaded", 0dH, 0aH, "$"
errAcient        DB     "DISPLAY needs at least EGA adapter", 0dH, 0aH, "$"

; Copyright message
%ifdef DEBUG
copyVer          DB     "FreeDOS DISPLAY ver. 0.08 (DEBUG)", 0dH, 0aH, "$"
%else
copyVer          DB     "FreeDOS DISPLAY ver. 0.08", 0dH, 0aH, "$"
%endif

; Commandline parsing error messages
SyntaxErrorStr:         DB      "Syntax error($"
SES_ParamRequired       DB      ") Missing required parameter", 0dH, 0aH, "$"
SES_UnexpectedEOL       DB      ") Unexpected end of line", 0dH, 0aH, "$"
SES_IllegalChar         DB      ") Illegal character", 0dH, 0aH, "$"
SES_NameTooLong         DB      ") Device driver name too long", 0dH, 0aH, "$"
SES_OpenBrExpected      DB      ") ( expected", 0dH, 0aH, "$"
SES_WrongHwName         DB      ") Unknown hardware device name", 0dH, 0aH, "$"
SES_CommaExpected       DB      ") , expected", 0dH, 0aH, "$"
SES_CloseBrExpected     DB      ") ) expected", 0dH, 0aH, "$"
SES_WrongNumberPars     DB      ") Wrong number of parameters", 0dH, 0aH, "$"
SES_TooManyPools        DB      ") Too many codepage pools (MAX=8)", 0dH, 0aH, "$"
ReturnString            DB      0dH, 0aH, "$"
FastHelpString          DB      "    DISPLAY  devname[:]=(EGA,hardwareCP,number_pools)", 0dH, 0aH, "$"


                 END
