
/************************************************************************/
/*                                                                      */
/* FILE: scan.c                                                         */
/* Command line lexical support and argument parsing.                   */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


#include "globals.h"


void parsing (char*, char FAR*, void*, ...);
BOOL expand (REG char*, char**);
char *skipwh (char*);
char FAR *fskipwh (char FAR*);
BOOL issep (char);
char *scanfile (char*);
int num_args (char*);


/* -------------------------------------------------------------------- */
/* parsing - Reusable command line parsing function                     */
/* -------------------------------------------------------------------- */

void parsing(char *fmt, char FAR *s, void *args, ...)
{
    void **argp = &args, **startp;
    char *start;
    char *str;
    unsigned int size, max_size;

    while(*fmt != '\0' && *s != '\0' && *s != '\r' && *s != '\n')
    {
        switch(*fmt)
        {
        case 'D':
            s = fskipwh(s);
            if(s[1] == ':')
            {
                *((int *)(*argp)) = ((toupper(*s)) - 'A');
                s = &s[2];
            }
            else
                *((int *)(*argp))++ = -1;
            ++((int **)argp);
            ++fmt;

            if(*fmt == 'P')
            {
                size = 1;
                while(!issep(*s) && size < MAX_CMDLINE)
                {
                    *((char *)(*argp))++ = *s++;
                    size++;
                }
                if(size == MAX_CMDLINE)
                {
                    while(!issep(*s))
                        s++;
                    error_message(CMDLINE_LONG);
                }
                *((char *)(*argp))++ = '\0';
                ++((char **)argp);
                ++fmt;
                break;
            }

        case '[':
            start = fmt;
            startp = argp;
            s = fskipwh(s);
            if(*s == switchchar)
            {
                s++;
                while(!issep(*s))
                {
                    ++fmt;

                    while(*fmt != ']')
                    {
                        if(*fmt == ':')
                        {
                            while(isdigit(*++fmt));
                            continue;
                        }
                        if(*fmt++ == toupper(*s))
                        {
                            if(*fmt == ':')
                            {
                                ++s;
                                if(*s == ':')
                                {
                                    ++s;
                                    size = 1;
                                    max_size = 0;
                                    while(isdigit(*(++fmt)))
                                        max_size = max_size * 10 + tonum(*fmt);
                                    str = (char*)*argp;
                                    while(!issep(*s) && size < max_size)
                                    {
                                        *str++ = *s++;
                                        size++;
                                    }
                                    if(size == max_size)
                                    {
                                        str = (char*)*argp;
                                        str[0] = ' ';
                                        str[1] = '\0';
                                        while(!issep(*s))
                                            s++;
                                    }
                                    else
                                        *str = '\0';
                                }
                                else
                                {
                                    *((char *)(*argp))++ = ' ';
                                    *((char *)(*argp)) = '\0';
                                }
                            }
                            else
                            {
                                *((BOOL *)(*argp)) = TRUE;
                                if(*fmt == '.')
                                    s = (char FAR *)"";
                                else
                                    s++;
                            }

                            while(*fmt++ != ']')
                            {
                                if(*fmt == ':')
                                {
                                    fmt++;
                                    while(isdigit(*fmt))
                                        fmt++;
                                    ++((char **)argp);
                                }
                                else
                                    ++((BOOL **)argp);
                            }
                            --fmt;
                        }
                        else
                        {
                            if(*fmt == ':')
                                ++((char **)argp);
                            else
                                ++((BOOL **)argp);
                        }
                    }

                    if(*(fmt+1) == '+')
                    {
                        argp = startp;
                        fmt = start;
                    }
                    else
                    {
                        fmt++;
                        break;
                    }
                }
            }
            else
            {
                while(!issep(*s))
                    ++s;
            }
            break;
        }
    }
}


/* -------------------------------------------------------------------- */
/* expand - Expand command line variables                               */
/* -------------------------------------------------------------------- */

BOOL expand(REG char *s, char **posparam)
{
    int idx;
    char *pointer;
    REG char *d = cmd_buffer;
    char *limit = cmd_buffer+MAX_CMDBUFFER;
    char FAR *p_env;

    s = skipwh(s);

    while(*s)
    {
        if(batch_flag && *s == '%' && isdigit(s[1]))
        {
            idx = tonum(*++s);
            if(!strncpy(d, posparam[idx], limit-d))
                return FALSE;
            s++;
            d += strlen(posparam[idx]);
        }
        else if(*s == '%' && *(s+1) == '%')
        {
            *d++ = *s++;
            s++;
        }
        else if(*s == '%')
        {
            ++s;
            pointer = s;

            /* skip until next % and see if the string between is an */
            /* environment variable */

            while(*s != '\0' && *s != '\r' && *s != '\n' && *s != ' ' && *s != '\t' && *s != '%')
                s++;

            if(*s == '%')
            {
                /* lookup in environment and substitute */
                *s = '\0';
                p_env = EnvLookup(pointer);
                if(*p_env != '\0')
                {
                    if(!fstrncpy((char FAR*)d, p_env, limit-d))
                        return FALSE;
                    d += fstrlen(p_env);
                }
                *s++ = '%';
            }
            else
            {
                /* can't be an environment variable so add to command line */
                *d++ = '%';
                s = pointer;
            }
        }
        else
            *d++ = *s++;
    }

    *d = '\0';
    return TRUE;
}


/* -------------------------------------------------------------------- */
/* skipwh, fskipwh                                                      */
/* -------------------------------------------------------------------- */

char *skipwh(char *s)
{
    while(*s && *s != '\r' && *s != '\n' && (*s == ' ' || *s == '\t'))
        ++s;
    return s;
}


char FAR *fskipwh(char FAR *s)
{
    while(*s && *s != '\r' && *s != '\n' && (*s == ' ' || *s == '\t'))
        ++s;
    return s;
}


/* -------------------------------------------------------------------- */
/* issep                                                                */
/* -------------------------------------------------------------------- */

BOOL issep(char c)
{
    return(c == '\0' || c == '\r' || c == '\n' || c == ' ' || c == '\t' || c == switchchar);
}


/* -------------------------------------------------------------------- */
/* scanfile                                                             */
/* -------------------------------------------------------------------- */

char *scanfile(char *path)
{
    char *pointer = path;

    while(!issep(*path))
    {
        if(*path++ == '\\')
            pointer = path;
    }
    return pointer;
}


/* -------------------------------------------------------------------- */
/* checkfile                                                            */
/* -------------------------------------------------------------------- */

BOOL checkfile(char *fname)
{
    char *pointer;
    unsigned int n = 0;

    pointer = fname;
    while(!issep(*pointer))
    {
        pointer++;
        n++;
    }

    return (n <= FNAME_MAX);
}


/* -------------------------------------------------------------------- */
/* num_args                                                             */
/* -------------------------------------------------------------------- */

int num_args(char *arguments)
{
    int c = 0;
    while(*arguments != '\0')
    {
        arguments = skipwh(arguments);
        if(*arguments != '\0')
        {
            c++;
            while(!issep(*++arguments));
        }
    }
    return c;
}
