/*
 *  CMDTABLE.C - table of internal commands.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *   New file to keep the internal command table. I plan on
 *   getting rid of the table real soon now and replacing it
 *   with a dynamic mechnism.
 *
 *
 * 27 Jul 1998  John P. Price
 * - added config.h include
 *
 *
 */

#include <stdlib.h>

#include "config.h"
#include "command.h"

/* a list of all the internal commands, associating their command names */
/* to the functions to process them                                     */

/* Lines marked
 *
 * $$ are external commands
 * !! internal commands which are not yet implemented
 * ** special FREEDOS specific implementation
 */

struct CMD
  cmds[] =
{
#ifdef FEATURE_ALIASES
  {"alias",    0, cmd_alias},      /* **   */
#endif

#ifdef INCLUDE_CMD_BEEP
  {"beep",     0, cmd_beep},        /* **   */
#endif

/*{"break",    0,             cmd_break     },    !!    */

  {"call", CMD_BATCHONLY, cmd_call},

#ifdef INCLUDE_CMD_CHDIR
  {"cd", CMD_SPECIAL, cmd_chdir},
  {"chdir", CMD_SPECIAL, cmd_chdir},
#endif

/*    { "chcp",     0,             cmd_chcp      },    !!    */

#ifdef INCLUDE_CMD_CLS
  {"cls",      0,             cmd_cls       },
#endif

/*    { "copy",     0,             cmd_copy      },    !!    */

/*    { "ctty",     0,             cmd_ctty      },    !!    */

#ifdef INCLUDE_CMD_DATE
  {"date", 0, cmd_date},
#endif

#ifdef INCLUDE_CMD_DEL
  {"del", 0, cmd_del},
#endif

#ifdef INCLUDE_CMD_DIR
  {"dir", CMD_SPECIAL, cmd_dir},
#endif

#ifdef FEATURE_HISTORY
  {"doskey", 0, cmd_doskey},    /* **   */
#endif

  {"echo", 0, cmd_echo},

#ifdef INCLUDE_CMD_DEL
  {"erase", 0, cmd_del},
#endif

  {"exit", 0, internal_exit},

  {"for", 0, cmd_for},

  {"goto", CMD_BATCHONLY, cmd_goto},

  {"if", 0, cmd_if},

#ifdef INCLUDE_CMD_LOADHIGH
  {"lh", 0, cmd_loadhigh},
#endif

#ifdef INCLUDE_CMD_LOADFIX
  {"loadfix", 0, cmd_loadfix},
#endif

#ifdef INCLUDE_CMD_LOADHIGH
  {"loadhigh", 0, cmd_loadhigh},
#endif

#ifdef INCLUDE_CMD_MKDIR
  {"md", CMD_SPECIAL, cmd_mkdir},
  {"mkdir", CMD_SPECIAL, cmd_mkdir},
#endif

#ifdef INCLUDE_CMD_PATH
  {"path", 0, cmd_path},
#endif

#ifdef INCLUDE_CMD_PAUSE
  {"pause", 0, cmd_pause},
#endif

#ifdef INCLUDE_CMD_PROMPT
  {"prompt", 0, cmd_prompt},
#endif

#ifdef INCLUDE_CMD_RMDIR
  {"rd", CMD_SPECIAL, cmd_rmdir},
#endif

#ifdef INCLUDE_CMD_REM
  {"rem", 0, cmd_rem},
#endif

#ifdef INCLUDE_CMD_RENAME
  {"ren", 0, cmd_rename},
  {"rename", 0, cmd_rename},
#endif

#ifdef INCLUDE_CMD_RMDIR
  {"rmdir", CMD_SPECIAL, cmd_rmdir},
#endif

#ifdef INCLUDE_CMD_SET
  {"set", 0, cmd_set},
#endif

  {"shift", CMD_BATCHONLY, cmd_shift},

#ifdef INCLUDE_CMD_TIME
  {"time", 0, cmd_time},
#endif

#ifdef INCLUDE_CMD_TRUENAME
  {"truename", 0, cmd_truename},
#endif

#ifdef INCLUDE_CMD_TYPE
  {"type", 0, cmd_type},
#endif

#ifdef INCLUDE_CMD_VER
  {"ver", 0, cmd_ver},
#endif

#ifdef INCLUDE_CMD_VERIFY
  { "verify",   0,             cmd_verify    },
#endif

  {NULL, 0, NULL}
};

/*    append,                             $$    */
/*    assign,                             $$    */
/*    attrib,                             $$    */
/*    backup,                             $$    */
/*    chkdsk,                             $$    */
/*    command,                              $$    */
/*    comp,                               $$    */
/*    debug,                              $$    */
/*    diskcomp,                           $$    */
/*    diskcopy,                           $$    */
/*    doskey,                             **    */
/*    dosshell,                           $$    */
/*    edit,                               $$    */
/*    edlin,                              $$    */
/*    emm386,                             $$    */
/*    exe2bin,                              $$    */
/*    expand,                             $$    */
/*    fastopen,                           $$    */
/*    fc,                                 $$    */
/*    fdisk,                              $$    */
/*    find,                               $$    */
/*    format,                             $$    */
/*    graftabl,                           $$    */
/*    graphics,                           $$    */
/*    help,                               $$    */
/*    join,                               $$    */
/*    keyb,                               $$    */
/*    label,                              $$    */
/*    mem,                                $$    */
/*    mirror,                             $$    */
/*    mode,                               $$    */
/*    more,                               $$    */
/*    nlsfunc,                              $$    */
/*    print,                              $$    */
/*    qbasic,                             $$    */
/*    recover,                              $$    */
/*    replace,                              $$    */
/*    restore,                              $$    */
/*    setver,                             $$    */
/*    share,                              $$    */
/*    sort,                               $$    */
/*    subst,                              $$    */
/*    sys,                                $$    */
/*    tree,                                $$    */
/*    undelete,                           $$    */
/*    unformat,                           $$    */
/*    xcopy,                              $$    */
